/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.condition;

import eu.dnetlib.pace.common.AbstractPaceFunctions;
import eu.dnetlib.pace.condition.ConditionAlgo;
import eu.dnetlib.pace.config.Cond;
import eu.dnetlib.pace.distance.eval.ConditionEval;
import eu.dnetlib.pace.distance.eval.ConditionEvalMap;
import eu.dnetlib.pace.model.Document;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldDef;
import java.util.List;

public abstract class AbstractCondition
extends AbstractPaceFunctions
implements ConditionAlgo {
    protected Cond cond;
    protected List<FieldDef> fields;

    public AbstractCondition(Cond cond, List<FieldDef> fields) {
        this.cond = cond;
        this.fields = fields;
    }

    protected abstract ConditionEval verify(FieldDef var1, Field var2, Field var3);

    @Override
    public ConditionEvalMap verify(Document a, Document b) {
        ConditionEvalMap res = new ConditionEvalMap();
        for (FieldDef fd : this.getFields()) {
            Field va = a.values(fd.getName());
            Field vb = b.values(fd.getName());
            if ((va.isEmpty() || vb.isEmpty()) && fd.isIgnoreMissing()) continue;
            res.put(fd.getName(), this.verify(fd, va, vb));
        }
        return res;
    }

    public List<FieldDef> getFields() {
        return this.fields;
    }
}

