/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.condition;

import eu.dnetlib.pace.condition.AbstractCondition;
import eu.dnetlib.pace.config.Cond;
import eu.dnetlib.pace.distance.eval.ConditionEval;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldDef;
import eu.dnetlib.pace.model.FieldList;
import eu.dnetlib.pace.model.adaptor.Pid;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PidMatch
extends AbstractCondition {
    private static final Log log = LogFactory.getLog(PidMatch.class);

    public PidMatch(Cond cond, List<FieldDef> fields) {
        super(cond, fields);
    }

    @Override
    protected ConditionEval verify(FieldDef fd, Field a, Field b) {
        List<String> sa = ((FieldList)a).stringList();
        List<String> sb = ((FieldList)b).stringList();
        List<Pid> pal = Pid.fromOafJson(sa);
        List<Pid> pbl = Pid.fromOafJson(sb);
        int result = 0;
        for (Pid pa : pal) {
            String ta = pa.getType();
            for (Pid pb : pbl) {
                String tb = pb.getType();
                if (!tb.equalsIgnoreCase(ta)) continue;
                result += pa.getValue().equalsIgnoreCase(pb.getValue()) ? 1 : -1;
            }
        }
        return new ConditionEval(this.cond, a, b, result);
    }
}

