/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.condition;

import eu.dnetlib.pace.condition.AbstractCondition;
import eu.dnetlib.pace.config.Cond;
import eu.dnetlib.pace.distance.eval.ConditionEval;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldDef;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class YearMatch
extends AbstractCondition {
    private int limit = 4;

    public YearMatch(Cond cond, List<FieldDef> fields) {
        super(cond, fields);
    }

    @Override
    protected ConditionEval verify(FieldDef fd, Field a, Field b) {
        String valueA = this.getNumbers(this.getFirstValue(a));
        String valueB = this.getNumbers(this.getFirstValue(b));
        boolean lengthMatch = this.checkLength(valueA) && this.checkLength(valueB);
        boolean onemissing = valueA.isEmpty() || valueB.isEmpty();
        return new ConditionEval(this.cond, a, b, lengthMatch && valueA.equals(valueB) || onemissing ? 1 : -1);
    }

    protected boolean checkLength(String s) {
        return s.length() == this.limit;
    }

    protected String getFirstValue(List<Field> values) {
        return values != null && !values.isEmpty() ? StringUtils.left((String)values.get(0).stringValue(), (int)this.limit) : null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + super.toString();
    }
}

