/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.distance;

import eu.dnetlib.pace.condition.ConditionAlgo;
import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.distance.eval.ConditionEvalMap;
import eu.dnetlib.pace.distance.eval.DistanceEval;
import eu.dnetlib.pace.distance.eval.DistanceEvalMap;
import eu.dnetlib.pace.distance.eval.ScoreResult;
import eu.dnetlib.pace.model.Document;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldDef;
import java.util.Collection;
import java.util.List;

public class DistanceScorer {
    private Config config;

    public DistanceScorer(Config config) {
        this.config = config;
    }

    public ScoreResult distance(Document a, Document b) {
        ScoreResult sr = new ScoreResult();
        sr.setStrictConditions(this.verify(a, b, this.config.strictConditions()));
        sr.setConditions(this.verify(a, b, this.config.conditions()));
        DistanceEvalMap dMap = new DistanceEvalMap(this.sumWeights(this.config.model()));
        for (FieldDef fd : this.config.model()) {
            dMap.updateDistance(this.fieldDistance(a, b, fd));
        }
        sr.setDistances(dMap);
        return sr;
    }

    private ConditionEvalMap verify(Document a, Document b, List<ConditionAlgo> conditions) {
        ConditionEvalMap res = new ConditionEvalMap();
        for (ConditionAlgo cd : conditions) {
            ConditionEvalMap map = cd.verify(a, b);
            res.mergeFrom(map);
            if (!map.anyNegative()) continue;
            return res;
        }
        return res;
    }

    private DistanceEval fieldDistance(Document a, Document b, FieldDef fd) {
        double w = fd.getWeight();
        Field va = this.getValue(a, fd);
        Field vb = this.getValue(b, fd);
        DistanceEval de = new DistanceEval(fd, va, vb);
        if (w == 0.0) {
            return de;
        }
        if (va.isEmpty() || vb.isEmpty()) {
            if (fd.isIgnoreMissing()) {
                de.setDistance(-1.0);
            } else {
                de.setDistance(w);
            }
        } else if (va.getType().equals((Object)vb.getType())) {
            de.setDistance(w * fd.getDistanceAlgo().distance(va, vb));
        } else {
            throw new IllegalArgumentException(String.format("Types are differents type: %s:%s - %s:%s", new Object[]{va, va.getType(), vb, vb.getType()}));
        }
        return de;
    }

    private Field getValue(Document d, FieldDef fd) {
        return d.values(fd.getName());
    }

    private double sumWeights(Collection<FieldDef> fields) {
        double sum = 0.0;
        for (FieldDef fd : fields) {
            sum += fd.getWeight();
        }
        return sum;
    }
}

