/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.distance.algo;

import com.wcohen.ss.AbstractStringDistance;
import com.wcohen.ss.Levenstein;
import eu.dnetlib.pace.config.Type;
import eu.dnetlib.pace.distance.SecondStringDistanceAlgo;
import eu.dnetlib.pace.model.Field;
import org.apache.commons.lang3.StringUtils;

public class SubStringLevenstein
extends SecondStringDistanceAlgo {
    protected int limit;

    public SubStringLevenstein(double w) {
        super(w, (AbstractStringDistance)new Levenstein());
    }

    public SubStringLevenstein(double w, int limit) {
        super(w, (AbstractStringDistance)new Levenstein());
        this.limit = limit;
    }

    protected SubStringLevenstein(double w, int limit, AbstractStringDistance ssalgo) {
        super(w, ssalgo);
        this.limit = limit;
    }

    @Override
    public double distance(Field a, Field b) {
        if (a.getType().equals((Object)Type.String) && b.getType().equals((Object)Type.String)) {
            return this.distance(StringUtils.left((String)a.stringValue(), (int)this.limit), StringUtils.left((String)b.stringValue(), (int)this.limit));
        }
        throw new IllegalArgumentException("invalid types\n- A: " + a.toString() + "\n- B: " + b.toString());
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    protected double normalize(double d) {
        return 1.0 / Math.pow(Math.abs(d) + 1.0, 0.1);
    }
}

