package eu.dnetlib.pace.condition;

import java.util.List;

import eu.dnetlib.pace.config.Cond;
import eu.dnetlib.pace.distance.eval.ConditionEval;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldDef;

/**
 * The Class ExactMatch.
 *
 * @author claudio
 */
public class ExactMatch extends AbstractCondition {

	public ExactMatch(final Cond cond, final List<FieldDef> fields) {
		super(cond, fields);
	}

	@Override
	protected ConditionEval verify(final FieldDef fd, final Field a, final Field b) {

		final String fa = getValue(a);
		final String fb = getValue(b);

		return new ConditionEval(cond, a, b, fa.equals(fb) ? 1 : -1);
	}

	protected String getValue(final Field f) {
		return getFirstValue(f);
	}

}
