/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.model;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import eu.dnetlib.pace.config.Algo;
import eu.dnetlib.pace.config.Type;
import eu.dnetlib.pace.distance.DistanceAlgo;
import eu.dnetlib.pace.distance.algo.AlwaysMatch;
import eu.dnetlib.pace.distance.algo.ExactMatch;
import eu.dnetlib.pace.distance.algo.JaroWinkler;
import eu.dnetlib.pace.distance.algo.JaroWinklerTitle;
import eu.dnetlib.pace.distance.algo.Level2JaroWinkler;
import eu.dnetlib.pace.distance.algo.Level2JaroWinklerTitle;
import eu.dnetlib.pace.distance.algo.Level2Levenstein;
import eu.dnetlib.pace.distance.algo.Levenstein;
import eu.dnetlib.pace.distance.algo.LevensteinTitle;
import eu.dnetlib.pace.distance.algo.MustBeDifferent;
import eu.dnetlib.pace.distance.algo.NullDistanceAlgo;
import eu.dnetlib.pace.distance.algo.PersonCoAnchorsDistance;
import eu.dnetlib.pace.distance.algo.PersonCoAuthorSurnamesDistance;
import eu.dnetlib.pace.distance.algo.PersonDistance;
import eu.dnetlib.pace.distance.algo.SortedJaroWinkler;
import eu.dnetlib.pace.distance.algo.SortedLevel2JaroWinkler;
import eu.dnetlib.pace.distance.algo.SubStringLevenstein;
import eu.dnetlib.pace.distance.algo.YearLevenstein;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldListImpl;
import eu.dnetlib.pace.model.FieldValueImpl;
import java.util.List;
import java.util.Map;

public class FieldDef {
    public static final String PATH_SEPARATOR = "/";
    private Algo algo;
    private String name;
    private String path;
    private boolean ignoreMissing;
    private Type type;
    private boolean overrideMatch;
    private double weight;
    private int limit = -1;
    private Map<String, String> params;

    public Field apply(Type type, String s) {
        switch (type) {
            case Int: {
                return new FieldValueImpl(type, this.name, Integer.parseInt(s));
            }
            case String: {
                return new FieldValueImpl(type, this.name, s);
            }
            case List: {
                return new FieldListImpl(this.name, type);
            }
        }
        throw new IllegalArgumentException("Casting not implemented for type " + (Object)((Object)type));
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public List<String> getPathList() {
        return Lists.newArrayList((Iterable)Splitter.on((String)PATH_SEPARATOR).split((CharSequence)this.getPath()));
    }

    public DistanceAlgo getDistanceAlgo() {
        switch (this.getAlgo()) {
            case JaroWinkler: {
                return new JaroWinkler(this.getWeight());
            }
            case JaroWinklerTitle: {
                return new JaroWinklerTitle(this.getWeight());
            }
            case Level2JaroWinkler: {
                return new Level2JaroWinkler(this.getWeight());
            }
            case Level2JaroWinklerTitle: {
                return new Level2JaroWinklerTitle(this.getWeight());
            }
            case Level2Levenstein: {
                return new Level2Levenstein(this.getWeight());
            }
            case Levenstein: {
                return new Levenstein(this.getWeight());
            }
            case LevensteinTitle: {
                return new LevensteinTitle(this.getWeight());
            }
            case SubStringLevenstein: {
                return new SubStringLevenstein(this.getWeight(), this.getLimit());
            }
            case YearLevenstein: {
                return new YearLevenstein(this.getWeight(), this.getLimit());
            }
            case SortedJaroWinkler: {
                return new SortedJaroWinkler(this.getWeight());
            }
            case SortedLevel2JaroWinkler: {
                return new SortedLevel2JaroWinkler(this.getWeight());
            }
            case ExactMatch: {
                return new ExactMatch(this.getWeight());
            }
            case MustBeDifferent: {
                return new MustBeDifferent(this.getWeight());
            }
            case AlwaysMatch: {
                return new AlwaysMatch(this.getWeight());
            }
            case PersonCoAnchorsDistance: {
                return new PersonCoAnchorsDistance(this.getParams(), this.getWeight());
            }
            case PersonCoAuthorSurnamesDistance: {
                return new PersonCoAuthorSurnamesDistance(this.getParams(), this.getWeight());
            }
            case PersonDistance: {
                return new PersonDistance(this.getParams(), this.getWeight());
            }
            case Null: {
                return new NullDistanceAlgo();
            }
        }
        return new NullDistanceAlgo();
    }

    public boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean isOverrideMatch() {
        return this.overrideMatch;
    }

    public void setOverrideMatch(boolean overrideMatch) {
        this.overrideMatch = overrideMatch;
    }

    public String toString() {
        return new Gson().toJson((Object)this);
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public Algo getAlgo() {
        return this.algo;
    }

    public void setAlgo(Algo algo) {
        this.algo = algo;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public void setIgnoreMissing(boolean ignoreMissing) {
        this.ignoreMissing = ignoreMissing;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setName(String name) {
        this.name = name;
    }
}

