/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.model.adaptor;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import eu.dnetlib.pace.model.adaptor.Pid;
import java.lang.reflect.Type;

public class PidOafSerialiser
implements JsonDeserializer<Pid> {
    private static final String VALUE = "value";
    private static final String QUALIFIER = "qualifier";
    private static final String CLASSID = "classid";

    public Pid deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Pid pid = new Pid();
        pid.setType(this.getType(json));
        pid.setValue(this.getValue(json));
        return pid;
    }

    private String getValue(JsonElement json) {
        JsonObject obj = json.getAsJsonObject();
        return obj.get(VALUE).getAsString();
    }

    private String getType(JsonElement json) {
        if (!json.isJsonObject()) {
            throw new IllegalArgumentException(String.format("invalid argument: '%s'", json.toString()));
        }
        JsonObject obj = json.getAsJsonObject();
        if (!obj.has(QUALIFIER)) {
            throw new IllegalArgumentException("pid does not contain any type: " + json.toString());
        }
        JsonObject qualifier = obj.getAsJsonObject(QUALIFIER);
        JsonElement classid = qualifier.get(CLASSID);
        return classid.getAsString();
    }
}

