/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.model.gt;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import eu.dnetlib.pace.model.gt.Match;
import eu.dnetlib.pace.model.gt.SubjectsMap;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class Author
implements Comparable<Author> {
    private String id;
    private String fullname;
    private String firstname;
    private String secondnames;
    private List<Match> matches = Lists.newArrayList();
    private Set<Author> coauthors = Sets.newHashSet();
    private SubjectsMap subjectsMap = new SubjectsMap();

    public Author() {
    }

    public Author(Author a) {
        this.id = a.getId();
        this.fullname = a.getFullname();
        this.firstname = a.getFirstname();
        this.secondnames = a.getSecondnames();
        this.matches = a.getMatches();
        this.coauthors = a.getCoauthors();
        this.subjectsMap = a.getSubjectsMap();
    }

    public boolean hasMatches() {
        return this.getMatches() != null && !this.getMatches().isEmpty();
    }

    public boolean hasCoauthors() {
        return this.getCoauthors() != null && !this.getCoauthors().isEmpty();
    }

    public boolean isWellFormed() {
        return StringUtils.isNotBlank((CharSequence)this.getSecondnames()) && StringUtils.isNotBlank((CharSequence)this.getFirstname());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public String getSecondnames() {
        return this.secondnames;
    }

    public void setSecondnames(String secondnames) {
        this.secondnames = secondnames;
    }

    public List<Match> getMatches() {
        return this.matches;
    }

    public void setMatches(List<Match> matches) {
        this.matches = matches;
    }

    public Set<Author> getCoauthors() {
        return this.coauthors;
    }

    public void setCoauthors(Set<Author> coauthors) {
        this.coauthors = coauthors;
    }

    public String toString() {
        return new Gson().toJson((Object)this);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    @Override
    public int compareTo(Author o) {
        return ComparisonChain.start().compare((Object)this.getId(), (Object)o.getId(), (Comparator)Ordering.natural().nullsLast()).result();
    }

    public boolean equals(Object o) {
        return o instanceof Author && this.getId().equals(((Author)o).getId());
    }

    public SubjectsMap getSubjectsMap() {
        return this.subjectsMap;
    }

    public void setSubjectsMap(SubjectsMap subjectsMap) {
        this.subjectsMap = subjectsMap;
    }
}

