/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.parthenos.virtuoso;

import com.google.common.collect.Maps;
import eu.dnetlib.miscutils.functional.xml.SaxonHelper;
import java.util.HashMap;
import java.util.Map;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathSelector;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import virtuoso.jena.driver.VirtModel;

public class VirtuosoClient {
    private static final Log log = LogFactory.getLog(VirtuosoClient.class);
    private static final String OAI_NAMESPACE_URI = "http://www.openarchives.org/OAI/2.0/";
    private static final String DRI_NAMESPACE_URI = "http://www.driver-repository.eu/namespace/dri";
    private static final String RDF_NAMESPACE_URI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private SaxonHelper saxonHelper;
    private XPathSelector xpathSelectorObjIdentifier;
    private XPathSelector xpathSelectorCollectionDate;
    private XPathSelector xpathSelectorTransformationDate;
    private XPathSelector xpathSelectorDatasourceName;
    private XPathSelector xpathSelectorRDF;
    private String connectionString;
    private String username;
    private String password;
    private String defaultBaseURI;

    protected VirtuosoClient(String connectionString, String username, String password, SaxonHelper saxonHelper, String defaultBaseURI) throws SaxonApiException {
        this.connectionString = connectionString;
        this.username = username;
        this.password = password;
        this.saxonHelper = saxonHelper;
        this.defaultBaseURI = defaultBaseURI;
        this.prepareXpathSelectors();
    }

    public long feed(String record) {
        if (StringUtils.isBlank((CharSequence)record)) {
            log.warn((Object)"Got empty record");
            return 0L;
        }
        String objIdentifier = this.extractFromRecord(record, this.xpathSelectorObjIdentifier);
        if (StringUtils.isBlank((CharSequence)objIdentifier)) {
            log.warn((Object)"Got record with no objIdentifier -- skipping");
            return 0L;
        }
        String rdfBlock = this.extractFromRecord(record, this.xpathSelectorRDF);
        if (StringUtils.isBlank((CharSequence)rdfBlock)) {
            log.warn((Object)("Missing rdf:RDF in record with objIdentifier " + objIdentifier + " all triples in that named graph will be deleted"));
        }
        String collectionDate = this.extractFromRecord(record, this.xpathSelectorCollectionDate);
        String transformationDate = this.extractFromRecord(record, this.xpathSelectorTransformationDate);
        String datasource = this.extractFromRecord(record, this.xpathSelectorDatasourceName);
        VirtModel md = VirtModel.openDatabaseModel((String)objIdentifier, (String)this.getConnectionString(), (String)this.getUsername(), (String)this.getPassword());
        log.debug((Object)("Opened virtuoso model for graph " + objIdentifier));
        md.removeAll();
        log.debug((Object)("Removed all triples from graph " + objIdentifier));
        md.read(IOUtils.toInputStream((String)rdfBlock), this.getDefaultBaseURI());
        long size = md.size();
        log.info((Object)("Graph " + objIdentifier + " now has " + size + " triples"));
        long ntriples = this.feedProvenance(objIdentifier, collectionDate, transformationDate, datasource);
        log.debug((Object)("provenance graph updated with " + ntriples + " triples"));
        return size;
    }

    long feedProvenance(String objIdentifier, String collectionDate, String transformationDate, String datasource) {
        VirtModel md = VirtModel.openDatabaseModel((String)"provenance", (String)this.getConnectionString(), (String)this.getUsername(), (String)this.getPassword());
        Resource r = ResourceFactory.createResource((String)this.getRecordDefaultURI(objIdentifier, datasource));
        Statement stmCollFrom = ResourceFactory.createStatement((Resource)r, (Property)ResourceFactory.createProperty((String)"dnet", (String)"collectedFrom"), (RDFNode)ResourceFactory.createPlainLiteral((String)datasource));
        Statement stmCollDate = ResourceFactory.createStatement((Resource)r, (Property)ResourceFactory.createProperty((String)"dnet", (String)"collectedInDate"), (RDFNode)ResourceFactory.createPlainLiteral((String)collectionDate));
        Statement stmTransDate = ResourceFactory.createStatement((Resource)r, (Property)ResourceFactory.createProperty((String)"dnet", (String)"transformedInDate"), (RDFNode)ResourceFactory.createPlainLiteral((String)transformationDate));
        md.removeAll(r, null, null);
        md.add(stmCollDate).add(stmCollFrom).add(stmTransDate);
        return 3L;
    }

    public long feed(Iterable<String> records) {
        long count = 0L;
        for (String r : records) {
            count += this.feed(r);
        }
        return count;
    }

    private String getRecordDefaultURI(String objIdentifier, String datasource) {
        return this.defaultBaseURI + datasource + "/" + objIdentifier;
    }

    private void prepareXpathSelectors() throws SaxonApiException {
        HashMap namespaces = Maps.newHashMap();
        namespaces.put("oai", OAI_NAMESPACE_URI);
        namespaces.put("dri", DRI_NAMESPACE_URI);
        namespaces.put("rdf", RDF_NAMESPACE_URI);
        this.xpathSelectorObjIdentifier = this.saxonHelper.help().prepareXPathSelector("//oai:header/dri:objIdentifier/text()", (Map)namespaces);
        this.xpathSelectorCollectionDate = this.saxonHelper.help().prepareXPathSelector("//oai:header/dri:dateOfCollection/text()", (Map)namespaces);
        this.xpathSelectorTransformationDate = this.saxonHelper.help().prepareXPathSelector("//oai:header/dri:dateOfTransformation/text()", (Map)namespaces);
        this.xpathSelectorDatasourceName = this.saxonHelper.help().prepareXPathSelector("//oai:header/dri:datasourcename/text()", (Map)namespaces);
        this.xpathSelectorRDF = this.saxonHelper.help().prepareXPathSelector("//oai:metadata/rdf:RDF", (Map)namespaces);
    }

    private String extractFromRecord(String record, XPathSelector xPathSelector) {
        try {
            return this.saxonHelper.help().setSerializerProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes").evaluateSingleAsString(record, xPathSelector);
        }
        catch (SaxonApiException e) {
            throw new RuntimeException("Cannot extract content ", e);
        }
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public SaxonHelper getSaxonHelper() {
        return this.saxonHelper;
    }

    public String getDefaultBaseURI() {
        return this.defaultBaseURI;
    }
}

