package eu.dnetlib.msro.workflows.nodes.parthenos.virtuoso;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.parthenos.virtuoso.VirtuosoClient;
import eu.dnetlib.parthenos.virtuoso.VirtuosoClientFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DropFromVirtuosoJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(DropFromVirtuosoJobNode.class);

	private String datasourceInterface;

	@Autowired
	private VirtuosoClientFactory virtuosoClientFactory;

	@Override
	protected String execute(final Env env) throws Exception {

		VirtuosoClient virtuosoClient = this.virtuosoClientFactory.getVirtuosoClient();
		long nTriples = virtuosoClient.drop(getDatasourceInterface());
		log.info("Deleted " + nTriples + " triples in Virtuoso server");

		env.setAttribute("triples", nTriples);
		return Arc.DEFAULT_ARC;

	}

	public VirtuosoClientFactory getVirtuosoClientFactory() {
		return virtuosoClientFactory;
	}

	public void setVirtuosoClientFactory(final VirtuosoClientFactory virtuosoClientFactory) {
		this.virtuosoClientFactory = virtuosoClientFactory;
	}

	public String getDatasourceInterface() {
		return datasourceInterface;
	}

	public void setDatasourceInterface(final String datasourceInterface) {
		this.datasourceInterface = datasourceInterface;
	}
}
