package eu.dnetlib.msro.workflows.nodes.parthenos.virtuoso;

import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.parthenos.virtuoso.VirtuosoClient;
import eu.dnetlib.parthenos.virtuoso.VirtuosoClientFactory;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.manager.MSROException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StoreVirtuosoJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(StoreVirtuosoJobNode.class);

	private String inputEprParam;
	private String datasourceInterface;

	@Autowired
	private ResultSetClient resultSetClient;

	@Autowired
	private VirtuosoClientFactory virtuosoClientFactory;

	@Override
	protected String execute(final Env env) throws Exception {

		final ResultSet<?> rsIn = env.getAttribute(this.inputEprParam, ResultSet.class);
		if ((rsIn == null)) { throw new MSROException("InputEprParam (" + this.inputEprParam + ") not found in ENV"); }
		VirtuosoClient virtuosoClient = this.virtuosoClientFactory.getVirtuosoClient();
		long nTriples = virtuosoClient.feed(getResultSetClient().iter(rsIn, String.class), getDatasourceInterface());
		log.info("Stored " + nTriples + " triples in Virtuoso server");

		env.setAttribute("triples", nTriples);
		return Arc.DEFAULT_ARC;

	}

	public String getInputEprParam() {
		return this.inputEprParam;
	}

	public void setInputEprParam(final String inputEprParam) {
		this.inputEprParam = inputEprParam;
	}

	public VirtuosoClientFactory getVirtuosoClientFactory() {
		return virtuosoClientFactory;
	}

	public void setVirtuosoClientFactory(final VirtuosoClientFactory virtuosoClientFactory) {
		this.virtuosoClientFactory = virtuosoClientFactory;
	}

	public ResultSetClient getResultSetClient() {
		return resultSetClient;
	}

	public void setResultSetClient(final ResultSetClient resultSetClient) {
		this.resultSetClient = resultSetClient;
	}

	public String getDatasourceInterface() {
		return datasourceInterface;
	}

	public void setDatasourceInterface(final String datasourceInterface) {
		this.datasourceInterface = datasourceInterface;
	}
}
