/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.parthenos.virtuoso;

import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.parthenos.virtuoso.VirtuosoClient;
import eu.dnetlib.parthenos.virtuoso.VirtuosoClientFactory;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.manager.MSROException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StoreVirtuosoJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(StoreVirtuosoJobNode.class);
    private String inputEprParam;
    private String datasourceInterface;
    @Autowired
    private ResultSetClient resultSetClient;
    @Autowired
    private VirtuosoClientFactory virtuosoClientFactory;

    protected String execute(Env env) throws Exception {
        ResultSet rsIn = (ResultSet)env.getAttribute(this.inputEprParam, ResultSet.class);
        if (rsIn == null) {
            throw new MSROException("InputEprParam (" + this.inputEprParam + ") not found in ENV");
        }
        VirtuosoClient virtuosoClient = this.virtuosoClientFactory.getVirtuosoClient();
        long nTriples = virtuosoClient.feed(this.getResultSetClient().iter(rsIn, String.class), this.getDatasourceInterface());
        log.info((Object)("Stored " + nTriples + " triples in Virtuoso server"));
        env.setAttribute("triples", (Object)nTriples);
        return Arc.DEFAULT_ARC;
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public VirtuosoClientFactory getVirtuosoClientFactory() {
        return this.virtuosoClientFactory;
    }

    public void setVirtuosoClientFactory(VirtuosoClientFactory virtuosoClientFactory) {
        this.virtuosoClientFactory = virtuosoClientFactory;
    }

    public ResultSetClient getResultSetClient() {
        return this.resultSetClient;
    }

    public void setResultSetClient(ResultSetClient resultSetClient) {
        this.resultSetClient = resultSetClient;
    }

    public String getDatasourceInterface() {
        return this.datasourceInterface;
    }

    public void setDatasourceInterface(String datasourceInterface) {
        this.datasourceInterface = datasourceInterface;
    }
}

