package eu.dnetlib.parthenos.virtuoso;

import eu.dnetlib.miscutils.functional.xml.SaxonHelper;
import net.sf.saxon.s9api.SaxonApiException;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Created by Alessia Bardi on 12/07/2017.
 *
 * @author Alessia Bardi
 */
public class VirtuosoClientFactory {

	private String connectionString;
	private String username;
	private String password;
	private String defaultBaseURI;

	@Autowired
	private SaxonHelper saxonHelper;

	public VirtuosoClient getVirtuosoClient() throws SaxonApiException {
		return new VirtuosoClient(connectionString, username, password, getSaxonHelper(), defaultBaseURI);
	}

	public String getConnectionString() {
		return connectionString;
	}

	public void setConnectionString(final String connectionString) {
		this.connectionString = connectionString;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(final String username) {
		this.username = username;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(final String password) {
		this.password = password;
	}

	public SaxonHelper getSaxonHelper() {
		return saxonHelper;
	}

	public void setSaxonHelper(final SaxonHelper saxonHelper) {
		this.saxonHelper = saxonHelper;
	}

	public String getDefaultBaseURI() {
		return defaultBaseURI;
	}

	public void setDefaultBaseURI(final String defaultBaseURI) {
		this.defaultBaseURI = defaultBaseURI;
	}
}
