package eu.dnetlib.parthenos.virtuoso;

import eu.dnetlib.parthenos.publisher.ParthenosPublisherException;
import eu.dnetlib.parthenos.publisher.SaxonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * Created by Alessia Bardi on 12/07/2017.
 *
 * @author Alessia Bardi
 */
@Component
public class VirtuosoClientFactory {

	@Value("${virtuoso.connectionstring}")
	private String connectionString;
	@Value("${virtuoso.usr}")
	private String username;
	@Value("${virtuoso.pwd}")
	private String password;
	@Value("${virtuoso.uri.base.default}")
	private String defaultBaseURI;

	@Autowired
	private SaxonHelper saxonHelper;

	public VirtuosoClient getVirtuosoClient() throws ParthenosPublisherException {
		return new VirtuosoClient(connectionString, username, password, getSaxonHelper(), defaultBaseURI);
	}

	public String getConnectionString() {
		return connectionString;
	}

	public void setConnectionString(final String connectionString) {
		this.connectionString = connectionString;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(final String username) {
		this.username = username;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(final String password) {
		this.password = password;
	}

	public SaxonHelper getSaxonHelper() {
		return saxonHelper;
	}

	public void setSaxonHelper(final SaxonHelper saxonHelper) {
		this.saxonHelper = saxonHelper;
	}

	public String getDefaultBaseURI() {
		return defaultBaseURI;
	}

	public void setDefaultBaseURI(final String defaultBaseURI) {
		this.defaultBaseURI = defaultBaseURI;
	}
}
