/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.parthenos.publisher;

import eu.dnetlib.parthenos.publisher.ParthenosPublisherException;
import eu.dnetlib.parthenos.publisher.ParthenosPublisherHelper;
import eu.dnetlib.parthenos.virtuoso.VirtuosoClient;
import eu.dnetlib.parthenos.virtuoso.VirtuosoClientFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParthenosPublisherHelper {
    private static final Log log = LogFactory.getLog(ParthenosPublisherHelper.class);
    @Autowired
    private VirtuosoClientFactory virtuosoClientFactory;

    public void publish(String record, ParthenosTargets target) throws ParthenosPublisherException {
        switch (1.$SwitchMap$eu$dnetlib$parthenos$publisher$ParthenosPublisherHelper$ParthenosTargets[target.ordinal()]) {
            case 1: {
                this.publishVirtuoso(record);
                break;
            }
            case 2: {
                this.publishVirtuoso(record);
                break;
            }
            default: {
                throw new ParthenosPublisherException("Target " + target + " not supported yet");
            }
        }
    }

    public long unpublish(String datasourceInterface, ParthenosTargets target) throws ParthenosPublisherException {
        long res = 0L;
        switch (1.$SwitchMap$eu$dnetlib$parthenos$publisher$ParthenosPublisherHelper$ParthenosTargets[target.ordinal()]) {
            case 1: {
                res = this.unpublishVirtuoso(datasourceInterface);
                break;
            }
            case 2: {
                res = this.unpublishVirtuoso(datasourceInterface);
                break;
            }
            default: {
                throw new ParthenosPublisherException("Target " + target + " not supported yet");
            }
        }
        return res;
    }

    private void publishVirtuoso(String record) throws ParthenosPublisherException {
        log.debug((Object)"Publishing on virtuoso");
        VirtuosoClient virtuosoClient = this.virtuosoClientFactory.getVirtuosoClient();
        virtuosoClient.feed(record);
    }

    private long unpublishVirtuoso(String datasourceInterface) throws ParthenosPublisherException {
        log.debug((Object)("Unublishing from virtuoso " + datasourceInterface));
        VirtuosoClient virtuosoClient = this.virtuosoClientFactory.getVirtuosoClient();
        return virtuosoClient.drop(datasourceInterface);
    }
}

