package eu.dnetlib.parthenos.publisher;

import eu.dnetlib.parthenos.publisher.ParthenosPublisherHelper.ParthenosTargets;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ParthenosPublisherController {

	//TODO: to nicely handle arrors, follow https://docs.spring.io/spring-boot/docs/current/reference/htmlsingle/#boot-features-error-handling

	@Autowired
	private ParthenosPublisherHelper parthenosPublisherHelper;

	@RequestMapping(value = "/publish", method = RequestMethod.POST)
	@Async
	public void publish(@RequestParam final String record, @RequestParam(required = false) String parthenosTarget) throws ParthenosPublisherException {
		this.parthenosPublisherHelper.publish(record, getTarget(parthenosTarget));
	}

	@RequestMapping(value = "/unpublish", method = RequestMethod.GET)
	@Async
	public long unpublish(@RequestParam final String datasourceApi, @RequestParam(required = false) String parthenosTarget) throws ParthenosPublisherException {
		return this.parthenosPublisherHelper.unpublish(datasourceApi, getTarget(parthenosTarget));
	}

	private ParthenosTargets getTarget(String value){
		ParthenosTargets target = ParthenosTargets.ALL;
		if (StringUtils.isNotBlank(value)) {
			target = ParthenosTargets.valueOf(value);
		}
		return target;
	}

}