package eu.dnetlib.parthenos.publisher;

import eu.dnetlib.parthenos.virtuoso.VirtuosoClient;
import eu.dnetlib.parthenos.virtuoso.VirtuosoClientFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Created by Alessia Bardi on 11/08/2017.
 *
 * @author Alessia Bardi
 */
@Component
public class ParthenosPublisherHelper {

	private static final Log log = LogFactory.getLog(ParthenosPublisherHelper.class);

	public enum ParthenosTargets{
		ALL, SOLR, VIRTUOSO, JRR, OAI
	}

	@Autowired
	private VirtuosoClientFactory virtuosoClientFactory;

	public void publish(final String record, final ParthenosTargets target) throws ParthenosPublisherException {
		switch(target){
		case ALL:
			publishVirtuoso(record);
			break;
		case VIRTUOSO:
			publishVirtuoso(record);
			break;
			default: throw new ParthenosPublisherException("Target "+target+" not supported yet");
		}

	}

	public long unpublish(final String datasourceInterface, final ParthenosTargets target) throws ParthenosPublisherException {
		long res = 0;
		switch(target){
		case ALL:
			res = unpublishVirtuoso(datasourceInterface);
			break;
		case VIRTUOSO:
			res = unpublishVirtuoso(datasourceInterface);
			break;
		default: throw new ParthenosPublisherException("Target "+target+" not supported yet");
		}
		return res;
	}

	private void publishVirtuoso(final String record) throws ParthenosPublisherException {
		log.debug("Publishing on virtuoso");
		VirtuosoClient virtuosoClient = this.virtuosoClientFactory.getVirtuosoClient();
		virtuosoClient.feed(record);
	}

	private long unpublishVirtuoso(final String datasourceInterface) throws ParthenosPublisherException {
		log.debug("Unublishing from virtuoso "+datasourceInterface);
		VirtuosoClient virtuosoClient = this.virtuosoClientFactory.getVirtuosoClient();
		return virtuosoClient.drop(datasourceInterface);
	}

//	private void publishSolr(final String record){
//		SolrClient solr = new CloudSolrClient.Builder().withSolrUrl("http://localhost:8983/solr").build();
//
//	}
}
