/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.parthenos.virtuoso;

import eu.dnetlib.parthenos.publisher.ParthenosPublisherException;
import eu.dnetlib.parthenos.publisher.SaxonHelper;
import java.util.HashMap;
import java.util.Map;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathSelector;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.ext.com.google.common.collect.Maps;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import virtuoso.jena.driver.VirtModel;

public class VirtuosoClient {
    private static final Log log = LogFactory.getLog(VirtuosoClient.class);
    private static final String OAI_NAMESPACE_URI = "http://www.openarchives.org/OAI/2.0/";
    private static final String DRI_NAMESPACE_URI = "http://www.driver-repository.eu/namespace/dri";
    private static final String RDF_NAMESPACE_URI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String PROVENANCE_GRAPH = "provenance";
    public static Property IS_API_OF = ResourceFactory.createProperty((String)"dnet", (String)"isApiOf");
    public static Property COLL_FROM = ResourceFactory.createProperty((String)"dnet", (String)"collectedFrom");
    public static Property COLL_IN_DATE = ResourceFactory.createProperty((String)"dnet", (String)"collectedInDate");
    public static Property TRANS_IN_DATE = ResourceFactory.createProperty((String)"dnet", (String)"transformedInDate");
    private SaxonHelper saxonHelper;
    private XPathSelector xpathSelectorObjIdentifier;
    private XPathSelector xpathSelectorCollectionDate;
    private XPathSelector xpathSelectorTransformationDate;
    private XPathSelector xpathSelectorDatasourceName;
    private XPathSelector xpathSelectorDatasourceApi;
    private XPathSelector xpathSelectorRDF;
    private String connectionString;
    private String username;
    private String password;
    private String defaultBaseURI;

    protected VirtuosoClient(String connectionString, String username, String password, SaxonHelper saxonHelper, String defaultBaseURI) throws ParthenosPublisherException {
        this.connectionString = connectionString;
        this.username = username;
        this.password = password;
        this.saxonHelper = saxonHelper;
        this.defaultBaseURI = defaultBaseURI;
        try {
            this.prepareXpathSelectors();
        }
        catch (SaxonApiException e) {
            throw new ParthenosPublisherException((Throwable)e);
        }
    }

    public long feed(String record) throws ParthenosPublisherException {
        try {
            if (StringUtils.isBlank((CharSequence)record)) {
                log.warn((Object)"Got empty record");
                return 0L;
            }
            String objIdentifier = this.extractFromRecord(record, this.xpathSelectorObjIdentifier);
            if (StringUtils.isBlank((CharSequence)objIdentifier)) {
                log.warn((Object)"Got record with no objIdentifier -- skipping");
                return 0L;
            }
            String rdfBlock = this.extractFromRecord(record, this.xpathSelectorRDF);
            if (StringUtils.isBlank((CharSequence)rdfBlock)) {
                log.warn((Object)("Missing rdf:RDF in record with objIdentifier " + objIdentifier + " all triples in that named graph will be deleted"));
            }
            String collectionDate = this.extractFromRecord(record, this.xpathSelectorCollectionDate);
            String transformationDate = this.extractFromRecord(record, this.xpathSelectorTransformationDate);
            String datasource = this.extractFromRecord(record, this.xpathSelectorDatasourceName);
            String dsInterface = this.extractFromRecord(record, this.xpathSelectorDatasourceApi);
            String namedGraph = this.getRecordDefaultURI(objIdentifier, dsInterface);
            log.debug((Object)("Trying to open the database model " + namedGraph + ", connection string " + this.getConnectionString()));
            VirtModel md = VirtModel.openDatabaseModel((String)namedGraph, (String)this.getConnectionString(), (String)this.getUsername(), (String)this.getPassword());
            log.debug((Object)("Opened virtuoso model for graph " + namedGraph));
            md.removeAll();
            log.debug((Object)("Removed all triples from graph " + namedGraph));
            md.read(IOUtils.toInputStream((String)rdfBlock, (String)"UTF-8"), this.getDefaultBaseURI());
            long size = md.size();
            log.info((Object)("Graph " + namedGraph + " now has " + size + " triples"));
            long ntriples = this.feedProvenance(namedGraph, collectionDate, transformationDate, datasource, dsInterface);
            log.debug((Object)("provenance graph for " + namedGraph + " updated with " + ntriples + " triples"));
            return size;
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage());
            throw new ParthenosPublisherException(e);
        }
    }

    long feedProvenance(String namedGraphURI, String collectionDate, String transformationDate, String datasource, String api) {
        VirtModel md = VirtModel.openDatabaseModel((String)PROVENANCE_GRAPH, (String)this.getConnectionString(), (String)this.getUsername(), (String)this.getPassword());
        Resource rApi = ResourceFactory.createResource((String)(this.defaultBaseURI + api));
        Resource r = ResourceFactory.createResource((String)namedGraphURI);
        Statement stmApi = ResourceFactory.createStatement((Resource)rApi, (Property)IS_API_OF, (RDFNode)ResourceFactory.createPlainLiteral((String)datasource));
        Statement stmCollFrom = ResourceFactory.createStatement((Resource)r, (Property)COLL_FROM, (RDFNode)rApi);
        Statement stmCollDate = ResourceFactory.createStatement((Resource)r, (Property)COLL_IN_DATE, (RDFNode)ResourceFactory.createTypedLiteral((String)collectionDate, (RDFDatatype)XSDDatatype.XSDdateTime));
        Statement stmTransDate = ResourceFactory.createStatement((Resource)r, (Property)TRANS_IN_DATE, (RDFNode)ResourceFactory.createTypedLiteral((String)transformationDate, (RDFDatatype)XSDDatatype.XSDdateTime));
        md.removeAll(r, null, null);
        md.add(stmApi).add(stmCollFrom).add(stmCollDate).add(stmTransDate);
        return 3L;
    }

    public long feed(Iterable<String> records) throws ParthenosPublisherException {
        long count = 0L;
        for (String r : records) {
            count += this.feed(r);
        }
        return count;
    }

    public long drop(String api) {
        VirtModel prov = VirtModel.openDatabaseModel((String)PROVENANCE_GRAPH, (String)this.getConnectionString(), (String)this.getUsername(), (String)this.getPassword());
        Resource rApi = ResourceFactory.createResource((String)(this.defaultBaseURI + api));
        long deletedTriples = 0L;
        ResIterator resIterator = prov.listSubjectsWithProperty(COLL_FROM, (RDFNode)rApi);
        while (resIterator.hasNext()) {
            Resource namedGraphURI = resIterator.nextResource();
            deletedTriples += this.dropNamedGraph(namedGraphURI.getURI());
            prov.remove(namedGraphURI, null, null);
        }
        prov.remove(null, null, (RDFNode)rApi);
        prov.remove(rApi, null, null);
        return deletedTriples;
    }

    private long dropNamedGraph(String namedGraphURI) {
        VirtModel namedGraph = VirtModel.openDatabaseModel((String)namedGraphURI, (String)this.getConnectionString(), (String)this.getUsername(), (String)this.getPassword());
        long deletedTriples = namedGraph.size();
        namedGraph.removeAll();
        return deletedTriples;
    }

    private String getRecordDefaultURI(String objIdentifier, String datasourceApi) {
        return this.defaultBaseURI + datasourceApi + "/" + objIdentifier;
    }

    private void prepareXpathSelectors() throws SaxonApiException {
        HashMap namespaces = Maps.newHashMap();
        namespaces.put("oai", OAI_NAMESPACE_URI);
        namespaces.put("dri", DRI_NAMESPACE_URI);
        namespaces.put("rdf", RDF_NAMESPACE_URI);
        this.xpathSelectorObjIdentifier = this.saxonHelper.help().prepareXPathSelector("//oai:header/dri:objIdentifier/text()", (Map)namespaces);
        this.xpathSelectorCollectionDate = this.saxonHelper.help().prepareXPathSelector("//oai:header/dri:dateOfCollection/text()", (Map)namespaces);
        this.xpathSelectorTransformationDate = this.saxonHelper.help().prepareXPathSelector("//oai:header/dri:dateOfTransformation/text()", (Map)namespaces);
        this.xpathSelectorDatasourceName = this.saxonHelper.help().prepareXPathSelector("//oai:header/dri:datasourcename/text()", (Map)namespaces);
        this.xpathSelectorDatasourceApi = this.saxonHelper.help().prepareXPathSelector("//oai:header/dri:datasourceapi/text()", (Map)namespaces);
        this.xpathSelectorRDF = this.saxonHelper.help().prepareXPathSelector("//oai:metadata/rdf:RDF", (Map)namespaces);
    }

    private String extractFromRecord(String record, XPathSelector xPathSelector) {
        try {
            return this.saxonHelper.help().setSerializerProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes").evaluateSingleAsString(record, xPathSelector);
        }
        catch (SaxonApiException e) {
            throw new RuntimeException("Cannot extract content ", e);
        }
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public SaxonHelper getSaxonHelper() {
        return this.saxonHelper;
    }

    public String getDefaultBaseURI() {
        return this.defaultBaseURI;
    }
}

