/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.parthenos.virtuoso;

import eu.dnetlib.parthenos.publisher.ParthenosPublisherException;
import eu.dnetlib.parthenos.publisher.SaxonHelper;
import eu.dnetlib.parthenos.virtuoso.VirtuosoClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class VirtuosoClientFactory {
    private static final Log log = LogFactory.getLog(VirtuosoClientFactory.class);
    @Value(value="${virtuoso.connectionstring}")
    private String connectionString;
    @Value(value="${virtuoso.usr}")
    private String username;
    @Value(value="${virtuoso.pwd}")
    private String password;
    @Value(value="${virtuoso.uri.base.default}")
    private String defaultBaseURI;
    @Autowired
    private SaxonHelper saxonHelper;

    public VirtuosoClient getVirtuosoClient() throws ParthenosPublisherException {
        log.debug((Object)("Creating VirtuosoClient for " + this.connectionString));
        return new VirtuosoClient(this.connectionString, this.username, this.password, this.getSaxonHelper(), this.defaultBaseURI);
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public SaxonHelper getSaxonHelper() {
        return this.saxonHelper;
    }

    public void setSaxonHelper(SaxonHelper saxonHelper) {
        this.saxonHelper = saxonHelper;
    }

    public String getDefaultBaseURI() {
        return this.defaultBaseURI;
    }

    public void setDefaultBaseURI(String defaultBaseURI) {
        this.defaultBaseURI = defaultBaseURI;
    }
}

