/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.parthenos.catalogue;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import eu.dnetlib.parthenos.CRM;
import eu.dnetlib.parthenos.CRMdig;
import eu.dnetlib.parthenos.CRMpe;
import eu.dnetlib.parthenos.catalogue.CatalogueAPIClient;
import eu.dnetlib.parthenos.jrr.ParthenosRegistryResource;
import eu.dnetlib.parthenos.publisher.ParthenosPublisherException;
import eu.dnetlib.parthenos.rdf.ResourceReader;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CatalogueRegistrator {
    private static final Log log = LogFactory.getLog(CatalogueRegistrator.class);
    private final String PARTHENOS_BASE_URL = "http://parthenos.d4science.org";
    private final String CATALOGUE_NAME_REFIX = "parthenos_";
    @Autowired
    private ResourceReader resourceReader;
    @Autowired
    private CatalogueAPIClient catalogueAPIClient;
    private String groupTemplate = "{  \"name\":\"%s\",  \"id\":\"%s\",  \"title\": \"%s\"}";

    public String register(Resource resource, Resource type, String group) throws IOException, ParthenosPublisherException, URISyntaxException, InterruptedException {
        String json;
        String resURI = resource.getURI();
        log.debug((Object)String.format("Catalogue --> Processing resource : %s with type: %s", resURI, type.getLocalName()));
        String resCatName = this.getNameForCatalogue(resURI.substring(resURI.lastIndexOf("handle/") + 7));
        ParthenosRegistryResource prr = this.catalogueAPIClient.getRegistered(resCatName);
        if (prr != null) {
            log.debug((Object)(resCatName + " is already registered"));
            return prr.getUuid();
        }
        String catGroup = this.ensureGroup(group);
        switch (type.getLocalName()) {
            case "PE35_Project": {
                json = this.getJsonForProject(resource, resCatName, catGroup);
                break;
            }
            case "PE1_Service": {
                json = this.getJsonForService(resource, resCatName, catGroup);
                break;
            }
            case "E29_Design_or_Procedure": {
                json = this.getJsonForDesignProcedure(resource, resCatName, catGroup);
                break;
            }
            case "E39_Actor": {
                json = this.getJsonForActor(resource, resCatName, catGroup);
                break;
            }
            case "PE18_Dataset": {
                json = this.getJsonForDataset(resource, resCatName, catGroup);
                break;
            }
            case "D14_Software": {
                json = this.getJsonForSoftware(resource, resCatName, catGroup);
                break;
            }
            case "E78_Collection": {
                json = this.getJsonForCollection(resource, resCatName, catGroup);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Type " + type.getLocalName() + " not supported", new Object[0]));
            }
        }
        String uuid = this.catalogueAPIClient.doRegister(json, resCatName);
        if (StringUtils.isBlank((CharSequence)uuid)) {
            log.warn((Object)String.format("%s could not be registered, sleeping 1sec and then try again", resURI));
            Thread.sleep(1000L);
            uuid = this.catalogueAPIClient.doRegister(json, resCatName);
            if (StringUtils.isBlank((CharSequence)uuid)) {
                log.warn((Object)String.format("%s could not be registered even the second time, giving up", resURI));
                return null;
            }
        }
        log.debug((Object)String.format("%s registered on the catalogue with uuid: %s", resURI, uuid));
        return uuid;
    }

    protected boolean purge(String resCatName) throws URISyntaxException, IOException {
        return this.catalogueAPIClient.purgeItem(resCatName);
    }

    protected String getNameForCatalogue(String name) throws UnsupportedEncodingException {
        String n = URLDecoder.decode(URLDecoder.decode(name, "UTF-8").replaceAll("/", "_").toLowerCase().replaceAll(" ", "_"), "UTF-8");
        if (n.length() > 100) {
            log.warn((Object)("Catalog name > 100: " + name));
            n = n.substring(0, 99);
        }
        if (n.length() < 2) {
            n = "parthenos_" + n;
        }
        return n;
    }

    protected String ensureGroup(String group) throws ParthenosPublisherException, IOException, URISyntaxException {
        log.debug((Object)("Ensuring group exist: " + group));
        if (StringUtils.isNotBlank((CharSequence)group)) {
            String groupName = this.getNameForCatalogue(group);
            if (!this.catalogueAPIClient.groupExist(groupName)) {
                String groupJson = String.format(this.groupTemplate, groupName, groupName, group);
                this.catalogueAPIClient.registerGroup(groupJson, groupName);
                log.info((Object)("NEW GROUP REGISTERED: " + groupName));
            }
            return groupName;
        }
        return null;
    }

    protected String getJsonForProject(Resource res, String resNameForCatalogue, String catGroup) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(out);
        JsonGenerator jg = jsonFactory.createGenerator((OutputStream)bos, JsonEncoding.UTF8);
        jg.writeStartObject();
        this.writeCommonFields(jg, res, resNameForCatalogue, catGroup);
        jg.writeStringField("maintainer", Joiner.on((String)", ").join(this.resourceReader.getMaintainersForManagementSection(res)));
        jg.writeArrayFieldStart("extras");
        this.addExtra(jg, "system:type", CRMpe.PE35_Project.getLocalName());
        this.addExtra(jg, "instance of", this.resourceReader.findSpecificType(res, CRM.E7_Activity).getLocalName());
        if (res.getURI().startsWith("http://parthenos.d4science.org")) {
            this.addExtra(jg, "Parthenos URL", res.getURI());
        } else {
            this.addExtra(jg, "URL", res.getURI());
        }
        this.addIdentifiers(res, jg);
        this.addExtra(jg, "started on", this.resourceReader.getStartTime(res));
        this.addExtra(jg, "maintaining team", Joiner.on((String)", ").join(this.resourceReader.getMaintainerUrls(res)));
        this.addExtra(jg, "offers", Joiner.on((String)", ").join(this.resourceReader.getOfferedServiceUrls(res)));
        jg.writeEndArray();
        jg.writeEndObject();
        jg.close();
        return out.toString("UTF-8");
    }

    protected String getJsonForService(Resource res, String resNameForCatalogue, String catGroup) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(out);
        JsonGenerator jg = jsonFactory.createGenerator((OutputStream)bos, JsonEncoding.UTF8);
        jg.writeStartObject();
        this.writeCommonFields(jg, res, resNameForCatalogue, catGroup);
        jg.writeStringField("maintainer", Joiner.on((String)", ").join(this.resourceReader.getMaintainersForManagementSection(res)));
        jg.writeArrayFieldStart("extras");
        this.addExtra(jg, "system:type", CRMpe.PE1_Service.getLocalName());
        this.addExtra(jg, "instance of", this.resourceReader.findSpecificType(res, CRM.E7_Activity).getLocalName());
        if (res.getURI().startsWith("http://parthenos.d4science.org")) {
            this.addExtra(jg, "Parthenos URL", res.getURI());
        } else {
            this.addExtra(jg, "URL", res.getURI());
        }
        this.addIdentifiers(res, jg);
        this.addExtra(jg, "competence", Joiner.on((String)", ").join(this.resourceReader.getCompetences(res)));
        this.addExtra(jg, "activity type", Joiner.on((String)", ").join(this.resourceReader.getActivityTypes(res)));
        this.addExtra(jg, "condition of use", this.resourceReader.getConditionOfUse(res));
        this.addExtra(jg, "contact points", Joiner.on((String)", ").join(Iterators.concat((Iterator)this.resourceReader.getResourceDirectContactPointsURI(res), (Iterator)this.resourceReader.getProviderContactPoints(res))));
        this.addExtra(jg, "provided by", Joiner.on((String)", ").join(this.resourceReader.getProviderUris(res)));
        this.addExtra(jg, "online access point", Joiner.on((String)", ").join(this.resourceReader.getAccessPoints(res)));
        this.addExtra(jg, "protocol", Joiner.on((String)", ").join(this.resourceReader.getProtocols(res)));
        this.addExtra(jg, "delivers on request", Joiner.on((String)", ").join(this.resourceReader.getDeliversOnRequest(res)));
        this.addExtra(jg, "runs on request", Joiner.on((String)", ").join(this.resourceReader.getRunsOnRequest(res)));
        this.addExtra(jg, "hosts", Joiner.on((String)", ").join(this.resourceReader.getHostedStuff(res)));
        this.addExtra(jg, "curates", Joiner.on((String)", ").join(this.resourceReader.getCuratedObjects(res)));
        this.addExtra(jg, "declared begin/end of operation", Joiner.on((String)", ").join(this.resourceReader.getDeclarativeTimes(res)));
        this.addExtra(jg, "availability", this.resourceReader.getAvailability(res));
        this.addExtra(jg, "uses curation plan", Joiner.on((String)", ").join(this.resourceReader.getCurationPlans(res)));
        this.addExtra(jg, "time of service", Joiner.on((String)", ").join(this.resourceReader.getDeclarativeTimes(res)));
        jg.writeEndArray();
        jg.writeEndObject();
        jg.close();
        return out.toString("UTF-8");
    }

    protected String getJsonForActor(Resource res, String resNameForCatalogue, String catGroup) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(out);
        JsonGenerator jg = jsonFactory.createGenerator((OutputStream)bos, JsonEncoding.UTF8);
        jg.writeStartObject();
        this.writeCommonFields(jg, res, resNameForCatalogue, catGroup);
        jg.writeArrayFieldStart("extras");
        this.addExtra(jg, "system:type", CRM.E39_Actor.getLocalName());
        this.addExtra(jg, "instance of", this.resourceReader.findSpecificType(res, CRM.E39_Actor).getLocalName());
        if (res.getURI().startsWith("http://parthenos.d4science.org")) {
            this.addExtra(jg, "Parthenos URL", res.getURI());
        } else {
            this.addExtra(jg, "URL", res.getURI());
        }
        this.addIdentifiers(res, jg);
        this.addExtra(jg, "has member", Joiner.on((String)", ").join(this.resourceReader.getMemberUrls(res)));
        this.addExtra(jg, "is member of", Joiner.on((String)", ").join(this.resourceReader.isMemberOf(res)));
        this.addExtra(jg, "provides", Joiner.on((String)", ").join(this.resourceReader.getProvidedServiceUrls(res)));
        String contactPoints = "";
        StmtIterator it = res.listProperties(CRM.P76_has_contact_point);
        while (it.hasNext()) {
            Resource cp = ((Statement)it.next()).getResource();
            Resource cpType = cp.getPropertyResourceValue(CRM.P2_has_type);
            String cpTypeLabel = this.resourceReader.getLabel(cpType);
            String cpLabel = this.resourceReader.getLabel(cp);
            if (!StringUtils.isNotBlank((CharSequence)cpLabel)) continue;
            if (StringUtils.isNotBlank((CharSequence)cpTypeLabel)) {
                contactPoints = contactPoints + cpTypeLabel + ": ";
            }
            contactPoints = contactPoints + cpLabel + "; ";
        }
        this.addExtra(jg, "contact points", contactPoints);
        this.addExtra(jg, "maintains", Joiner.on((String)", ").join(this.resourceReader.getMaintainedUrls(res)));
        jg.writeEndArray();
        jg.writeEndObject();
        jg.close();
        return out.toString("UTF-8");
    }

    protected String getJsonForDataset(Resource res, String resNameForCatalogue, String catGroup) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(out);
        JsonGenerator jg = jsonFactory.createGenerator((OutputStream)bos, JsonEncoding.UTF8);
        jg.writeStartObject();
        this.writeCommonFields(jg, res, resNameForCatalogue, catGroup);
        jg.writeArrayFieldStart("extras");
        this.addExtra(jg, "system:type", CRMpe.PE18_Dataset.getLocalName());
        this.addExtra(jg, "instance of", this.resourceReader.findSpecificType(res, CRM.E70_Thing).getLocalName());
        if (res.getURI().startsWith("http://parthenos.d4science.org")) {
            this.addExtra(jg, "Parthenos URL", res.getURI());
        } else {
            this.addExtra(jg, "URL", res.getURI());
        }
        this.addIdentifiers(res, jg);
        this.addExtra(jg, "has type", Joiner.on((String)", ").join(this.resourceReader.getHasTypeLabels(res)));
        this.addExtra(jg, "is part of", Joiner.on((String)", ").join(this.resourceReader.getIsPartOfUrls(res)));
        this.addExtra(jg, "has part", Joiner.on((String)", ").join(this.resourceReader.getHasPartUrls(res)));
        this.addExtra(jg, "curated by", Joiner.on((String)", ").join(this.resourceReader.getCuratorUrls(res)));
        this.addExtra(jg, "curation plan", Joiner.on((String)", ").join(this.resourceReader.getResourceCuratorCurationPlans(res)));
        this.addExtra(jg, "hosted by", Joiner.on((String)", ").join(this.resourceReader.getHostedBys(res)));
        this.addExtra(jg, "encoding type", Joiner.on((String)", ").join(this.resourceReader.getEncodings(res)));
        this.addExtra(jg, "creator", Joiner.on((String)", ").join(this.resourceReader.getCreatorsURIs(res)));
        this.addExtra(jg, "created with software", Joiner.on((String)", ").join(this.resourceReader.getUsedSoftware(res)));
        this.addExtra(jg, "subject", Joiner.on((String)", ").join(this.resourceReader.getSubjects(res)));
        this.addExtra(jg, "temporal coverage", Joiner.on((String)", ").join((Iterable)this.resourceReader.getTemporalCoverages(res)));
        this.addExtra(jg, "spatial coverage", Joiner.on((String)", ").join((Iterable)this.resourceReader.getSpatialCoverages(res)));
        this.addExtra(jg, "uses", Joiner.on((String)", ").join(this.resourceReader.getUsedSoftware(res)));
        this.addExtra(jg, "used by", Joiner.on((String)", ").join(this.resourceReader.getUsedBy(res)));
        this.addExtra(jg, "languages", Joiner.on((String)", ").join(this.resourceReader.getLanguages(res)));
        this.addExtra(jg, "has metadata", Joiner.on((String)", ").join(this.resourceReader.getMetadata(res)));
        this.addExtra(jg, "is metadata for", Joiner.on((String)", ").join(this.resourceReader.getDescribedDataset(res)));
        this.addExtra(jg, "has snapshot", Joiner.on((String)", ").join(this.resourceReader.getSnapshots(res)));
        this.addExtra(jg, "is snapshot of", Joiner.on((String)", ").join(this.resourceReader.getIsSnapshotOfs(res)));
        jg.writeEndArray();
        jg.writeEndObject();
        jg.close();
        return out.toString("UTF-8");
    }

    protected String getJsonForSoftware(Resource res, String resNameForCatalogue, String catGroup) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(out);
        JsonGenerator jg = jsonFactory.createGenerator((OutputStream)bos, JsonEncoding.UTF8);
        jg.writeStartObject();
        this.writeCommonFields(jg, res, resNameForCatalogue, catGroup);
        jg.writeArrayFieldStart("extras");
        this.addExtra(jg, "system:type", CRMdig.D14_Software.getLocalName());
        this.addExtra(jg, "instance of", this.resourceReader.findSpecificType(res, CRM.E70_Thing).getLocalName());
        if (res.getURI().startsWith("http://parthenos.d4science.org")) {
            this.addExtra(jg, "Parthenos URL", res.getURI());
        } else {
            this.addExtra(jg, "URL", res.getURI());
        }
        this.addIdentifiers(res, jg);
        this.addExtra(jg, "subject", Joiner.on((String)", ").join(this.resourceReader.getSubjects(res)));
        this.addExtra(jg, "has type", Joiner.on((String)", ").join(this.resourceReader.getHasTypeLabels(res)));
        this.addExtra(jg, "hosted by", Joiner.on((String)", ").join(this.resourceReader.getHostedBys(res)));
        this.addExtra(jg, "curated by", Joiner.on((String)", ").join(this.resourceReader.getCuratorUrls(res)));
        this.addExtra(jg, "has snapshot", Joiner.on((String)", ").join(this.resourceReader.getSnapshots(res)));
        this.addExtra(jg, "is snapshot of", Joiner.on((String)", ").join(this.resourceReader.getIsSnapshotOfs(res)));
        this.addExtra(jg, "is part of", Joiner.on((String)", ").join(this.resourceReader.getIsPartOfUrls(res)));
        this.addExtra(jg, "has part", Joiner.on((String)", ").join(this.resourceReader.getHasPartUrls(res)));
        this.addExtra(jg, "has release", Joiner.on((String)", ").join(this.resourceReader.getHasReleases(res)));
        this.addExtra(jg, "is release of", Joiner.on((String)", ").join(this.resourceReader.getIsReleaseOfs(res)));
        this.addExtra(jg, "used by", Joiner.on((String)", ").join(this.resourceReader.getUsedBy(res)));
        this.addExtra(jg, "creation time", this.resourceReader.getFirstCreationTime(res));
        jg.writeEndArray();
        jg.writeEndObject();
        jg.close();
        return out.toString("UTF-8");
    }

    protected String getJsonForCollection(Resource res, String resNameForCatalogue, String catGroup) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(out);
        JsonGenerator jg = jsonFactory.createGenerator((OutputStream)bos, JsonEncoding.UTF8);
        jg.writeStartObject();
        this.writeCommonFields(jg, res, resNameForCatalogue, catGroup);
        jg.writeArrayFieldStart("extras");
        this.addExtra(jg, "system:type", CRM.E78_Collection.getLocalName());
        this.addExtra(jg, "instance of", this.resourceReader.findSpecificType(res, CRM.E70_Thing).getLocalName());
        if (res.getURI().startsWith("http://parthenos.d4science.org")) {
            this.addExtra(jg, "Parthenos URL", res.getURI());
        } else {
            this.addExtra(jg, "URL", res.getURI());
        }
        this.addIdentifiers(res, jg);
        this.addExtra(jg, "has type", Joiner.on((String)", ").join(this.resourceReader.getHasTypeLabels(res)));
        this.addExtra(jg, "subject", Joiner.on((String)", ").join(this.resourceReader.getSubjects(res)));
        this.addExtra(jg, "temporal coverage", Joiner.on((String)", ").join((Iterable)this.resourceReader.getTemporalCoverages(res)));
        this.addExtra(jg, "spatial coverage", Joiner.on((String)", ").join((Iterable)this.resourceReader.getSpatialCoverages(res)));
        this.addExtra(jg, "has part", Joiner.on((String)", ").join(this.resourceReader.getHasPartUrls(res)));
        this.addExtra(jg, "hosted by", Joiner.on((String)", ").join(this.resourceReader.getHostedBys(res)));
        this.addExtra(jg, "curated by", Joiner.on((String)", ").join(this.resourceReader.getCuratorUrls(res)));
        this.addExtra(jg, "creator", Joiner.on((String)", ").join(this.resourceReader.getCreatorsURIs(res)));
        this.addExtra(jg, "languages", Joiner.on((String)", ").join(this.resourceReader.getLanguages(res)));
        jg.writeEndArray();
        jg.writeEndObject();
        jg.close();
        return out.toString("UTF-8");
    }

    protected String getJsonForDesignProcedure(Resource res, String resNameForCatalogue, String catGroup) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(out);
        JsonGenerator jg = jsonFactory.createGenerator((OutputStream)bos, JsonEncoding.UTF8);
        jg.writeStartObject();
        this.writeCommonFields(jg, res, resNameForCatalogue, catGroup);
        jg.writeArrayFieldStart("extras");
        this.addExtra(jg, "system:type", CRM.E29_Design_or_Procedure.getLocalName());
        this.addExtra(jg, "instance of", this.resourceReader.findSpecificType(res, CRM.E29_Design_or_Procedure).getLocalName());
        if (res.getURI().startsWith("http://parthenos.d4science.org")) {
            this.addExtra(jg, "Parthenos URL", res.getURI());
        } else {
            this.addExtra(jg, "URL", res.getURI());
        }
        this.addIdentifiers(res, jg);
        this.addExtra(jg, "used by", Joiner.on((String)", ").join(this.resourceReader.getUsedBy(res)));
        jg.writeEndArray();
        jg.writeEndObject();
        jg.close();
        return out.toString("UTF-8");
    }

    protected void addIdentifiers(Resource res, JsonGenerator jg) throws IOException {
        StmtIterator it = res.listProperties(CRM.P1_is_identified_by);
        HashSet ids = Sets.newHashSet();
        while (it.hasNext()) {
            RDFNode obj = ((Statement)it.next()).getObject();
            if (obj.isLiteral()) {
                ids.add(obj.asLiteral().getLexicalForm());
                continue;
            }
            Resource id = (Resource)obj;
            if (!id.hasProperty(RDF.type, (RDFNode)CRM.E42_Identifier)) continue;
            ids.add(this.resourceReader.getLabel(id));
        }
        this.addExtra(jg, "ID", String.join((CharSequence)",", ids));
    }

    protected void addExtra(JsonGenerator jg, String key, String value) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            jg.writeStartObject();
            jg.writeStringField("key", key);
            jg.writeStringField("value", value);
            jg.writeEndObject();
        }
    }

    protected void writeCommonFields(JsonGenerator jg, Resource res, String resNameForCatalogue, String catGroup) throws IOException {
        jg.writeStringField("name", resNameForCatalogue);
        jg.writeStringField("license_id", this.resourceReader.getCatalogueLicense(res).getId());
        String title = this.resourceReader.getTitle(res);
        if (StringUtils.isBlank((CharSequence)title)) {
            title = resNameForCatalogue;
        }
        jg.writeStringField("title", title);
        jg.writeStringField("notes", Joiner.on((char)';').join(this.resourceReader.getDescriptions(res)));
        jg.writeArrayFieldStart("tags");
        Iterator classNames = this.resourceReader.getRDFClassNames(res);
        while (classNames.hasNext()) {
            jg.writeStartObject();
            jg.writeStringField("name", (String)classNames.next());
            jg.writeEndObject();
        }
        jg.writeEndArray();
        jg.writeArrayFieldStart("groups");
        jg.writeStartObject();
        jg.writeStringField("name", catGroup);
        jg.writeEndObject();
        jg.writeEndArray();
    }

    public ResourceReader getResourceReader() {
        return this.resourceReader;
    }

    public void setResourceReader(ResourceReader resourceReader) {
        this.resourceReader = resourceReader;
    }

    public CatalogueAPIClient getCatalogueAPIClient() {
        return this.catalogueAPIClient;
    }

    public void setCatalogueAPIClient(CatalogueAPIClient catalogueAPIClient) {
        this.catalogueAPIClient = catalogueAPIClient;
    }
}

