/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.parthenos.catalogue;

import org.apache.commons.lang3.StringUtils;

public enum CatalogueLicense {
    NotSpecified("notspecified"),
    OtherOpen("other-open"),
    OtherPublicDomain("other-pd"),
    OtherAttribution("other-at"),
    OtherNonCommercial("other-nc"),
    CC0("CC0-1.0"),
    CCBY("CC-BY-4.0"),
    CCBYSA("CC-BY-SA-4.0"),
    CCBYNC("CC-BY-NC-4.0"),
    CCBYND("CC-BY-ND-4.0"),
    CCBYNCSA("CC-BY-NC-SA-4.0"),
    CCBYNCND("CC-BY-NC-ND-4.0"),
    AFL("AFL-3.0"),
    APL("APL-1.0"),
    AGPL("AGPL-3.0"),
    Apache1_1("Apache-1.1"),
    Apache2("Apache-2.0"),
    APSL2("APSL-2.0"),
    GPL2("GPL-2.0"),
    GPL3("GPL-3.0"),
    LGPL2_1("LGPL-2.1"),
    LGPL3("LGPL-3.0"),
    EUDataGrid("EUDatagrid"),
    EUPL1_1("EUPL-1.1"),
    Fair("Fair"),
    MIT("MIT"),
    MozillaPublic("MPL-1.1");

    private String id;

    public String getId() {
        return this.id;
    }

    private CatalogueLicense(String id) {
        this.id = id;
    }

    public static CatalogueLicense getCatalogueLicenseFor(String license) {
        if (StringUtils.isBlank((CharSequence)license)) {
            return NotSpecified;
        }
        if (license.equalsIgnoreCase("CC") || license.equalsIgnoreCase("Free/ CC")) {
            return CC0;
        }
        if (license.equalsIgnoreCase("CC-BY") || license.equalsIgnoreCase("CC BY")) {
            return CCBY;
        }
        if (license.equalsIgnoreCase("CC-BY-SA") || license.equalsIgnoreCase("Attribute-share-alike (CC-BY-SA) license") || license.equalsIgnoreCase("CC BY-SA")) {
            return CCBYSA;
        }
        if (license.equalsIgnoreCase("CC-BY-SA-NC") || license.equalsIgnoreCase("Creative Commons BY-NC-SA")) {
            return CCBYNCSA;
        }
        if (license.equalsIgnoreCase("Open Access") || license.equalsIgnoreCase("OpenSource")) {
            return OtherOpen;
        }
        if (license.equalsIgnoreCase("MIT") || license.equalsIgnoreCase("MIT LICENSE")) {
            return MIT;
        }
        if (license.equalsIgnoreCase("APACHE 2.0") || license.equalsIgnoreCase("Apache License 2.0") || license.equalsIgnoreCase("Apache License, Version 2.0")) {
            return Apache2;
        }
        if (license.equalsIgnoreCase("GNU GPL v2")) {
            return GPL2;
        }
        if (license.equalsIgnoreCase("GPLv3") || license.equalsIgnoreCase("GPL v3")) {
            return GPL3;
        }
        if (license.equalsIgnoreCase("LGPL V3") || license.equalsIgnoreCase("LGPL V3.0")) {
            return LGPL3;
        }
        return NotSpecified;
    }
}

