package eu.dnetlib.parthenos.catalogue;

import java.io.IOException;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.parthenos.jrr.ParthenosRegistryResource;

/**
 * Created by Alessia Bardi on 08/03/2018.
 *
 * @author Alessia Bardi
 */
public class CatalogueAPIResponse {

	private JsonNode response;

	public void setResponseBody(final String responseBody) throws IOException {
		ObjectMapper mapper = new ObjectMapper();
		response = mapper.readTree(responseBody);
	}

	public boolean isSuccess(){
		return response.get("success").asBoolean();
	}

	public ParthenosRegistryResource getParthenosRegistryResource() throws IOException {
		if(!hasParthenosRegistryResource()) return null;
		else{
			JsonNode result = response.get("result");
			return parseResult(result);
		}
	}

	public boolean hasParthenosRegistryResource(){
		JsonNode result = response.path("result");
		return !result.isMissingNode();
	}

	public String getErrorMessage(){
		if(isSuccess()) return "";
		//TODO: tell d4science guys that error messages sometimes are in error.name, sometimes in message
		JsonNode message = response.path("message");
		if(!message.isMissingNode()) return message.toString();
		else{
			JsonNode error = response.get("error");
			if(!error.isMissingNode()){
				return error.toString();
			}
		}
		return "Error message not available in error or message fields";
	}

	protected ParthenosRegistryResource parseResult(JsonNode result) throws IOException {
		String uuid = result.get("id").asText();
		String type = null;
		JsonNode extras = result.get("extras");
		for(JsonNode jn : extras){
			String key = jn.get("key").asText();
			if(key.equals("system:type")){
				type = jn.get("value").asText();
			}
		}
		return new ParthenosRegistryResource().setJson(result.asText()).setType(type).setUuid(uuid);
	}

}
