/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.parthenos.registry;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.collect.Lists;
import eu.dnetlib.parthenos.CRM;
import eu.dnetlib.parthenos.CRMdig;
import eu.dnetlib.parthenos.CRMpe;
import eu.dnetlib.parthenos.jrr.ParthenosRegistryRel;
import eu.dnetlib.parthenos.jrr.ParthenosRegistryResource;
import eu.dnetlib.parthenos.publisher.ParthenosPublisherException;
import eu.dnetlib.parthenos.rdf.ResourceReader;
import eu.dnetlib.parthenos.registry.FacetWriter;
import eu.dnetlib.parthenos.registry.RelWriter;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ext.com.google.common.collect.Maps;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.model.entity.facet.IdentifierFacet;
import org.gcube.informationsystem.model.relation.IsIdentifiedBy;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.query.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.client.ParthenosRegistryClientSetter;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClient;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClientFactory;
import org.gcube.informationsystem.resourceregistry.publisher.ParthenosRegistryPublisherSetter;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisher;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisherFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class GCubeResourceRegistrator {
    private static final Log log = LogFactory.getLog(GCubeResourceRegistrator.class);
    @Value(value="${gcube.registry.baseurl}")
    private String registryBaseURL;
    @Value(value="${gcube.registry.application.token}")
    private String applicationToken;
    @Autowired
    private FacetWriter facetWriter;
    @Autowired
    private RelWriter relWriter;
    @Autowired
    private ResourceReader resourceReader;
    private ResourceRegistryPublisher resourceRegistryPublisher;
    private ResourceRegistryClient resourceRegistryClient;

    @PostConstruct
    public void init() throws Exception {
        ParthenosRegistryClientSetter.forceToURL((String)this.getRegistryBaseURL());
        ParthenosRegistryPublisherSetter.forceToURL((String)this.getRegistryBaseURL());
        log.info((Object)("Registry URL forced to " + this.getRegistryBaseURL()));
        if (StringUtils.isNotBlank((CharSequence)this.getApplicationToken())) {
            GCubeResourceRegistrator.setContext((String)this.getApplicationToken());
            log.info((Object)"GCube Context set");
        } else {
            log.fatal((Object)"GCube context cannot be configured without a value in gcube.registry.application.token");
        }
        this.resourceRegistryPublisher = ResourceRegistryPublisherFactory.create();
        this.resourceRegistryClient = ResourceRegistryClientFactory.create();
    }

    protected static String getCurrentScope(String token) throws Exception {
        AuthorizationEntry authorizationEntry = Constants.authorizationService().get(token);
        String context = authorizationEntry.getContext();
        log.info((Object)("Context of token " + token + " is: " + context));
        return context;
    }

    protected static void setContext(String token) throws Exception {
        SecurityTokenProvider.instance.set(token);
        ScopeProvider.instance.set(GCubeResourceRegistrator.getCurrentScope((String)token));
    }

    public int unregister(String datasourceApi) {
        return -1;
    }

    protected boolean deleteResourcebyUUID(Resource resourceType, UUID uuid) throws ResourceRegistryException {
        return this.resourceRegistryPublisher.deleteResource(uuid);
    }

    public void register(Resource rdfResource, String uuid, Resource type) throws IOException, ResourceRegistryException, ParthenosPublisherException {
        String resURI = rdfResource.getURI();
        log.debug((Object)("Processing resource " + resURI + " for registration on JRR"));
        JsonFactory jsonFactory = new JsonFactory();
        ParthenosRegistryResource prr = null;
        switch (type.getLocalName()) {
            case "E7_Activity": {
                if (rdfResource.hasProperty(RDF.type, (RDFNode)CRMpe.PE1_Service)) {
                    prr = this.processService(rdfResource, jsonFactory, uuid);
                    break;
                }
                if (!rdfResource.hasProperty(RDF.type, (RDFNode)CRMpe.PE35_Project)) break;
                prr = this.processProject(rdfResource, jsonFactory, uuid);
                break;
            }
            case "E55_Type": {
                if (rdfResource.hasProperty(RDF.type, (RDFNode)CRMpe.PE36_Competency_Type)) {
                    prr = this.processBasicResource(rdfResource, CRMpe.PE36_Competency_Type, jsonFactory, uuid);
                    break;
                }
                if (!rdfResource.hasProperty(RDF.type, (RDFNode)CRMpe.PE37_Protocol_Type)) break;
                prr = this.processBasicResource(rdfResource, CRMpe.PE37_Protocol_Type, jsonFactory, uuid);
                break;
            }
            case "E70_Thing": {
                if (!rdfResource.hasProperty(RDF.type, (RDFNode)CRMdig.D1_Digital_Object)) break;
                prr = this.processDigitalObject(rdfResource, jsonFactory, uuid);
                break;
            }
            case "E39_Actor": {
                prr = this.processActor(rdfResource, jsonFactory, uuid);
                break;
            }
            case "E29_Design_or_Procedure": {
                prr = this.processBasicResource(rdfResource, CRM.E29_Design_or_Procedure, jsonFactory, uuid);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Type " + type.getLocalName() + " not supported", new Object[0]));
            }
        }
        if (prr != null) {
            this.resourceRegistryPublisher.createResource(prr.getRegistryType(), prr.getJson());
            List rels = this.getResourceRels(rdfResource, prr);
            int registeredRels = 0;
            for (ParthenosRegistryRel r : rels) {
                String res = this.resourceRegistryPublisher.createIsRelatedTo(r.getRelName(), r.getJson());
                if (!StringUtils.isNotBlank((CharSequence)res)) continue;
                ++registeredRels;
            }
            log.debug((Object)String.format("Registered %d/%d relationships for uri %s, uuid %s", registeredRels, rels.size(), resURI, uuid));
        } else {
            log.warn((Object)("Could not register on registry: " + resURI));
        }
    }

    protected ParthenosRegistryResource processService(Resource res, JsonFactory jsonFactory, String uuid) throws IOException {
        if (res.hasProperty(RDF.type, (RDFNode)CRMpe.PE8_E_Service) || res.hasProperty(RDF.type, (RDFNode)CRMpe.PE2_Hosting_Service) || res.hasProperty(RDF.type, (RDFNode)CRMpe.PE3_Curating_Service)) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(out);
            JsonGenerator jg = jsonFactory.createGenerator((OutputStream)bos, JsonEncoding.UTF8);
            jg.writeStartObject();
            String specificType = this.resourceReader.findSpecificType(res, CRMpe.PE1_Service).getLocalName();
            this.writeCommon(res, specificType, jg, uuid);
            jg.writeArrayFieldStart("consistsOf");
            this.writeCommonFacets(res, jg);
            this.facetWriter.writeEventFacet(jg);
            this.facetWriter.writeRightsFacet(jg, res);
            if (res.hasProperty(CRMpe.PP2_provided_by)) {
                Resource provider = res.getPropertyResourceValue(CRMpe.PP2_provided_by);
                this.facetWriter.writeContactReferenceFacet(jg, provider);
            }
            this.facetWriter.writeDesignatedAccessPointFacet(jg, res);
            jg.writeEndArray();
            jg.writeEndObject();
            jg.close();
            String json = out.toString("UTF-8");
            log.debug((Object)json);
            return new ParthenosRegistryResource().setJson(json).setType(specificType).setUuid(uuid);
        }
        log.warn((Object)String.format("Skipping resource: %s It is not an instance of a specific service", new Object[0]));
        return null;
    }

    protected ParthenosRegistryResource processProject(Resource res, JsonFactory jsonFactory, String uuid) throws IOException {
        String specificType = this.resourceReader.findSpecificType(res, CRMpe.PE35_Project).getLocalName();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(out);
        JsonGenerator jg = jsonFactory.createGenerator((OutputStream)bos, JsonEncoding.UTF8);
        jg.writeStartObject();
        this.writeCommon(res, specificType, jg, uuid);
        jg.writeArrayFieldStart("consistsOf");
        this.writeCommonFacets(res, jg);
        jg.writeEndArray();
        jg.writeEndObject();
        jg.close();
        String json = out.toString("UTF-8");
        log.debug((Object)json);
        return new ParthenosRegistryResource().setJson(json).setType(specificType).setUuid(uuid);
    }

    protected ParthenosRegistryResource processActor(Resource res, JsonFactory jsonFactory, String uuid) throws IOException {
        String specificType = this.resourceReader.findSpecificType(res, CRM.E39_Actor).getLocalName();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(out);
        JsonGenerator jg = jsonFactory.createGenerator((OutputStream)bos, JsonEncoding.UTF8);
        jg.writeStartObject();
        this.writeCommon(res, specificType, jg, uuid);
        jg.writeArrayFieldStart("consistsOf");
        this.writeCommonFacets(res, jg);
        this.facetWriter.writeContactReferenceFacet(jg, res);
        jg.writeEndArray();
        jg.writeEndObject();
        jg.close();
        String json = out.toString("UTF-8");
        log.debug((Object)json);
        return new ParthenosRegistryResource().setJson(json).setType(specificType).setUuid(uuid);
    }

    protected ParthenosRegistryResource processDigitalObject(Resource res, JsonFactory jsonFactory, String uuid) throws IOException {
        String specificType = this.resourceReader.findSpecificType(res, CRMdig.D1_Digital_Object).getLocalName();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(out);
        JsonGenerator jg = jsonFactory.createGenerator((OutputStream)bos, JsonEncoding.UTF8);
        jg.writeStartObject();
        this.writeCommon(res, specificType, jg, uuid);
        jg.writeArrayFieldStart("consistsOf");
        this.writeCommonFacets(res, jg);
        this.facetWriter.writeTemporalCoverageFacet(jg, res);
        this.facetWriter.writeRightsFacet(jg, res);
        jg.writeEndArray();
        jg.writeEndObject();
        jg.close();
        String json = out.toString("UTF-8");
        log.debug((Object)json);
        return new ParthenosRegistryResource().setUuid(uuid).setType(specificType).setJson(json);
    }

    protected ParthenosRegistryResource processBasicResource(Resource res, Resource basicType, JsonFactory jsonFactory, String uuid) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(out);
        JsonGenerator jg = jsonFactory.createGenerator((OutputStream)bos, JsonEncoding.UTF8);
        jg.writeStartObject();
        String specificType = this.resourceReader.findSpecificType(res, basicType).getLocalName();
        this.writeCommon(res, specificType, jg, uuid);
        jg.writeArrayFieldStart("consistsOf");
        this.writeCommonFacets(res, jg);
        jg.writeEndArray();
        jg.writeEndObject();
        jg.close();
        String json = out.toString("UTF-8");
        log.debug((Object)json);
        return new ParthenosRegistryResource().setJson(json).setType(specificType).setUuid(uuid);
    }

    protected List<ParthenosRegistryRel> getResourceRels(Resource resource, ParthenosRegistryResource prr) throws IOException, ResourceRegistryException, InvalidQueryException, ParthenosPublisherException {
        JsonFactory jsonFactory = new JsonFactory();
        ArrayList jsonRels = Lists.newArrayList();
        if (resource.hasProperty(RDF.type, (RDFNode)CRMpe.PE1_Service)) {
            jsonRels.addAll(this.getRels(resource, prr, CRM.P129_is_about, jsonFactory));
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP2_provided_by, jsonFactory));
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP45_has_competency, jsonFactory));
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP4_hosts_object, jsonFactory));
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP31_uses_curation_plan, jsonFactory));
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP32_curates, jsonFactory));
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP6_hosts_digital_object, jsonFactory));
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP7_hosts_software_object, jsonFactory));
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP8_hosts_dataset, jsonFactory));
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP29_uses_access_protocol, jsonFactory));
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP47_has_protocol_type, jsonFactory));
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP46_brokers_access_to, jsonFactory));
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP11_curates_volatile_digital_object, jsonFactory));
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP12_curates_volatile_software, jsonFactory));
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP13_curates_volatile_dataset, jsonFactory));
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP15_delivers_on_request, jsonFactory));
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP45_has_competency, jsonFactory));
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP1i_is_currently_offered_by, CRMpe.PP1_currently_offers, jsonFactory));
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP46i_has_access_brokered_by, CRMpe.PP46_brokers_access_to, jsonFactory));
        }
        if (resource.hasProperty(RDF.type, (RDFNode)CRMdig.D1_Digital_Object)) {
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP6i_is_digital_object_hosted_by, CRMpe.PP6_hosts_digital_object, jsonFactory));
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP18i_is_digital_object_part_of, CRMpe.PP18_has_digital_object_part, jsonFactory));
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP39i_has_metadata, CRMpe.PP39_is_metadata_for, jsonFactory));
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP41i_is_indexed_by, CRMpe.PP41_is_index_of, jsonFactory));
        }
        if (resource.hasProperty(RDF.type, (RDFNode)CRMpe.PE18_Dataset)) {
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP23i_is_dataset_part_of, CRMpe.PP23_has_dataset_part, jsonFactory));
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP8i_is_dataset_hosted_by, CRMpe.PP8_hosts_dataset, jsonFactory));
        }
        if (resource.hasProperty(RDF.type, (RDFNode)CRMdig.D14_Software)) {
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP14i_is_run_by, CRMpe.PP14_runs_on_request, jsonFactory));
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP15i_is_delivered_by, CRMpe.PP15_delivers_on_request, jsonFactory));
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP21i_is_software_part_of, CRMpe.PP21_has_software_part, jsonFactory));
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP29i_is_access_protocol_used_by, CRMpe.PP29_uses_access_protocol, jsonFactory));
        }
        if (resource.hasProperty(RDF.type, (RDFNode)CRMpe.PE19_Persistent_Digital_Object)) {
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP16_has_persistent_digital_object_part, jsonFactory));
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP16i_is_persistent_digital_object_part_of, CRMpe.PP16_has_persistent_digital_object_part, jsonFactory));
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP17i_is_snapshot_of, CRMpe.PP17_has_snapshot, jsonFactory));
        }
        if (resource.hasProperty(RDF.type, (RDFNode)CRMpe.PE20_Volatile_Digital_Object)) {
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP17_has_snapshot, jsonFactory));
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP18_has_digital_object_part, jsonFactory));
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP11i_is_volatile_digital_object_curated_by, CRMpe.PP11_curates_volatile_digital_object, jsonFactory));
        }
        if (resource.hasProperty(RDF.type, (RDFNode)CRMpe.PE21_Persistent_Software)) {
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP19_has_persistent_software_part, jsonFactory));
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP19i_is_persistent_software_part_of, CRMpe.PP19_has_persistent_software_part, jsonFactory));
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP22i_is_release_of, CRMpe.PP22_has_release, jsonFactory));
        }
        if (resource.hasProperty(RDF.type, (RDFNode)CRMpe.PE22_Persistent_Dataset)) {
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP20_has_persistent_dataset_part, jsonFactory));
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP39_is_metadata_for, jsonFactory));
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP20i_is_persistent_dataset_part_of, CRMpe.PP20_has_persistent_dataset_part, jsonFactory));
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP24i_is_dataset_snapshot_of, CRMpe.PP24_has_dataset_snapshot, jsonFactory));
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP40i_is_deprecated_by, CRMpe.PP40_created_successor_of, jsonFactory));
        }
        if (resource.hasProperty(RDF.type, (RDFNode)CRMpe.PE23_Volatile_Software)) {
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP21_has_software_part, jsonFactory));
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP22_has_release, jsonFactory));
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP12i_is_volatile_software_curated_by, CRMpe.PP12_curates_volatile_software, jsonFactory));
        }
        if (resource.hasProperty(RDF.type, (RDFNode)CRMpe.PE24_Volatile_Dataset)) {
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP23_has_dataset_part, jsonFactory));
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP24_has_dataset_snapshot, jsonFactory));
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP41_is_index_of, jsonFactory));
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP13i_is_volatile_dataset_curated_by, CRMpe.PP13_curates_volatile_dataset, jsonFactory));
        }
        if (resource.hasProperty(RDF.type, (RDFNode)CRMpe.PE26_RI_Project)) {
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP25_has_maintaining_RI, jsonFactory));
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP1_currently_offers, jsonFactory));
        }
        if (resource.hasProperty(RDF.type, (RDFNode)CRMpe.PE35_Project)) {
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP43_supported_project_activity, jsonFactory));
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP44_has_maintaining_team, jsonFactory));
        }
        if (resource.hasProperty(RDF.type, (RDFNode)CRM.E39_Actor)) {
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP2i_provides, CRMpe.PP2_provided_by, jsonFactory));
        }
        if (resource.hasProperty(RDF.type, (RDFNode)CRMpe.PE34_Team)) {
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP44i_is_maintaining_team_of, CRMpe.PP44_has_maintaining_team, jsonFactory));
        }
        if (resource.hasProperty(RDF.type, (RDFNode)CRM.E70_Thing)) {
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP4i_is_object_hosted_by, CRMpe.PP4_hosts_object, jsonFactory));
        }
        if (resource.hasProperty(RDF.type, (RDFNode)CRMpe.PE25_RI_Consortium)) {
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP25i_is_maintaining_RI_of, CRMpe.PP25_has_maintaining_RI, jsonFactory));
        }
        if (resource.hasProperty(RDF.type, (RDFNode)CRMpe.PE28_Curation_Plan)) {
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP31i_is_curation_plan_used_by, CRMpe.PP31_uses_curation_plan, jsonFactory));
        }
        if (resource.hasProperty(RDF.type, (RDFNode)CRMpe.PE32_Curated_Thing)) {
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP32i_is_curated_by, CRMpe.PP32_curates, jsonFactory));
        }
        if (resource.hasProperty(RDF.type, (RDFNode)CRM.E65_Creation)) {
            jsonRels.addAll(this.getRels(resource, prr, CRMpe.PP40_created_successor_of, jsonFactory));
        }
        if (resource.hasProperty(RDF.type, (RDFNode)CRM.E7_Activity)) {
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP43i_is_project_activity_supported_by, CRMpe.PP43_supported_project_activity, jsonFactory));
        }
        if (resource.hasProperty(RDF.type, (RDFNode)CRMpe.PE36_Competency_Type)) {
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP45i_is_competency_of, CRMpe.PP45_has_competency, jsonFactory));
        }
        if (resource.hasProperty(RDF.type, (RDFNode)CRMpe.PE37_Protocol_Type)) {
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP47i_is_protocol_type_of, CRMpe.PP47_has_protocol_type, jsonFactory));
        }
        if (resource.hasProperty(RDF.type, (RDFNode)CRMpe.PE38_Schema)) {
            jsonRels.addAll(this.getInverseRels(resource, prr, CRMpe.PP47i_is_protocol_type_of, CRMpe.PP47_has_protocol_type, jsonFactory));
        }
        return jsonRels;
    }

    protected List<ParthenosRegistryRel> getRels(Resource subject, ParthenosRegistryResource subjectPrr, Property rel, JsonFactory jsonFactory) throws IOException, InvalidQueryException, ParthenosPublisherException, ResourceRegistryException {
        ArrayList rels = Lists.newArrayList();
        StmtIterator it = subject.listProperties(rel);
        while (it.hasNext()) {
            Resource obj = it.nextStatement().getResource();
            if (obj == null) {
                throw new ParthenosPublisherException(String.format("No target resource available for %s --> %s", subject.getURI(), rel.getURI()));
            }
            ParthenosRegistryResource target = this.findInRegistry(obj.getURI());
            if (target == null) {
                log.debug((Object)String.format("Rel: %s - %s - %s: target is not yet registered", subject.getURI(), rel.getLocalName(), obj.getURI()));
                continue;
            }
            rels.add(this.getRel(subjectPrr, rel, target, jsonFactory));
        }
        return rels;
    }

    protected ParthenosRegistryRel getRel(ParthenosRegistryResource subjectPrr, Property rel, ParthenosRegistryResource targetPrr, JsonFactory jsonFactory) throws IOException {
        String relJson = this.relWriter.writeRelationship(jsonFactory, rel.getLocalName(), subjectPrr.getUuid(), subjectPrr.getRegistryType(), targetPrr.getUuid(), targetPrr.getRegistryType());
        return new ParthenosRegistryRel().json(relJson).relName(rel.getLocalName());
    }

    protected List<ParthenosRegistryRel> getInverseRels(Resource resource, ParthenosRegistryResource resourcePRR, Property rel, Property inverseRel, JsonFactory jsonFactory) throws IOException, InvalidQueryException, ResourceRegistryException {
        ArrayList rels = Lists.newArrayList();
        StmtIterator it = resource.listProperties(rel);
        while (it.hasNext()) {
            Resource obj = it.nextStatement().getResource();
            String objURI = obj.getURI();
            ParthenosRegistryResource registryRes = this.findInRegistry(objURI);
            if (registryRes == null) continue;
            rels.add(this.getRel(registryRes, inverseRel, resourcePRR, jsonFactory));
        }
        return rels;
    }

    protected void writeCommon(Resource resource, String className, JsonGenerator jg, String uuid) throws IOException {
        jg.writeObjectFieldStart("header");
        jg.writeStringField("uuid", uuid);
        jg.writeEndObject();
        jg.writeStringField("@class", StringUtils.remove((String)className, (char)'-'));
    }

    protected void writeCommonFacets(Resource res, JsonGenerator jg) throws IOException {
        this.facetWriter.writeIdentifierFacet(jg, res.getURI());
        this.facetWriter.writeP1Facets(jg, res);
        this.facetWriter.writeInfoFacet(jg, res);
    }

    public ParthenosRegistryResource findInRegistry(String uri) throws ResourceRegistryException {
        HashMap queryMap = Maps.newHashMap();
        queryMap.put("value", uri);
        List resources = this.resourceRegistryClient.getFilteredResources(org.gcube.informationsystem.model.entity.Resource.class, IsIdentifiedBy.class, IdentifierFacet.class, true, (Map)queryMap);
        if (resources.isEmpty()) {
            return null;
        }
        org.gcube.informationsystem.model.entity.Resource resource = (org.gcube.informationsystem.model.entity.Resource)resources.get(0);
        if (resources.size() > 1) {
            log.warn((Object)("More than one resource in registry with uri " + uri + " -- considering the first, with uuid: " + resource.getHeader().getUUID()));
        }
        ParthenosRegistryResource prr = new ParthenosRegistryResource().setUuid(resource.getHeader().getUUID().toString()).setType(resource.getClass().getSimpleName());
        log.debug((Object)prr.toString());
        return prr;
    }

    public FacetWriter getFacetWriter() {
        return this.facetWriter;
    }

    public void setFacetWriter(FacetWriter facetWriter) {
        this.facetWriter = facetWriter;
    }

    public String getApplicationToken() {
        return this.applicationToken;
    }

    public void setApplicationToken(String applicationToken) {
        this.applicationToken = applicationToken;
    }

    public String getRegistryBaseURL() {
        return this.registryBaseURL;
    }

    public void setRegistryBaseURL(String registryBaseURL) {
        this.registryBaseURL = registryBaseURL;
    }

    public RelWriter getRelWriter() {
        return this.relWriter;
    }

    public void setRelWriter(RelWriter relWriter) {
        this.relWriter = relWriter;
    }

    public ResourceRegistryPublisher getResourceRegistryPublisher() {
        return this.resourceRegistryPublisher;
    }

    public void setResourceRegistryPublisher(ResourceRegistryPublisher resourceRegistryPublisher) {
        this.resourceRegistryPublisher = resourceRegistryPublisher;
    }

    public ResourceRegistryClient getResourceRegistryClient() {
        return this.resourceRegistryClient;
    }

    public void setResourceRegistryClient(ResourceRegistryClient resourceRegistryClient) {
        this.resourceRegistryClient = resourceRegistryClient;
    }

    public ResourceReader getResourceReader() {
        return this.resourceReader;
    }

    public void setResourceReader(ResourceReader resourceReader) {
        this.resourceReader = resourceReader;
    }
}

