/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.parthenos.virtuoso;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import eu.dnetlib.parthenos.CRM;
import eu.dnetlib.parthenos.publisher.ParthenosPublisherException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.sparql.engine.http.QueryEngineHTTP;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class VirtuosoReadAPI {
    private static final Log log = LogFactory.getLog(VirtuosoReadAPI.class);
    @Value(value="${virtuoso.sparqlurl}")
    private String sparqlUrl;
    @Value(value="${virtuoso.pwd}")
    private String username;
    @Value(value="${virtuoso.pwd}")
    private String password;
    @Value(value="${virtuoso.uri.base.default}")
    private String defaultBaseURI;
    @Value(value="${virtuoso.connectionstring")
    private String virtuosoConnectionString;
    @Autowired
    private Configuration freemarkerConfig;

    @RequestMapping(value={"/virtuoso/apiSubjectsWithType"}, produces={"application/json"}, method={RequestMethod.GET})
    public List<String> getSubjectsForApiWithType(@RequestParam String api, @RequestParam String typeNamespace, @RequestParam String typeName, @RequestParam int limit, @RequestParam int offset) {
        String fullTypeName = typeNamespace + typeName;
        log.debug((Object)String.format("Getting subjects of type %s for API %s limit %d offset %d", fullTypeName, api, limit, offset));
        String queryForSubjectsTemplate = "DEFINE input:inference 'parthenos_rules' SELECT DISTINCT ?s WHERE { GRAPH ?g {?s a <%s> .} . GRAPH <provenance> {?g <dnetcollectedFrom> <%s> .}} LIMIT %d OFFSET %d";
        String q = String.format(queryForSubjectsTemplate, fullTypeName, this.defaultBaseURI + api, limit, offset);
        QueryEngineHTTP serviceRequest = new QueryEngineHTTP(this.sparqlUrl, q);
        ResultSet subjects = serviceRequest.execSelect();
        Iterator s = Iterators.transform((Iterator)subjects, qs -> qs.getResource("s").getURI());
        ArrayList res = Lists.newArrayList((Iterator)s);
        serviceRequest.close();
        return res;
    }

    @Deprecated
    @RequestMapping(value={"/virtuoso/apiSubjects"}, produces={"application/json"}, method={RequestMethod.GET})
    public List<String> getSubjectsForApi(@RequestParam String api, @RequestParam int limit, @RequestParam int offset) {
        log.debug((Object)String.format("Getting subjects for API %s, limit %d offset %d", api, limit, offset));
        String queryForSubjectsTemplate = "DEFINE input:inference 'parthenos_rules' SELECT DISTINCT ?s WHERE { GRAPH ?g {?s a ?t . FILTER (?t != <%s> && ?t != <%s>)} . GRAPH <provenance> {?g <dnetcollectedFrom> <%s> .}} LIMIT %d OFFSET %d ";
        String q = String.format(queryForSubjectsTemplate, CRM.E55_Type.getURI(), CRM.E41_Appellation.getURI(), this.defaultBaseURI + api, limit, offset);
        QueryEngineHTTP serviceRequest = new QueryEngineHTTP(this.sparqlUrl, q);
        ResultSet subjects = serviceRequest.execSelect();
        Iterator s = Iterators.transform((Iterator)subjects, qs -> qs.getResource("s").getURI());
        ArrayList res = Lists.newArrayList((Iterator)s);
        serviceRequest.close();
        return res;
    }

    @RequestMapping(value={"/virtuoso/subject"}, produces={"application/rdf+xml", "application/xml"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public void getSubject(@RequestParam String subjectURL, @RequestParam String typeName, @RequestParam(name="timeout") String timeoutMs, OutputStream responseStream) throws IOException, TemplateException, ParthenosPublisherException {
        String templateName = typeName + ".sparql";
        Template temp = this.freemarkerConfig.getTemplate(templateName);
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("subjectURL", subjectURL);
        StringWriter sw = new StringWriter();
        temp.process(values, (Writer)sw);
        String q = sw.toString();
        log.debug((Object)("Querying for " + subjectURL + " with query " + templateName));
        this.sendConstructResponse(q, timeoutMs, responseStream);
    }

    protected void sendConstructResponse(String query, String timeoutMs, OutputStream responseStream) throws IOException, ParthenosPublisherException {
        String res = this.executeSparqlPost(query, timeoutMs);
        IOUtils.write((String)res, (OutputStream)responseStream);
    }

    /*
     * Exception decompiling
     */
    protected String executeSparqlPost(String query, String timeoutMs) throws IOException, ParthenosPublisherException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

