/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.parthenos.catalogue;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.parthenos.jrr.ParthenosRegistryResource;
import java.io.IOException;

public class CatalogueAPIResponse {
    private JsonNode response;

    public void setResponseBody(String responseBody) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        this.response = mapper.readTree(responseBody);
    }

    public boolean isSuccess() {
        return this.response.get("success").asBoolean();
    }

    public ParthenosRegistryResource getParthenosRegistryResource() throws IOException {
        if (!this.hasParthenosRegistryResource()) {
            return null;
        }
        JsonNode result = this.response.get("result");
        return this.parseResult(result);
    }

    public boolean hasParthenosRegistryResource() {
        JsonNode result = this.response.path("result");
        return !result.isMissingNode();
    }

    public String getErrorMessage() {
        if (this.isSuccess()) {
            return "";
        }
        JsonNode message = this.response.path("message");
        if (!message.isMissingNode()) {
            return message.toString();
        }
        JsonNode error = this.response.get("error");
        if (!error.isMissingNode()) {
            return error.toString();
        }
        return "Error message not available in error or message fields";
    }

    protected ParthenosRegistryResource parseResult(JsonNode result) throws IOException {
        String uuid = result.get("id").asText();
        String type = null;
        JsonNode extras = result.get("extras");
        for (JsonNode jn : extras) {
            String key = jn.get("key").asText();
            if (!key.equals("system:type")) continue;
            type = jn.get("value").asText();
        }
        return new ParthenosRegistryResource().setJson(result.asText()).setType(type).setUuid(uuid);
    }
}

