/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.parthenos.rdf;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import eu.dnetlib.parthenos.CRM;
import eu.dnetlib.parthenos.CRMpe;
import eu.dnetlib.parthenos.catalogue.CatalogueLicense;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.assembler.AssemblerHelp;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.springframework.stereotype.Component;

@Component
public class ResourceReader {
    private static final Log log = LogFactory.getLog(ResourceReader.class);
    private Property availibilityProperty = ResourceFactory.createProperty((String)"", (String)"availability");
    private Property activitytypeProperty = ResourceFactory.createProperty((String)"", (String)"activitytype");
    private Property encodingProperty = ResourceFactory.createProperty((String)"", (String)"encoding");
    private Property usedSoftwareProperty = ResourceFactory.createProperty((String)"", (String)"used_software");
    private Property usedByProperty = ResourceFactory.createProperty((String)"", (String)"usedby");
    private Property creatorProperty = ResourceFactory.createProperty((String)"", (String)"creator");
    private Property creationtimeProperty = ResourceFactory.createProperty((String)"", (String)"creationtime");

    public String getTitle(Resource resource) {
        RDFNode obj;
        Statement s = resource.getProperty(CRM.P102_has_title);
        if (s != null && (obj = s.getObject()).isLiteral()) {
            return obj.asLiteral().getLexicalForm();
        }
        return this.getLabel(resource);
    }

    public String getLabel(Resource resource) {
        if (resource == null) {
            return "";
        }
        if (resource.hasProperty(RDFS.label)) {
            return resource.getProperty(RDFS.label).getString().replace("'", "'");
        }
        return "";
    }

    public Iterator<String> getDescriptions(Resource resource) {
        StmtIterator it = resource.listProperties(CRM.P3_has_note);
        return Iterators.transform((Iterator)it, f -> f.getString().replace("'", "'"));
    }

    public Iterator<String> getCompetences(Resource resource) {
        StmtIterator it = resource.listProperties(CRMpe.PP45_has_competency);
        return Iterators.transform((Iterator)it, f -> f.getString());
    }

    public String getAvailability(Resource resource) {
        String availability = "";
        if (resource.hasProperty(this.availibilityProperty)) {
            availability = resource.getProperty(this.availibilityProperty).getString();
        }
        return availability;
    }

    public String getConditionOfUse(Resource resource) {
        StmtIterator it = resource.listProperties(CRM.P16_used_specific_object);
        while (it.hasNext()) {
            Resource obj = ((Statement)it.next()).getResource();
            if (!obj.hasProperty(RDF.type, (RDFNode)CRM.E30_Right) || !obj.hasProperty(CRM.P3_has_note)) continue;
            String rightsString = obj.getProperty(CRM.P3_has_note).getString();
            if (obj.hasProperty(CRM.P2_has_type)) {
                Resource rightType = obj.getPropertyResourceValue(CRM.P2_has_type);
                rightsString = rightsString + " [" + this.getLabel(rightType) + "]";
            }
            return rightsString;
        }
        return "";
    }

    public CatalogueLicense getCatalogueLicense(Resource resource) {
        Resource obj;
        if (resource.hasProperty(CRM.P16_used_specific_object) && (obj = resource.getPropertyResourceValue(CRM.P16_used_specific_object)).hasProperty(CRM.P2_has_type)) {
            String license = this.getLabel(obj.getPropertyResourceValue(CRM.P2_has_type));
            return CatalogueLicense.getCatalogueLicenseFor((String)license);
        }
        return CatalogueLicense.NotSpecified;
    }

    public Iterator<String> getRDFClassNames(Resource resource) {
        StmtIterator it = resource.listProperties(RDF.type);
        return Iterators.transform((Iterator)it, f -> f.getResource().getLocalName());
    }

    public Iterator<String> getActivityTypes(Resource resource) {
        StmtIterator it = resource.listProperties(this.activitytypeProperty);
        return Iterators.transform((Iterator)it, f -> f.getString());
    }

    public Iterator<String> getProviderNames(Resource resource) {
        StmtIterator sit = resource.listProperties(CRMpe.PP2_provided_by);
        StmtIterator sit2 = resource.listProperties(CRMpe.PP25_has_maintaining_RI);
        return Iterators.transform((Iterator)Iterators.concat((Iterator)sit, (Iterator)sit2), f -> {
            Resource provider = f.getResource();
            return this.getTitle(provider);
        });
    }

    public Iterator<String> getProviderUris(Resource resource) {
        StmtIterator sit = resource.listProperties(CRMpe.PP2_provided_by);
        StmtIterator sit2 = resource.listProperties(CRMpe.PP25_has_maintaining_RI);
        return Iterators.transform((Iterator)Iterators.concat((Iterator)sit, (Iterator)sit2), f -> f.getResource().getURI());
    }

    public Iterator<String> getProviderContactPoints(Resource resource) {
        StmtIterator it = resource.listProperties(CRMpe.PP2_provided_by);
        return Iterators.transform((Iterator)it, f -> {
            Resource provider = f.getResource();
            if (provider.hasProperty(CRM.P76_has_contact_point)) {
                Resource contactPoint = provider.getPropertyResourceValue(CRM.P76_has_contact_point);
                return this.getLabel(contactPoint);
            }
            return "";
        });
    }

    public Iterator<String> getResourceDirectContactPointsURI(Resource resource) {
        StmtIterator it = resource.listProperties(CRM.P76_has_contact_point);
        return Iterators.transform((Iterator)it, f -> f.getResource().getURI());
    }

    public Iterator<String> getHostedStuff(Resource resource) {
        StmtIterator sit4 = resource.listProperties(CRMpe.PP4_hosts_object);
        return Iterators.transform((Iterator)sit4, f -> f.getResource().getURI());
    }

    public Iterator<String> getHostedBys(Resource resource) {
        StmtIterator sit4 = resource.listProperties(CRMpe.PP4i_is_object_hosted_by);
        return Iterators.transform((Iterator)sit4, f -> f.getResource().getURI());
    }

    public Iterator<String> getCuratedObjects(Resource resource) {
        StmtIterator sit32 = resource.listProperties(CRMpe.PP32_curates);
        return Iterators.transform((Iterator)sit32, f -> f.getResource().getURI());
    }

    public Iterator<String> getCuratorUrls(Resource resource) {
        StmtIterator sit32 = resource.listProperties(CRMpe.PP32i_is_curated_by);
        return Iterators.transform((Iterator)sit32, f -> f.getResource().getURI());
    }

    public Iterator<String> getResourceCuratorCurationPlans(Resource resource) {
        StmtIterator sit32 = resource.listProperties(CRMpe.PP32i_is_curated_by);
        return Iterators.concat((Iterator)Iterators.transform((Iterator)sit32, c -> this.getCurationPlans(c.getResource())));
    }

    public Iterator<String> getDeliversOnRequest(Resource resource) {
        StmtIterator sit = resource.listProperties(CRMpe.PP15_delivers_on_request);
        return Iterators.transform((Iterator)sit, f -> f.getResource().getURI());
    }

    public Iterator<String> getRunsOnRequest(Resource resource) {
        StmtIterator sit = resource.listProperties(CRMpe.PP14_runs_on_request);
        return Iterators.transform((Iterator)sit, f -> f.getResource().getURI());
    }

    public Iterator<String> getAccessPoints(Resource resource) {
        StmtIterator it = resource.listProperties(CRMpe.PP28_has_designated_access_point);
        return Iterators.transform((Iterator)it, f -> f.getResource().getURI());
    }

    public Iterator<String> getDeclarativeTimes(Resource resource) {
        StmtIterator it = resource.listProperties(CRMpe.PP42_has_declarative_time);
        return Iterators.transform((Iterator)it, f -> f.getString());
    }

    public Iterator<String> getProtocols(Resource resource) {
        StmtIterator it = resource.listProperties(CRMpe.PP29_uses_access_protocol);
        return Iterators.transform((Iterator)it, f -> this.getLabel(f.getResource()));
    }

    public Iterator<String> getCurationPlans(Resource resource) {
        StmtIterator it = resource.listProperties(CRMpe.PP31_uses_curation_plan);
        return Iterators.transform((Iterator)it, f -> f.getResource().getURI());
    }

    public Iterator<String> getMemberUrls(Resource resource) {
        StmtIterator it = resource.listProperties(CRM.P107_has_current_or_former_member);
        return Iterators.transform((Iterator)it, f -> f.getResource().getURI());
    }

    public Iterator<String> isMemberOf(Resource resource) {
        StmtIterator it = resource.listProperties(CRM.P107i_is_current_or_former_member_of);
        return Iterators.transform((Iterator)it, f -> f.getResource().getURI());
    }

    public Iterator<String> getProvidedServiceUrls(Resource resource) {
        StmtIterator it = resource.listProperties(CRMpe.PP2i_provides);
        return Iterators.transform((Iterator)it, f -> f.getResource().getURI());
    }

    public Iterator<String> getHasTypeLabels(Resource resource) {
        StmtIterator it = resource.listProperties(CRM.P2_has_type);
        return Iterators.transform((Iterator)it, f -> {
            if (f.getObject().isLiteral()) {
                return f.getObject().asLiteral().getString();
            }
            return this.getLabel(f.getResource());
        });
    }

    public Iterator<String> getIsPartOfUrls(Resource resource) {
        StmtIterator it = resource.listProperties(CRM.P106i_forms_part_of);
        return Iterators.transform((Iterator)it, f -> f.getResource().getURI());
    }

    public Iterator<String> getHasPartUrls(Resource resource) {
        StmtIterator it = resource.listProperties(CRM.P106_is_composed_of);
        return Iterators.transform((Iterator)it, f -> f.getResource().getURI());
    }

    public Iterator<String> getSubjects(Resource resource) {
        StmtIterator it = resource.listProperties(CRM.P129_is_about);
        return Iterators.transform((Iterator)Iterators.filter((Iterator)it, f -> !f.getResource().hasProperty(RDF.type, (RDFNode)CRM.E4_Period) && !f.getResource().hasProperty(RDF.type, (RDFNode)CRM.E52_Time_Span) && !f.getResource().hasProperty(RDF.type, (RDFNode)CRM.E53_Place)), f -> this.getLabel(f.getResource()));
    }

    public List<String> getTemporalCoverages(Resource resource) {
        List temporalCoverages = this.getCoverages(resource, CRM.E4_Period);
        temporalCoverages.addAll(this.getCoverageTimeSpan(resource));
        return temporalCoverages;
    }

    public List<String> getSpatialCoverages(Resource resource) {
        return this.getCoverages(resource, CRM.E53_Place);
    }

    private List<String> getCoverages(Resource resource, Resource coverageType) {
        ArrayList cov = Lists.newArrayList();
        StmtIterator it = resource.listProperties(CRM.P129_is_about);
        while (it.hasNext()) {
            Resource r = ((Statement)it.next()).getResource();
            if (!r.hasProperty(RDF.type, (RDFNode)coverageType)) continue;
            cov.add(this.getLabel(r));
        }
        return cov;
    }

    private List<String> getCoverageTimeSpan(Resource resource) {
        ArrayList cov = Lists.newArrayList();
        StmtIterator it = resource.listProperties(CRM.P129_is_about);
        while (it.hasNext()) {
            Resource r = ((Statement)it.next()).getResource();
            if (!r.hasProperty(RDF.type, (RDFNode)CRM.E52_Time_Span)) continue;
            StmtIterator times = r.listProperties(CRM.P82_at_some_time_within);
            while (times.hasNext()) {
                Resource t = ((Statement)times.next()).getResource();
                cov.add(t.toString());
            }
        }
        return cov;
    }

    public Iterator<String> getEncodings(Resource resource) {
        StmtIterator it = resource.listProperties(this.encodingProperty);
        return Iterators.transform((Iterator)it, f -> f.getString());
    }

    public Iterator<String> getCreatorsURIs(Resource resource) {
        StmtIterator it = resource.listProperties(this.creatorProperty);
        return Iterators.transform((Iterator)it, f -> f.getResource().getURI());
    }

    public Iterator<String> getMetadata(Resource resource) {
        StmtIterator it = resource.listProperties(CRMpe.PP39i_has_metadata);
        return Iterators.transform((Iterator)it, f -> f.getResource().getURI());
    }

    public Iterator<String> getDescribedDataset(Resource resource) {
        StmtIterator it = resource.listProperties(CRMpe.PP39_is_metadata_for);
        return Iterators.transform((Iterator)it, f -> f.getResource().getURI());
    }

    public Iterator<String> getOfferedServiceUrls(Resource resource) {
        StmtIterator it = resource.listProperties(CRMpe.PP1_currently_offers);
        return Iterators.transform((Iterator)it, f -> f.getResource().getURI());
    }

    public String getStartTime(Resource resource) {
        Resource timespan = resource.getPropertyResourceValue(CRM.P4_has_time_span);
        if (timespan != null && timespan.hasProperty(CRM.P82a_begin_of_the_begin)) {
            return timespan.getProperty(CRM.P82a_begin_of_the_begin).getString();
        }
        return "";
    }

    public String getFirstCreationTime(Resource resource) {
        StmtIterator it = resource.listProperties(this.creationtimeProperty);
        if (it.hasNext()) {
            return ((Statement)it.next()).getString();
        }
        return "";
    }

    public Iterator<String> getMaintainerUrls(Resource resource) {
        StmtIterator it = resource.listProperties(CRMpe.PP44_has_maintaining_team);
        return Iterators.transform((Iterator)it, f -> f.getResource().getURI());
    }

    public List<String> getMaintainerContacts(Resource resource) {
        ArrayList res = Lists.newArrayList();
        StmtIterator it = resource.listProperties(CRMpe.PP44_has_maintaining_team);
        while (it.hasNext()) {
            Resource maintainer = ((Statement)it.next()).getResource();
            Iterator itM = this.getResourceDirectContactPointsURI(maintainer);
            while (itM.hasNext()) {
                res.add(itM.next());
            }
        }
        return res;
    }

    public Iterator<String> getMaintainersLabels(Resource resource) {
        StmtIterator it = resource.listProperties(CRMpe.PP44_has_maintaining_team);
        return Iterators.transform((Iterator)it, f -> this.getLabel(f.getResource()));
    }

    public Iterator<String> getMaintainedUrls(Resource resource) {
        StmtIterator it = resource.listProperties(CRMpe.PP44i_is_maintaining_team_of);
        return Iterators.transform((Iterator)it, f -> f.getResource().getURI());
    }

    public Iterator<String> getSnapshots(Resource resource) {
        StmtIterator it = resource.listProperties(CRMpe.PP17_has_snapshot);
        return Iterators.transform((Iterator)it, f -> f.getResource().getURI());
    }

    public Iterator<String> getIsSnapshotOfs(Resource resource) {
        StmtIterator it = resource.listProperties(CRMpe.PP17i_is_snapshot_of);
        return Iterators.transform((Iterator)it, f -> f.getResource().getURI());
    }

    public Iterator<String> getHasReleases(Resource resource) {
        StmtIterator it = resource.listProperties(CRMpe.PP22_has_release);
        return Iterators.transform((Iterator)it, f -> f.getResource().getURI());
    }

    public Iterator<String> getIsReleaseOfs(Resource resource) {
        StmtIterator it = resource.listProperties(CRMpe.PP22i_is_release_of);
        return Iterators.transform((Iterator)it, f -> f.getResource().getURI());
    }

    public Iterator<String> getUsedSoftware(Resource resource) {
        StmtIterator it = resource.listProperties(this.usedSoftwareProperty);
        return Iterators.transform((Iterator)it, f -> f.getResource().getURI());
    }

    public Iterator<String> getUsedBy(Resource resource) {
        StmtIterator it = resource.listProperties(this.usedByProperty);
        return Iterators.transform((Iterator)it, f -> f.getResource().getURI());
    }

    public Iterator<String> getLanguages(Resource resource) {
        StmtIterator it = resource.listProperties(CRM.P72_has_language);
        return Iterators.transform((Iterator)it, f -> f.getString());
    }

    public Resource findSpecificType(Resource res, Resource fallbackType) {
        Resource type = fallbackType;
        Set types = AssemblerHelp.findSpecificTypes((Resource)res, (Resource)fallbackType);
        if (types == null || types.isEmpty()) {
            log.warn((Object)("No specific type found. Returning the fallback type: " + fallbackType));
        }
        if (types.size() == 1) {
            type = (Resource)types.iterator().next();
        }
        if (types.size() > 1) {
            log.warn((Object)"Found more than one possible specific type: choosing the first");
            types.stream().forEach(t -> log.warn(t));
            type = (Resource)types.iterator().next();
        }
        return type;
    }
}

