package eu.dnetlib.parthenos.virtuoso;

import eu.dnetlib.parthenos.rdf.RecordParserHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * Created by Alessia Bardi on 12/07/2017.
 *
 * @author Alessia Bardi
 */
@Component
public class VirtuosoClientFactory {

	private static final Log log = LogFactory.getLog(VirtuosoClientFactory.class);
	@Value("${virtuoso.connectionstring}")
	private String connectionString;
	@Value("${virtuoso.usr}")
	private String username;
	@Value("${virtuoso.pwd}")
	private String password;
	@Value("${virtuoso.uri.base.default}")
	private String defaultBaseURI;

	@Autowired
	private RecordParserHelper recordParserHelper;

	public VirtuosoClient getVirtuosoClient() {
		log.debug("Creating VirtuosoClient for "+connectionString);
		return new VirtuosoClient(connectionString, username, password, recordParserHelper, defaultBaseURI);
	}

	public String getConnectionString() {
		return connectionString;
	}

	public void setConnectionString(final String connectionString) {
		this.connectionString = connectionString;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(final String username) {
		this.username = username;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(final String password) {
		this.password = password;
	}

	public String getDefaultBaseURI() {
		return defaultBaseURI;
	}

	public void setDefaultBaseURI(final String defaultBaseURI) {
		this.defaultBaseURI = defaultBaseURI;
	}

	public RecordParserHelper getRecordParserHelper() {
		return recordParserHelper;
	}

	public void setRecordParserHelper(final RecordParserHelper recordParserHelper) {
		this.recordParserHelper = recordParserHelper;
	}
}
