/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.parthenos.registry;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Joiner;
import eu.dnetlib.parthenos.CRM;
import eu.dnetlib.parthenos.CRMpe;
import eu.dnetlib.parthenos.rdf.ResourceReader;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.gcube.resourcemanagement.model.reference.entity.facet.IdentifierFacet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FacetWriter {
    @Autowired
    private ResourceReader resourceReader;

    public void writeP1Facet(JsonGenerator jg, String value) throws IOException {
        jg.writeStartObject();
        jg.writeStringField("@class", "P1_is_identified_by");
        jg.writeObjectFieldStart("target");
        jg.writeStringField("@class", "SimpleFacet");
        jg.writeStringField("value", value);
        jg.writeEndObject();
        jg.writeEndObject();
    }

    public void writeIdentifierFacet(JsonGenerator jg, String identifier) throws IOException {
        jg.writeStartObject();
        jg.writeStringField("@class", "isIdentifiedBy");
        jg.writeObjectFieldStart("target");
        jg.writeStringField("@class", "IdentifierFacet");
        jg.writeStringField("value", identifier);
        jg.writeStringField("type", IdentifierFacet.IdentificationType.URI.name());
        jg.writeEndObject();
        jg.writeEndObject();
    }

    public void writeP1Facets(JsonGenerator jg, Resource res) throws IOException {
        if (res.hasProperty(CRM.P1_is_identified_by)) {
            StmtIterator idRelsIt = res.listProperties(CRM.P1_is_identified_by);
            while (idRelsIt.hasNext()) {
                RDFNode obj = idRelsIt.nextStatement().getObject();
                String value = "";
                if (obj.isLiteral()) {
                    value = obj.asLiteral().getLexicalForm();
                } else if (obj.isResource()) {
                    value = this.resourceReader.getLabel(obj.asResource());
                }
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                this.writeP1Facet(jg, value);
            }
        }
    }

    public void writeInfoFacet(JsonGenerator jg, Resource res) throws IOException {
        jg.writeStartObject();
        jg.writeStringField("@class", "consistsOf");
        jg.writeObjectFieldStart("target");
        jg.writeStringField("@class", "PE_Info_Facet");
        jg.writeStringField("title", this.resourceReader.getTitle(res));
        jg.writeStringField("description", Joiner.on((String)",").join(this.resourceReader.getDescriptions(res)));
        String competence = Joiner.on((char)',').join(this.resourceReader.getCompetences(res));
        if (StringUtils.isNotBlank((CharSequence)competence)) {
            this.writeValueSchema(jg, "competence", competence, "noSchema");
        }
        jg.writeEndObject();
        jg.writeEndObject();
    }

    protected void writeValueSchema(JsonGenerator jg, String fieldName, String value, String schema) throws IOException {
        jg.writeObjectFieldStart(fieldName);
        jg.writeStringField("value", value);
        jg.writeStringField("schema", schema);
        jg.writeEndObject();
    }

    public void writeEventFacet(JsonGenerator jg) {
    }

    public void writeRightsFacet(JsonGenerator jg, Resource res) throws IOException {
    }

    public void writeContactReferenceFacet(JsonGenerator jg, Resource actor) throws IOException {
        if (actor != null) {
            String appellation = this.resourceReader.getTitle(actor);
            String description = Joiner.on((char)',').join(this.resourceReader.getDescriptions(actor));
            String legalAddress = "";
            String email = "";
            String website = "";
            String address = "";
            String phoneNumber = "";
            StmtIterator contactPointsStm = actor.listProperties(CRM.P76_has_contact_point);
            while (contactPointsStm.hasNext()) {
                Resource cp = contactPointsStm.nextStatement().getResource();
                if (!cp.hasProperty(RDF.type, (RDFNode)CRM.E45_Address) && !cp.hasProperty(RDF.type, (RDFNode)CRM.E51_Contact_Point) || !cp.hasProperty(CRM.P2_has_type)) continue;
                Resource addressType = cp.getPropertyResourceValue(CRM.P2_has_type);
                String info = this.resourceReader.getLabel(cp);
                String addressTypeLabel = this.resourceReader.getLabel(addressType);
                switch (addressTypeLabel.toLowerCase()) {
                    case "email": {
                        email = info;
                        break;
                    }
                    case "legal address": {
                        legalAddress = info;
                        break;
                    }
                    case "address": {
                        address = info;
                        break;
                    }
                    case "phone": {
                        phoneNumber = info;
                        break;
                    }
                    case "web": {
                        website = info;
                    }
                }
            }
            jg.writeStartObject();
            jg.writeStringField("@class", "consistsOf");
            jg.writeObjectFieldStart("target");
            jg.writeStringField("@class", "PE_Contact_Reference_Facet");
            jg.writeStringField("appellation", appellation);
            jg.writeStringField("description", description);
            jg.writeStringField("legalAddress", legalAddress);
            if (StringUtils.isNotBlank((CharSequence)email)) {
                jg.writeStringField("email", email);
            }
            jg.writeStringField("website", website);
            jg.writeStringField("address", address);
            jg.writeStringField("phoneNumber", phoneNumber);
            jg.writeEndObject();
            jg.writeEndObject();
        }
    }

    public void writeDesignatedAccessPointFacet(JsonGenerator jg, Resource resource) throws IOException {
        StmtIterator apStms = resource.listProperties(CRMpe.PP28_has_designated_access_point);
        while (apStms.hasNext()) {
            String entryName = this.resourceReader.getLabel(resource);
            String endpoint = "";
            String protocol = "";
            String description = Joiner.on((char)',').join(this.resourceReader.getDescriptions(resource));
            String authorization = "";
            Resource ap = ((Statement)apStms.next()).getResource();
            endpoint = ap.getURI();
            jg.writeStartObject();
            jg.writeStringField("@class", "consistsOf");
            jg.writeObjectFieldStart("target");
            jg.writeStringField("@class", "PE29_Access_Point");
            jg.writeStringField("entryName", entryName);
            jg.writeStringField("description", description);
            jg.writeStringField("endpoint", endpoint);
            jg.writeStringField("protocol", protocol);
            jg.writeEndObject();
            jg.writeEndObject();
        }
    }

    public void writeTemporalCoverageFacet(JsonGenerator jg, Resource resource) {
    }

    public ResourceReader getResourceReader() {
        return this.resourceReader;
    }

    public void setResourceReader(ResourceReader resourceReader) {
        this.resourceReader = resourceReader;
    }
}

