package eu.dnetlib.parthenos.jrr;

import org.apache.commons.lang3.StringUtils;

/**
 * Created by Alessia Bardi on 06/10/2017.
 *
 * @author Alessia Bardi
 */
public class ParthenosRegistryResource {

	private String uuid;
	private String type;
	private String json;

	public String getUuid() {
		return uuid;
	}

	public ParthenosRegistryResource setUuid(final String uuid) {
		this.uuid = uuid;
		return this;
	}

	public String getType() {
		return type;
	}

	public String getRegistryType(){
		return StringUtils.remove(type, '-');
	}

	public ParthenosRegistryResource setType(final String type) {
		this.type = type;
		return this;
	}

	public String getJson() {
		return json;
	}

	public ParthenosRegistryResource setJson(final String json) {
		this.json = json;
		return this;
	}

	@Override
	public String toString() {
		return "ParthenosRegistryResource{" +
				"uuid='" + uuid + '\'' +
				", type='" + type + '\'' +
				", json='" + json + '\'' +
				'}';
	}
}
