/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.parthenos.catalogue;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import eu.dnetlib.parthenos.CRM;
import eu.dnetlib.parthenos.catalogue.CKANUtils;
import eu.dnetlib.parthenos.catalogue.CatalogueAPIClient;
import eu.dnetlib.parthenos.jrr.ParthenosRegistryResource;
import eu.dnetlib.parthenos.publisher.ParthenosPublisherException;
import eu.dnetlib.parthenos.rdf.ResourceReader;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CatalogueRegistrator {
    private static final Log log = LogFactory.getLog(CatalogueRegistrator.class);
    private final String PARTHENOS_BASE_URL = "http://parthenos.d4science.org";
    @Autowired
    private ResourceReader resourceReader;
    @Autowired
    private CatalogueAPIClient catalogueAPIClient;

    public String register(Resource resource, Resource type, String datasourceName) throws IOException, ParthenosPublisherException, URISyntaxException, InterruptedException {
        String json;
        String resURI = resource.getURI();
        log.debug((Object)String.format("Catalogue --> Processing resource : %s with type: %s from source: %s", resURI, type.getLocalName(), datasourceName));
        String resCatName = this.getNameForCatalogue(resURI.substring(resURI.lastIndexOf("handle/") + 7));
        ParthenosRegistryResource prr = this.catalogueAPIClient.getRegistered(resCatName);
        if (prr != null) {
            log.debug((Object)(resCatName + " is already registered"));
            return prr.getUuid();
        }
        switch (type.getLocalName()) {
            case "E29_Design_or_Procedure": {
                json = this.getJsonForDesignProcedure(resource, resCatName, datasourceName);
                break;
            }
            case "D14_Software": {
                json = this.getJsonForSoftware(resource, resCatName, datasourceName);
                break;
            }
            case "PE35_Project": {
                json = this.getJsonForProject(resource, resCatName, datasourceName);
                break;
            }
            case "PE1_Service": {
                json = this.getJsonForService(resource, resCatName, datasourceName);
                break;
            }
            case "E39_Actor": {
                json = this.getJsonForActor(resource, resCatName, datasourceName);
                break;
            }
            case "PE18_Dataset": {
                json = this.getJsonForDataset(resource, resCatName, datasourceName);
                break;
            }
            case "E78_Collection": {
                json = this.getJsonForCollection(resource, resCatName, datasourceName);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Type " + type.getLocalName() + " not supported", new Object[0]));
            }
        }
        String uuid = this.catalogueAPIClient.doRegister(json, resCatName);
        if (StringUtils.isBlank((CharSequence)uuid)) {
            log.warn((Object)String.format("%s could not be registered, sleeping 1sec and then try again", resURI));
            Thread.sleep(1000L);
            uuid = this.catalogueAPIClient.doRegister(json, resCatName);
            if (StringUtils.isBlank((CharSequence)uuid)) {
                log.warn((Object)String.format("%s could not be registered even the second time, giving up", resURI));
                return null;
            }
        }
        log.debug((Object)String.format("%s registered on the catalogue with uuid: %s", resURI, uuid));
        return uuid;
    }

    protected boolean purge(String resCatName) throws URISyntaxException, IOException {
        return this.catalogueAPIClient.purgeItem(resCatName);
    }

    protected String getNameForCatalogue(String name) throws UnsupportedEncodingException {
        return StringUtils.replaceChars((String)name, (String)"/ .:", (String)"_").toLowerCase().replaceAll("[^A-Za-z0-9]", "_");
    }

    protected String getJsonForProject(Resource res, String resNameForCatalogue, String datasourceName) throws IOException, ParthenosPublisherException {
        JsonFactory jsonFactory = new JsonFactory();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(out);
        JsonGenerator jg = jsonFactory.createGenerator((OutputStream)bos, JsonEncoding.UTF8);
        jg.writeStartObject();
        this.writeCommonFields(jg, res, resNameForCatalogue, datasourceName);
        ArrayList maintainer_RIs = Lists.newArrayList((Iterator)this.resourceReader.getMaintainersLabels(res));
        if (maintainer_RIs.size() > 0) {
            jg.writeArrayFieldStart("groups");
            for (String ri : maintainer_RIs) {
                String group = CKANUtils.getCkanGroup((String)ri);
                if (!StringUtils.isNotBlank((CharSequence)group)) continue;
                jg.writeStartObject();
                jg.writeStringField("name", group);
                jg.writeEndObject();
            }
            jg.writeEndArray();
        }
        jg.writeStringField("maintainer", Joiner.on((String)", ").join(this.resourceReader.getMaintainersLabels(res)));
        jg.writeArrayFieldStart("extras");
        this.addExtra(jg, "system:type", CKANUtils.Project_type);
        this.addExtra(jg, "instance of", this.resourceReader.findSpecificType(res, CRM.E7_Activity).getLocalName());
        if (res.getURI().startsWith("http://parthenos.d4science.org")) {
            this.addExtra(jg, "Parthenos URL", res.getURI());
        } else {
            this.addExtra(jg, "URL", res.getURI());
        }
        this.addIdentifiers(res, jg);
        this.addExtra(jg, "started on", this.resourceReader.getStartTime(res));
        int idx = 1;
        Iterator maintainers = this.resourceReader.getMaintainerUrls(res);
        while (maintainers.hasNext()) {
            this.addExtra(jg, String.format("maintaining team (%d)", idx), (String)maintainers.next());
            ++idx;
        }
        idx = 1;
        Iterator services = this.resourceReader.getOfferedServiceUrls(res);
        while (services.hasNext()) {
            this.addExtra(jg, String.format("offers (%d)", idx), (String)services.next());
            ++idx;
        }
        jg.writeEndArray();
        jg.writeEndObject();
        jg.close();
        return out.toString("UTF-8");
    }

    protected String getJsonForService(Resource res, String resNameForCatalogue, String datasourceName) throws IOException, ParthenosPublisherException {
        JsonFactory jsonFactory = new JsonFactory();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(out);
        JsonGenerator jg = jsonFactory.createGenerator((OutputStream)bos, JsonEncoding.UTF8);
        jg.writeStartObject();
        this.writeCommonFields(jg, res, resNameForCatalogue, datasourceName);
        jg.writeStringField("maintainer", Joiner.on((String)", ").join(this.resourceReader.getMaintainersLabels(res)));
        jg.writeArrayFieldStart("extras");
        this.addExtra(jg, "system:type", CKANUtils.Service_type);
        this.addExtra(jg, "instance of", this.resourceReader.findSpecificType(res, CRM.E7_Activity).getLocalName());
        if (res.getURI().startsWith("http://parthenos.d4science.org")) {
            this.addExtra(jg, "Parthenos URL", res.getURI());
        } else {
            this.addExtra(jg, "URL", res.getURI());
        }
        this.addIdentifiers(res, jg);
        this.addExtra(jg, "competence", Joiner.on((String)", ").join(this.resourceReader.getCompetences(res)));
        this.addExtra(jg, "activity type", Joiner.on((String)", ").join(this.resourceReader.getActivityTypes(res)));
        this.addExtra(jg, "condition of use", this.resourceReader.getConditionOfUse(res));
        int idx = 1;
        Iterator contacts = Iterators.concat((Iterator)this.resourceReader.getResourceDirectContactPointsURI(res), (Iterator)this.resourceReader.getProviderContactPoints(res));
        while (contacts.hasNext()) {
            this.addExtra(jg, String.format("contact points (%d)", idx), (String)contacts.next());
            ++idx;
        }
        idx = 1;
        Iterator providers = this.resourceReader.getProviderUris(res);
        while (providers.hasNext()) {
            this.addExtra(jg, String.format("provided by (%d)", idx), (String)providers.next());
            ++idx;
        }
        idx = 1;
        Iterator points = this.resourceReader.getAccessPoints(res);
        while (points.hasNext()) {
            this.addExtra(jg, String.format("online access point (%d)", idx), (String)points.next());
            ++idx;
        }
        this.addExtra(jg, "protocol", Joiner.on((String)", ").join(this.resourceReader.getProtocols(res)));
        idx = 1;
        Iterator delivers = this.resourceReader.getDeliversOnRequest(res);
        while (delivers.hasNext()) {
            this.addExtra(jg, String.format("delivers on request (%d)", idx), (String)delivers.next());
            ++idx;
        }
        idx = 1;
        Iterator runs = this.resourceReader.getRunsOnRequest(res);
        while (runs.hasNext()) {
            this.addExtra(jg, String.format("runs on request (%d)", idx), (String)runs.next());
            ++idx;
        }
        idx = 1;
        Iterator hosts = this.resourceReader.getHostedStuff(res);
        while (hosts.hasNext()) {
            this.addExtra(jg, String.format("hosts (%d)", idx), (String)hosts.next());
            ++idx;
        }
        idx = 1;
        Iterator curates = this.resourceReader.getCuratedObjects(res);
        while (curates.hasNext()) {
            this.addExtra(jg, String.format("curates (%d)", idx), (String)curates.next());
            ++idx;
        }
        this.addExtra(jg, "declared begin/end of operation", Joiner.on((String)", ").join(this.resourceReader.getDeclarativeTimes(res)));
        this.addExtra(jg, "availability", this.resourceReader.getAvailability(res));
        idx = 1;
        Iterator plans = this.resourceReader.getCurationPlans(res);
        while (plans.hasNext()) {
            this.addExtra(jg, String.format("uses curation plan (%d)", idx), (String)plans.next());
            ++idx;
        }
        this.addExtra(jg, "time of service", Joiner.on((String)", ").join(this.resourceReader.getDeclarativeTimes(res)));
        jg.writeEndArray();
        jg.writeEndObject();
        jg.close();
        return out.toString("UTF-8");
    }

    protected String getJsonForActor(Resource res, String resNameForCatalogue, String datasourceName) throws IOException, ParthenosPublisherException {
        JsonFactory jsonFactory = new JsonFactory();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(out);
        JsonGenerator jg = jsonFactory.createGenerator((OutputStream)bos, JsonEncoding.UTF8);
        jg.writeStartObject();
        this.writeCommonFields(jg, res, resNameForCatalogue, datasourceName);
        jg.writeArrayFieldStart("extras");
        this.addExtra(jg, "system:type", CKANUtils.Actor_type);
        this.addExtra(jg, "instance of", this.resourceReader.findSpecificType(res, CRM.E39_Actor).getLocalName());
        if (res.getURI().startsWith("http://parthenos.d4science.org")) {
            this.addExtra(jg, "Parthenos URL", res.getURI());
        } else {
            this.addExtra(jg, "URL", res.getURI());
        }
        this.addIdentifiers(res, jg);
        this.addExtra(jg, "has type", Joiner.on((String)", ").join(this.resourceReader.getHasTypeLabels(res)));
        int idx = 1;
        Iterator hasMembers = this.resourceReader.getMemberUrls(res);
        while (hasMembers.hasNext()) {
            this.addExtra(jg, String.format("has member (%d)", idx), (String)hasMembers.next());
            ++idx;
        }
        idx = 1;
        Iterator isMembers = this.resourceReader.isMemberOf(res);
        while (isMembers.hasNext()) {
            this.addExtra(jg, String.format("is member of (%d)", idx), (String)isMembers.next());
            ++idx;
        }
        idx = 1;
        Iterator provides = this.resourceReader.getProvidedServiceUrls(res);
        while (provides.hasNext()) {
            this.addExtra(jg, String.format("provides (%d)", idx), (String)provides.next());
            ++idx;
        }
        idx = 1;
        String contactPoints = "";
        StmtIterator it = res.listProperties(CRM.P76_has_contact_point);
        while (it.hasNext()) {
            Resource cp = ((Statement)it.next()).getResource();
            Resource cpType = cp.getPropertyResourceValue(CRM.P2_has_type);
            String cpTypeLabel = this.resourceReader.getLabel(cpType);
            String cpLabel = this.resourceReader.getLabel(cp);
            if (StringUtils.isNotBlank((CharSequence)cpLabel)) {
                if (StringUtils.isNotBlank((CharSequence)cpTypeLabel)) {
                    this.addExtra(jg, String.format("contact point (%d) - %s ", idx, cpTypeLabel), cpLabel);
                    ++idx;
                    continue;
                }
                this.addExtra(jg, String.format("contact point (%d)", idx), cpLabel);
                ++idx;
                continue;
            }
            this.addExtra(jg, String.format("contact point (%d)", idx), cp.getURI());
            ++idx;
        }
        idx = 1;
        Iterator maintains = this.resourceReader.getMaintainedUrls(res);
        while (maintains.hasNext()) {
            this.addExtra(jg, String.format("maintains (%d)", idx), (String)maintains.next());
            ++idx;
        }
        jg.writeEndArray();
        jg.writeEndObject();
        jg.close();
        return out.toString("UTF-8");
    }

    protected String getJsonForDataset(Resource res, String resNameForCatalogue, String datasourceName) throws IOException, ParthenosPublisherException {
        JsonFactory jsonFactory = new JsonFactory();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(out);
        JsonGenerator jg = jsonFactory.createGenerator((OutputStream)bos, JsonEncoding.UTF8);
        jg.writeStartObject();
        this.writeCommonFields(jg, res, resNameForCatalogue, datasourceName);
        jg.writeArrayFieldStart("extras");
        this.addExtra(jg, "system:type", CKANUtils.Dataset_type);
        this.addExtra(jg, "instance of", this.resourceReader.findSpecificType(res, CRM.E70_Thing).getLocalName());
        if (res.getURI().startsWith("http://parthenos.d4science.org")) {
            this.addExtra(jg, "Parthenos URL", res.getURI());
        } else {
            this.addExtra(jg, "URL", res.getURI());
        }
        this.addIdentifiers(res, jg);
        this.addExtra(jg, "has type", Joiner.on((String)", ").join(this.resourceReader.getHasTypeLabels(res)));
        int idx = 1;
        Iterator isPartOf = this.resourceReader.getIsPartOfUrls(res);
        while (isPartOf.hasNext()) {
            this.addExtra(jg, String.format("is part of (%d)", idx), (String)isPartOf.next());
            ++idx;
        }
        idx = 1;
        Iterator hasPart = this.resourceReader.getHasPartUrls(res);
        while (hasPart.hasNext()) {
            this.addExtra(jg, String.format("has part (%d)", idx), (String)hasPart.next());
            ++idx;
        }
        idx = 1;
        Iterator curators = this.resourceReader.getCuratorUrls(res);
        while (curators.hasNext()) {
            this.addExtra(jg, String.format("curated by (%d)", idx), (String)curators.next());
            ++idx;
        }
        idx = 1;
        Iterator curationplans = this.resourceReader.getResourceCuratorCurationPlans(res);
        while (curationplans.hasNext()) {
            this.addExtra(jg, String.format("curation plan (%d)", idx), (String)curationplans.next());
            ++idx;
        }
        idx = 1;
        Iterator hostedbys = this.resourceReader.getHostedBys(res);
        while (hostedbys.hasNext()) {
            this.addExtra(jg, String.format("hosted by (%d)", idx), (String)hostedbys.next());
            ++idx;
        }
        this.addExtra(jg, "encoding type", Joiner.on((String)", ").join(this.resourceReader.getEncodings(res)));
        idx = 1;
        Iterator creators = this.resourceReader.getCreatorsURIs(res);
        while (creators.hasNext()) {
            this.addExtra(jg, String.format("creator (%d)", idx), (String)creators.next());
            ++idx;
        }
        idx = 1;
        Iterator sw = this.resourceReader.getUsedSoftware(res);
        while (sw.hasNext()) {
            this.addExtra(jg, String.format("used software (%d)", idx), (String)sw.next());
            ++idx;
        }
        this.addExtra(jg, "subject", Joiner.on((String)", ").join(this.resourceReader.getSubjects(res)));
        this.addExtra(jg, "temporal coverage", Joiner.on((String)", ").join((Iterable)this.resourceReader.getTemporalCoverages(res)));
        this.addExtra(jg, "spatial coverage", Joiner.on((String)", ").join((Iterable)this.resourceReader.getSpatialCoverages(res)));
        idx = 1;
        Iterator usedbys = this.resourceReader.getUsedBy(res);
        while (usedbys.hasNext()) {
            this.addExtra(jg, String.format("used by (%d)", idx), (String)usedbys.next());
            ++idx;
        }
        this.addExtra(jg, "languages", Joiner.on((String)", ").join(this.resourceReader.getLanguages(res)));
        idx = 1;
        Iterator metadata = this.resourceReader.getMetadata(res);
        while (metadata.hasNext()) {
            this.addExtra(jg, String.format("has metadata (%d)", idx), (String)metadata.next());
            ++idx;
        }
        idx = 1;
        Iterator metadataFor = this.resourceReader.getDescribedDataset(res);
        while (metadataFor.hasNext()) {
            this.addExtra(jg, String.format("is metadata for (%d)", idx), (String)metadataFor.next());
            ++idx;
        }
        idx = 1;
        Iterator snaphsots = this.resourceReader.getSnapshots(res);
        while (snaphsots.hasNext()) {
            this.addExtra(jg, String.format("has snapshot (%d)", idx), (String)snaphsots.next());
            ++idx;
        }
        idx = 1;
        Iterator issnaphsots = this.resourceReader.getIsSnapshotOfs(res);
        while (issnaphsots.hasNext()) {
            this.addExtra(jg, String.format("is snapshot of (%d)", idx), (String)issnaphsots.next());
            ++idx;
        }
        jg.writeEndArray();
        jg.writeEndObject();
        jg.close();
        return out.toString("UTF-8");
    }

    protected String getJsonForSoftware(Resource res, String resNameForCatalogue, String datasourceName) throws IOException, ParthenosPublisherException {
        JsonFactory jsonFactory = new JsonFactory();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(out);
        JsonGenerator jg = jsonFactory.createGenerator((OutputStream)bos, JsonEncoding.UTF8);
        jg.writeStartObject();
        this.writeCommonFields(jg, res, resNameForCatalogue, datasourceName);
        jg.writeArrayFieldStart("extras");
        this.addExtra(jg, "system:type", CKANUtils.Software_type);
        this.addExtra(jg, "instance of", this.resourceReader.findSpecificType(res, CRM.E70_Thing).getLocalName());
        if (res.getURI().startsWith("http://parthenos.d4science.org")) {
            this.addExtra(jg, "Parthenos URL", res.getURI());
        } else {
            this.addExtra(jg, "URL", res.getURI());
        }
        this.addIdentifiers(res, jg);
        this.addExtra(jg, "subject", Joiner.on((String)", ").join(this.resourceReader.getSubjects(res)));
        this.addExtra(jg, "has type", Joiner.on((String)", ").join(this.resourceReader.getHasTypeLabels(res)));
        int idx = 1;
        Iterator hosted = this.resourceReader.getHostedBys(res);
        while (hosted.hasNext()) {
            this.addExtra(jg, String.format("hosted by (%d)", idx), (String)hosted.next());
            ++idx;
        }
        idx = 1;
        Iterator curated = this.resourceReader.getCuratorUrls(res);
        while (curated.hasNext()) {
            this.addExtra(jg, String.format("curated by (%d)", idx), (String)curated.next());
            ++idx;
        }
        idx = 1;
        Iterator hasSnapshot = this.resourceReader.getSnapshots(res);
        while (hasSnapshot.hasNext()) {
            this.addExtra(jg, String.format("has snapshot (%d)", idx), (String)hasSnapshot.next());
            ++idx;
        }
        idx = 1;
        Iterator isSnapshot = this.resourceReader.getIsSnapshotOfs(res);
        while (isSnapshot.hasNext()) {
            this.addExtra(jg, String.format("is snapshot (%d)", idx), (String)isSnapshot.next());
            ++idx;
        }
        idx = 1;
        Iterator isPart = this.resourceReader.getIsPartOfUrls(res);
        while (isPart.hasNext()) {
            this.addExtra(jg, String.format("is part of (%d)", idx), (String)isPart.next());
            ++idx;
        }
        idx = 1;
        Iterator hasPart = this.resourceReader.getHasPartUrls(res);
        while (hasPart.hasNext()) {
            this.addExtra(jg, String.format("has part (%d)", idx), (String)hasPart.next());
            ++idx;
        }
        idx = 1;
        Iterator hasRelease = this.resourceReader.getHasReleases(res);
        while (hasRelease.hasNext()) {
            this.addExtra(jg, String.format("has release (%d)", idx), (String)hasRelease.next());
            ++idx;
        }
        idx = 1;
        Iterator isRelease = this.resourceReader.getIsReleaseOfs(res);
        while (isRelease.hasNext()) {
            this.addExtra(jg, String.format("is release (%d)", idx), (String)isRelease.next());
            ++idx;
        }
        idx = 1;
        Iterator used = this.resourceReader.getUsedBy(res);
        while (used.hasNext()) {
            this.addExtra(jg, String.format("used by (%d)", idx), (String)used.next());
            ++idx;
        }
        this.addExtra(jg, "creation time", this.resourceReader.getFirstCreationTime(res));
        jg.writeEndArray();
        jg.writeEndObject();
        jg.close();
        return out.toString("UTF-8");
    }

    protected String getJsonForCollection(Resource res, String resNameForCatalogue, String datasourceName) throws IOException, ParthenosPublisherException {
        JsonFactory jsonFactory = new JsonFactory();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(out);
        JsonGenerator jg = jsonFactory.createGenerator((OutputStream)bos, JsonEncoding.UTF8);
        jg.writeStartObject();
        this.writeCommonFields(jg, res, resNameForCatalogue, datasourceName);
        jg.writeArrayFieldStart("extras");
        this.addExtra(jg, "system:type", CKANUtils.Collection_type);
        this.addExtra(jg, "instance of", this.resourceReader.findSpecificType(res, CRM.E70_Thing).getLocalName());
        if (res.getURI().startsWith("http://parthenos.d4science.org")) {
            this.addExtra(jg, "Parthenos URL", res.getURI());
        } else {
            this.addExtra(jg, "URL", res.getURI());
        }
        this.addIdentifiers(res, jg);
        this.addExtra(jg, "has type", Joiner.on((String)", ").join(this.resourceReader.getHasTypeLabels(res)));
        this.addExtra(jg, "subject", Joiner.on((String)", ").join(this.resourceReader.getSubjects(res)));
        this.addExtra(jg, "temporal coverage", Joiner.on((String)", ").join((Iterable)this.resourceReader.getTemporalCoverages(res)));
        this.addExtra(jg, "spatial coverage", Joiner.on((String)", ").join((Iterable)this.resourceReader.getSpatialCoverages(res)));
        int idx = 1;
        Iterator hasPart = this.resourceReader.getHasPartUrls(res);
        while (hasPart.hasNext()) {
            this.addExtra(jg, String.format("has part (%d)", idx), (String)hasPart.next());
            ++idx;
        }
        idx = 1;
        Iterator hosted = this.resourceReader.getHostedBys(res);
        while (hosted.hasNext()) {
            this.addExtra(jg, String.format("hosted by (%d)", idx), (String)hosted.next());
            ++idx;
        }
        idx = 1;
        Iterator curated = this.resourceReader.getCuratorUrls(res);
        while (curated.hasNext()) {
            this.addExtra(jg, String.format("curated by (%d)", idx), (String)curated.next());
            ++idx;
        }
        idx = 1;
        Iterator creators = this.resourceReader.getCreatorsURIs(res);
        while (creators.hasNext()) {
            this.addExtra(jg, String.format("creator (%d)", idx), (String)creators.next());
            ++idx;
        }
        this.addExtra(jg, "languages", Joiner.on((String)", ").join(this.resourceReader.getLanguages(res)));
        jg.writeEndArray();
        jg.writeEndObject();
        jg.close();
        return out.toString("UTF-8");
    }

    protected String getJsonForDesignProcedure(Resource res, String resNameForCatalogue, String datasourceName) throws IOException, ParthenosPublisherException {
        JsonFactory jsonFactory = new JsonFactory();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(out);
        JsonGenerator jg = jsonFactory.createGenerator((OutputStream)bos, JsonEncoding.UTF8);
        jg.writeStartObject();
        this.writeCommonFields(jg, res, resNameForCatalogue, datasourceName);
        jg.writeArrayFieldStart("extras");
        this.addExtra(jg, "system:type", CKANUtils.DesignOrProcedure_type);
        this.addExtra(jg, "instance of", this.resourceReader.findSpecificType(res, CRM.E29_Design_or_Procedure).getLocalName());
        if (res.getURI().startsWith("http://parthenos.d4science.org")) {
            this.addExtra(jg, "Parthenos URL", res.getURI());
        } else {
            this.addExtra(jg, "URL", res.getURI());
        }
        this.addIdentifiers(res, jg);
        int idx = 1;
        Iterator used = this.resourceReader.getUsedBy(res);
        while (used.hasNext()) {
            this.addExtra(jg, String.format("used by (%d)", idx), (String)used.next());
            ++idx;
        }
        jg.writeEndArray();
        jg.writeEndObject();
        jg.close();
        return out.toString("UTF-8");
    }

    protected void addIdentifiers(Resource res, JsonGenerator jg) throws IOException {
        StmtIterator it = res.listProperties(CRM.P1_is_identified_by);
        HashSet ids = Sets.newHashSet();
        while (it.hasNext()) {
            RDFNode obj = ((Statement)it.next()).getObject();
            if (obj.isLiteral()) {
                ids.add(obj.asLiteral().getLexicalForm());
                continue;
            }
            Resource id = (Resource)obj;
            if (!id.hasProperty(RDF.type, (RDFNode)CRM.E42_Identifier)) continue;
            ids.add(this.resourceReader.getLabel(id));
        }
        this.addExtra(jg, "ID", String.join((CharSequence)",", ids));
    }

    protected void addExtra(JsonGenerator jg, String key, String value) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            jg.writeStartObject();
            jg.writeStringField("key", key);
            jg.writeStringField("value", value);
            jg.writeEndObject();
        }
    }

    protected void writeCommonFields(JsonGenerator jg, Resource res, String resNameForCatalogue, String datasourceName) throws IOException, ParthenosPublisherException {
        String ckanOrg = CKANUtils.getCKanOrg((String)datasourceName);
        if (StringUtils.isBlank((CharSequence)ckanOrg)) {
            throw new ParthenosPublisherException(String.format("Cannot register %s : blank ckan org for data source with name %s", resNameForCatalogue, datasourceName));
        }
        jg.writeStringField("owner_org", ckanOrg);
        jg.writeStringField("name", resNameForCatalogue);
        jg.writeStringField("license_id", this.resourceReader.getCatalogueLicense(res).getId());
        String title = this.resourceReader.getTitle(res);
        if (StringUtils.isBlank((CharSequence)title)) {
            title = resNameForCatalogue;
        }
        jg.writeStringField("title", title);
        jg.writeStringField("notes", Joiner.on((char)';').join(this.resourceReader.getDescriptions(res)));
        jg.writeArrayFieldStart("tags");
        Iterator classNames = this.resourceReader.getRDFClassNames(res);
        while (classNames.hasNext()) {
            jg.writeStartObject();
            jg.writeStringField("name", (String)classNames.next());
            jg.writeEndObject();
        }
        jg.writeEndArray();
    }

    public ResourceReader getResourceReader() {
        return this.resourceReader;
    }

    public void setResourceReader(ResourceReader resourceReader) {
        this.resourceReader = resourceReader;
    }

    public CatalogueAPIClient getCatalogueAPIClient() {
        return this.catalogueAPIClient;
    }

    public void setCatalogueAPIClient(CatalogueAPIClient catalogueAPIClient) {
        this.catalogueAPIClient = catalogueAPIClient;
    }
}

