/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.parthenos.catalogue;

import com.google.common.collect.Lists;
import eu.dnetlib.parthenos.catalogue.CatalogueAPIResponse;
import eu.dnetlib.parthenos.jrr.ParthenosRegistryResource;
import eu.dnetlib.parthenos.publisher.ParthenosPublisherException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URIBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class CatalogueAPIClient {
    private static final Log log = LogFactory.getLog(CatalogueAPIClient.class);
    @Value(value="${gcube.catalogue.baseurl}")
    private String baseURL;
    @Value(value="${gcube.registry.application.token}")
    private String applicationToken;
    @Value(value="${gcube.uri.resolver}")
    private String uri_resolver;
    private String resolverBodyTemplate = "{ \"entity_name\": \"%s\" }";
    private final String createItemPath = "rest/api/items/create";
    private final String showItemPath = "rest/api/items/show";
    private final String purgeItemPath = "rest/api/items/purge";
    private String purgeBodyTemplate = "{\"id\":\"%s\"}";
    @Autowired
    private RestTemplate jrrRestTemplate;

    public String getNameForCatalogue(String resName) throws URISyntaxException {
        log.debug((Object)String.format("Calling Parthenos resolver for " + resName, new Object[0]));
        String body = String.format(this.resolverBodyTemplate, resName);
        HttpEntity entity = new HttpEntity((Object)body, (MultiValueMap)this.getHeaders());
        URI uri = new URIBuilder(this.getUri_resolver()).build();
        ResponseEntity res = this.jrrRestTemplate.exchange(uri, HttpMethod.GET, entity, String.class);
        if (res.getStatusCode().is2xxSuccessful()) {
            String resolved = (String)res.getBody();
            log.debug((Object)String.format("Parthenos resolver resolved %s with %s", resName, resolved));
            return resolved;
        }
        log.debug((Object)String.format("Parthenos resolver returned %s with cause %s for %s", res.getStatusCodeValue(), res.getStatusCode().getReasonPhrase(), resName));
        return null;
    }

    public ParthenosRegistryResource getRegistered(String resCatName) throws ParthenosPublisherException {
        log.debug((Object)String.format("Catalogue --> Checking if item %s exists", resCatName));
        HttpEntity entity = new HttpEntity((MultiValueMap)this.getHeaders());
        try {
            URI uri = new URIBuilder(this.getBaseURL() + "rest/api/items/show").addParameter("gcube-token", this.getApplicationToken()).addParameter("id", resCatName).build();
            ResponseEntity res = this.jrrRestTemplate.exchange(uri, HttpMethod.GET, entity, String.class);
            CatalogueAPIResponse response = new CatalogueAPIResponse();
            response.setResponseBody((String)res.getBody());
            if (response.isSuccess()) {
                ParthenosRegistryResource r = response.getParthenosRegistryResource();
                log.debug((Object)String.format("Resource %s is in the catalogue with uuid %s", resCatName, r.getUuid()));
                return r;
            }
            log.debug((Object)String.format("Resource %s is not in the catalogue yet", resCatName));
            return null;
        }
        catch (Throwable t) {
            throw new ParthenosPublisherException(t);
        }
    }

    public String doRegister(String json, String resCatName) throws URISyntaxException, IOException {
        log.debug((Object)String.format("Catalogue --> Registering item %s : %s", resCatName, json));
        HttpEntity entity = new HttpEntity((Object)json, (MultiValueMap)this.getHeaders());
        URI uri = new URIBuilder(this.getBaseURL() + "rest/api/items/create").addParameter("gcube-token", this.getApplicationToken()).build();
        ResponseEntity res = this.jrrRestTemplate.exchange(uri, HttpMethod.POST, entity, String.class);
        CatalogueAPIResponse response = new CatalogueAPIResponse();
        if (res.getStatusCode() == HttpStatus.OK) {
            String body = (String)res.getBody();
            response.setResponseBody(body);
            if (response.isSuccess()) {
                return response.getParthenosRegistryResource().getUuid();
            }
            log.warn((Object)(resCatName + " could not be registered because of " + response.getErrorMessage()));
            return null;
        }
        log.warn((Object)(resCatName + " POST FAILED: " + res.getStatusCodeValue()));
        return null;
    }

    protected boolean purgeItem(String resCatName) throws URISyntaxException, IOException {
        log.debug((Object)String.format("Catalogue --> Purge Item %s", resCatName));
        return this.purge("rest/api/items/purge", resCatName);
    }

    private boolean purge(String purgePath, String id) throws URISyntaxException, IOException {
        String body = String.format(this.purgeBodyTemplate, id);
        log.warn((Object)("DEL BODY: " + body));
        HttpEntity entity = new HttpEntity((Object)body, (MultiValueMap)this.getHeaders());
        URI uri = new URIBuilder(this.getBaseURL() + purgePath).addParameter("gcube-token", this.getApplicationToken()).build();
        ResponseEntity res = this.jrrRestTemplate.exchange(uri, HttpMethod.DELETE, entity, String.class);
        CatalogueAPIResponse response = new CatalogueAPIResponse();
        if (res.getStatusCode() == HttpStatus.OK) {
            String resBody = (String)res.getBody();
            response.setResponseBody(resBody);
            return response.isSuccess();
        }
        log.error((Object)res.getStatusCodeValue());
        return false;
    }

    private HttpHeaders getHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept((List)Lists.newArrayList((Object[])new MediaType[]{MediaType.APPLICATION_JSON}));
        return headers;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public String getApplicationToken() {
        return this.applicationToken;
    }

    public void setApplicationToken(String applicationToken) {
        this.applicationToken = applicationToken;
    }

    public String getCreateItemPath() {
        return "rest/api/items/create";
    }

    public String getShowItemPath() {
        return "rest/api/items/show";
    }

    public RestTemplate getJrrRestTemplate() {
        return this.jrrRestTemplate;
    }

    public void setJrrRestTemplate(RestTemplate jrrRestTemplate) {
        this.jrrRestTemplate = jrrRestTemplate;
    }

    public String getUri_resolver() {
        return this.uri_resolver;
    }

    public void setUri_resolver(String uri_resolver) {
        this.uri_resolver = uri_resolver;
    }

    public String getPurgeItemPath() {
        return "rest/api/items/purge";
    }

    public String getPurgeBodyTemplate() {
        return this.purgeBodyTemplate;
    }

    public void setPurgeBodyTemplate(String purgeBodyTemplate) {
        this.purgeBodyTemplate = purgeBodyTemplate;
    }
}

