package eu.dnetlib.parthenos.registry;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import org.springframework.stereotype.Component;

/**
 * Created by Alessia Bardi on 02/10/2017.
 *
 * @author Alessia Bardi
 */
@Component
public class RelWriter {

	protected String writeRelationship(final JsonFactory jsonFactory, final String relType, final String sourceUUID, final String sourceType, final String targetUUID, final String targetType)
			throws IOException {
		final ByteArrayOutputStream out = new ByteArrayOutputStream();
		BufferedOutputStream bos = new BufferedOutputStream(out);
		JsonGenerator jg = jsonFactory.createGenerator(bos, JsonEncoding.UTF8);
		jg.writeStartObject();
		jg.writeStringField("@class", relType);
		jg.writeObjectFieldStart("source");
		jg.writeObjectFieldStart("header");
		jg.writeStringField("uuid", sourceUUID);
		jg.writeEndObject();
		jg.writeStringField("@class", sourceType);
		jg.writeEndObject();
		jg.writeObjectFieldStart("target");
		jg.writeObjectFieldStart("header");
		jg.writeStringField("uuid", targetUUID);
		jg.writeEndObject();
		jg.writeStringField("@class", targetType);
		jg.writeEndObject();
		jg.close();
		return out.toString("UTF-8");
	}
}
