package eu.dnetlib.parthenos;

import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;

/**
 * Vocabulary definitions from http://www.ics.forth.gr/isl/CRMext/CRMdig_v3.2.1.rdfs
 *
 * @author Auto-generated by schemagen on 29 Sep 2017 15:54
 */
public class CRMdig {

	/**
	 * <p>The RDF model that holds the vocabulary terms</p>
	 */
	private static final Model M_MODEL = ModelFactory.createDefaultModel();

	/**
	 * <p>The namespace of the vocabulary as a string</p>
	 */
	public static final String NS = "http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/";

	/**
	 * <p>The URL to the online schema as a string</p>
	 */
	public static final String RDFS_URL = "http://www.ics.forth.gr/isl/CRMext/CRMdig_v3.2.2.rdfs";

	/**
	 * <p>The namespace of the vocabulary as a string</p>
	 *
	 * @return namespace as String
	 * @see #NS
	 */
	public static String getURI() {
		return NS;
	}

	/**
	 * <p>The namespace of the vocabulary as a resource</p>
	 */
	public static final Resource NAMESPACE = M_MODEL.createResource(NS);

	/**
	 * <p>This property associates an instance of D7 Digital Machine Event with an instance
	 * of D1 Digital Object which is the input used to specify the machine action.
	 * This property is a specialisation of P16 used specific object(was used for).</p>
	 */
	public static final Property L10_had_input = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L10_had_input");

	public static final Property L10i_was_input_of = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L10i_was_input_of");

	/**
	 * <p>This property associates an instance of D7 Digital Machine Event with an instance
	 * of D1 Digital Object which is the output of the activity. This property is
	 * a specialisation of P94 has created (was created by).</p>
	 */
	public static final Property L11_had_output = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L11_had_output");

	public static final Property L11i_was_output_of = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L11i_was_output_of");

	/**
	 * <p>This property associates an instance of D7 Digital Machine Event with an object,
	 * the D8 Digital Device, which happened with, e.g a capturing event that happened
	 * on/with a digital camera, etc. This property is a specialisation of P12 occurred
	 * in the presence of (was present at).</p>
	 */
	public static final Property L12_happened_on_device = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L12_happened_on_device");

	public static final Property L12i_was_device_for = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L12i_was_device_for");

	/**
	 * <p>This property associates an instance of D10 Software Execution with a digital
	 * object used as a parameter during the process.This property is a specialisation
	 * of L1O had input (was input of).</p>
	 */
	public static final Property L13_used_parameters = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L13_used_parameters");

	public static final Property L13i_parameters_for = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L13i_parameters_for");

	/**
	 * <p>This property identifies a digital object transferred by a D12 Data Transfer
	 * Event. This property is a specialisation of L11 had output (was output of).</p>
	 */
	public static final Property L14_transferred = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L14_transferred");

	public static final Property L14i_was_transferred_by = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L14i_was_transferred_by");

	/**
	 * <p>This property identifies a digital device used as a medium on which data are
	 * transferred through a D12 Data Transfer Event.</p>
	 */
	public static final Property L15_has_sender = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L15_has_sender");

	public static final Property L15i_was_sender_for = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L15i_was_sender_for");

	/**
	 * <p>This property identifies a digital device used as a medium to receive data
	 * through a D12 Data Transfer Event.</p>
	 */
	public static final Property L16_has_receiver = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L16_has_receiver");

	public static final Property L16i_was_receiver_for = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L16i_was_receiver_for");

	/**
	 * <p>This property associates an instance of D11 Digital Measurement Event with
	 * the instance of E55 Type of object to which it applied. This property is a
	 * specialisation of P125 used object of type.</p>
	 */
	public static final Property L17_measured_thing_of_type = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L17_measured_thing_of_type");

	public static final Property L17i_was_type_of_thing_measured_by =
			M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L17i_was_type_of_thing_measured_by");

	/**
	 * <p>This property identifies a Digital Information Carrier modified in a Digital
	 * Machine Event. This property is a specialisation of P31 has modified.</p>
	 */
	public static final Property L18_has_modified = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L18_has_modified");

	public static final Property L18i_was_modified_by = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L18i_was_modified_by");

	/**
	 * <p>This property associates an instance of a D13 Digital Information Carrier
	 * with the instance of Digital Object that is stored on it. This property is
	 * a specialisation of P128 carries.</p>
	 */
	public static final Property L19_stores = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L19_stores");

	public static final Property L19i_is_stored_on = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L19i_is_stored_on");

	/**
	 * <p>This property associates an instance of D2 Digitization Process with an instance
	 * of E18 Physical Thing which is a material thing. This property is a specialisation
	 * of P39 measured (was measured by).</p>
	 */
	public static final Property L1_digitized = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L1_digitized");

	public static final Property L1i_was_digitized_by = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L1i_was_digitized_by");

	/**
	 * <p>This property identifies a Data Object that came into existence as a result
	 * of a D11 Digital Measurement Event. This property is a specialisation of P40
	 * observed dimension and L11 had output.</p>
	 */
	public static final Property L20_has_created = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L20_has_created");

	public static final Property L20i_was_created_by = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L20i_was_created_by");

	/**
	 * <p>This property associates an instance of a D3 Formal Derivation with the instance
	 * of D1 Digital Object that is used as a derivation source.</p>
	 */
	public static final Property L21_used_as_derivation_source = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L21_used_as_derivation_source");

	public static final Property L21i_was_derivation_source_for = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L21i_was_derivation_source_for");

	/**
	 * <p>This property associates an instance of D3 Formal Derivation with the Digital
	 * Object it used to create a version of. This property is a specialisation of
	 * L11 had output.</p>
	 */
	public static final Property L22_created_derivative = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L22_created_derivative");

	public static final Property L22i_was_derivative_created_by = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L22i_was_derivative_created_by");

	/**
	 * <p>This property associates an instance of D7 Digital Machine Event with the
	 * instance of D14 Software that had used. This property is a specialisation
	 * of P16 used specific object.</p>
	 */
	public static final Property L23_used_software_or_firmware = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L23_used_software_or_firmware");

	public static final Property L23i_was_software_or_firmware_used_by =
			M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L23i_was_software_or_firmware_used_by");

	/**
	 * <p>This property identifies the logfile that was created by a D10 Software Execution
	 * in order to record all the activities in the system.</p>
	 */
	public static final Property L24_created_logfile = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L24_created_logfile");

	public static final Property L24i_was_logfile_created_by = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L24i_was_logfile_created_by");

	/**
	 * <p>This property describes the participation of a Legal Body in being responsible
	 * for the outcome of a specific activity. This property is a specialisation
	 * of P14 carried out by.</p>
	 */
	public static final Property L29_has_responsible_organization =
			M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L29_has_responsible_organization");

	public static final Property L29i_is_responsible_organization_for =
			M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L29i_is_responsible_organization_for");

	/**
	 * <p>This property associates an instance of D10 Software Execution with an instance
	 * of D1 Digital Object which is used as a source, a software essential for the
	 * performance. This property is a specialisation of L10F had input (was input
	 * of).</p>
	 */
	public static final Property L2_used_as_source = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L2_used_as_source");

	public static final Property L2i_was_source_for = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L2i_was_source_for");

	/**
	 * <p>This property describes the activity that is being operated by a person. This
	 * property is a specialisation of P14 carried out by.</p>
	 */
	public static final Property L30_has_operator = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L30_has_operator");

	public static final Property L30i_is_operator_of = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L30i_is_operator_of");

	/**
	 * <p>This property allows the starting point for a D7 Digital Machine Event to
	 * be situated. This property expresses the approximation of the starting date
	 * of a time span.</p>
	 */
	public static final Property L31_has_starting_date_time = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L31_has_starting_date-time");

	/**
	 * <p>This property allows the ending point for a D7 Digital Machine Event to be
	 * situated. This property expresses the approximation of the ending date of
	 * a time span.</p>
	 */
	public static final Property L32_has_ending_date_time = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L32_has_ending_date-time");

	/**
	 * <p>This property identifies the maker, the actor who is responsible for the production
	 * of a device, a computer, a digital camera, any kind of a machine that has
	 * been produced. This property is a shortcut of a more fully developed path
	 * from CRM E12 Production:P108 has produced:E24 Physical Man-Made Thing. In
	 * this case, there is no need to describe the more detailed property through
	 * a production event,so L33 has maker is reccomended to be used instead.</p>
	 */
	public static final Property L33_has_maker = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L33_has_maker");

	public static final Property L33i_is_maker_of = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L33i_is_maker_of");

	/**
	 * <p>This property describes the participation of a Legal Body in being contractor
	 * for the outcome of a specific activity. This property is a specialisation
	 * of L29_has_responsible_organization.</p>
	 */
	public static final Property L34_has_contractor = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L34_has_contractor");

	public static final Property L34i_is_contractor_for = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L34i_is_contractor_for");

	/**
	 * <p>This property describes the participation of a Legal Body in being commissioner
	 * for the outcome of a specific activity. This property is a specialisation
	 * of L29_has_responsible_organization.</p>
	 */
	public static final Property L35_has_commissioner = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L35_has_commissioner");

	public static final Property L35i_is_commissioner_for = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L35i_is_commissioner_for");

	/**
	 * <p>This property describes the associations between objects or areas of objects
	 * of the RI, with other objects or regions or persons, places, events..</p>
	 */
	public static final Property L43_annotates = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L43_annotates");

	public static final Property L43i_is_annotated_by = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L43i_is_annotated_by");

	/**
	 * <p>This property is a specialisation of P3 has note and associates a comment
	 * with an instance of an object E1 CRM Entity.</p>
	 */
	public static final Property L47_has_comment = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L47_has_comment");

	/**
	 * <p>This property identifies the D29 Annotation Object (associations) that came
	 * into existence as a result of a D30 Annotation Event. This property is a specialisation
	 * of P94 has created.</p>
	 */
	public static final Property L48_created_annotation = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L48_created_annotation");

	public static final Property L48i_was_annotation_created_by = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L48i_was_annotation_created_by");

	/**
	 * <p>This property describes the association between a particular area declared
	 * in an original digital object. This property is a specialisation of P106 is
	 * composed of.</p>
	 */
	public static final Property L49_is_primary_area_of = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L49_is_primary_area_of");

	public static final Property L49i_has_primary_area = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L49i_has_primary_area");

	/**
	 * <p>This property associates an instance of E1 Entity with an instance of resource
	 * used as a preferred lexical label. This property is a specialisation of rdf
	 * schema label.</p>
	 */
	public static final Property L4_has_preferred_label = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L4_has_preferred_label");

	/**
	 * <p>This property describes the association between an area and the digital object
	 * to which it is propagated. This property is a specialisation of P106 is composed
	 * of.</p>
	 */
	public static final Property L50_is_propagated_area_of = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L50_is_propagated_area_of");

	public static final Property L50i_has_propagated_area = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L50i_has_propagated_area");

	/**
	 * <p>This property defines a personal name used to identify a person.</p>
	 */
	public static final Property L51_has_first_name = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L51_has_first_name");

	/**
	 * <p>This property defines the last name used to identify a person. This property
	 * is a specialisation of L4 has preferred label.</p>
	 */
	public static final Property L52_has_last_name = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L52_has_last_name");

	/**
	 * <p>This property describes a non unique identification applied to E1 CRM Entity.</p>
	 */
	public static final Property L53_is_not_uniquely_identified_by =
			M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L53_is_not_uniquely_identified_by");

	/**
	 * <p>This property describes the association kind of "same as" between objects.
	 * It is used to declare that two or more objects are exactly the same.</p>
	 */
	public static final Property L54_is_same_as = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L54_is_same-as");

	/**
	 * <p>This property describes the association kind of "same as" between objects.
	 * It is used to declare that two or more objects are exactly the same.</p>
	 */
	public static final Property L54i_is_same_as = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L54i_is_same-as");

	/**
	 * <p>This property records the inventory number that was used to identify an instance
	 * of E1 CRM Entity at the time this property was record. This property is a
	 * specialisation of L53F is not uniquely identified by.</p>
	 */
	public static final Property L55_has_inventory_no = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L55_has_inventory_no");

	/**
	 * <p>This property records the pixel width of the data object; it approximates
	 * a dimension that is part of the image data analysis.This property is a specialisation
	 * of P90 has value.</p>
	 */
	public static final Property L56_has_pixel_width = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L56_has_pixel_width");

	/**
	 * <p>This property records the pixel height of the data object; it approximates
	 * a dimension that is part of the image data analysis.This property is a specialisation
	 * of P90 has value.</p>
	 */
	public static final Property L57_has_pixel_height = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L57_has_pixel_height");

	/**
	 * <p>This property records the serial number that was assigned to identify an instance
	 * of E22 Man Made Object. This property is a specialisation of L53 is not uniquely
	 * identified by.</p>
	 */
	public static final Property L59_has_serial_number = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L59_has_serial_number");

	/**
	 * <p>This property describes the CRM Entities documented by instances of Digitization
	 * Processes. This property is a specialisation of P140 assigned attribute to.</p>
	 */
	public static final Property L60_documents = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L60_documents");

	public static final Property L60i_is_documented_by = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L60i_is_documented_by");

	/**
	 * <p>This property describes the minimum period of time covered by a digital machine
	 * event. It identifies the minimum extent of the event. This property is a specialisation
	 * of P81 ongoing throughout.</p>
	 */
	public static final Property L61_was_ongoing_at = M_MODEL.createProperty("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/L61_was_ongoing_at");

	/**
	 * <p>This class comprises events by which a digital device runs a software program
	 * or a series of computing operations on a digital object as a single task,
	 * which is completely determined by its digital input, the software and the
	 * generic properties of the device.</p>
	 */
	public static final Resource D10_Software_Execution = M_MODEL.createResource("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/D10_Software_Execution");

	/**
	 * <p>This class comprises actions measuring physical properties using a digital
	 * device, that are determined by a systematic procedure and creates an instance
	 * of D9 Data Object, which is stored on an instance of D13 Digital Information
	 * Carrier. In contrast to instances of D10 Software Execution, environmental
	 * factors have an intended influence on the outcome of an instance of D11 Digital
	 * Measurement Event. Measurement devices may include running distinct software,
	 * such as the RAW to JPEG conversion in digital cameras. In this case, the event
	 * is regarded as instance of both classes, D10 Software Execution and D11 Digital
	 * Measurement Event.</p>
	 */
	public static final Resource D11_Digital_Measurement_Event = M_MODEL.createResource("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/D11_Digital_Measurement_Event");

	/**
	 * <p>This class comprises events that transfer a digital object from one digital
	 * carrier to another. Normally, the digital object remains the same. If in general
	 * or by observation the transfer implies or has implied some data corruption,
	 * the change of the digital objects may be documented distinguishing input and
	 * output rather than instantiating the property L14 transferred (was transferred
	 * by).</p>
	 */
	public static final Resource D12_Data_Transfer_Event = M_MODEL.createResource("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/D12_Data_Transfer_Event");

	/**
	 * <p>This class comprises all instances of E84 Information Carrier that are explicitly
	 * designed to be used as persistent digital physical carriers of instances of
	 * D1 Digital Object. A D13 Digital Information Carrier may or may not contain
	 * information, e.g., an empty diskette.</p>
	 */
	public static final Resource D13_Digital_Information_Carrier = M_MODEL.createResource("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/D13_Digital_Information_Carrier");

	/**
	 * <p>This class comprises software codes,computer programs,procedures, and functions
	 * that are used to operate a system of digital objects.</p>
	 */
	public static final Resource D14_Software = M_MODEL.createResource("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/D14_Software");

	/**
	 * <p>This class comprises identifiable immaterial items that can be represented
	 * as sets of bit sequences, such as data sets, e-texts, images, audio or video
	 * items, software, etc., and are documented as single units. Any aggregation
	 * of instances of D1 Digital Object into a whole treated as single unit is also
	 * regarded as an instance of D1 Digital Object. This means that for instance,
	 * the content of a DVD, an XML file on it, and an element of this file, are
	 * regarded as distinct instances of D1 Digital Object, mutually related by the
	 * P106 is composed of (forms part of) property. A D1 Digital Object does not
	 * depend on a specific physical carrier, and it can exist on one or more carriers
	 * simultaneously.</p>
	 */
	public static final Resource D1_Digital_Object = M_MODEL.createResource("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/D1_Digital_Object");

	/**
	 * <p>This class comprises the proper noun name that identifies a person that acts
	 * as an entity.</p>
	 */
	public static final Resource D21_Person_Name = M_MODEL.createResource("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/D21_Person_Name");

	/**
	 * <p></p>
	 */
	public static final Resource D23_Room = M_MODEL.createResource("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/D23_Room");

	/**
	 * <p>This class comprises objects that make propositions about other artefacts.
	 * Instances of this class are not the attributes themselves, by which things
	 * are annotated, but represent the connection between the concepts related in
	 * a proposition, and the activities of creation, modification and deletion.</p>
	 */
	public static final Resource D29_Annotation_Object = M_MODEL.createResource("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/D29_Annotation_Object");

	/**
	 * <p>This class comprises events that result in the creation of instances of D9
	 * Data Object that represent the appearance and/or form of an instance of E18
	 * Physical Thing such as paper documents, statues, buildings, paintings, etc.
	 * A particular case is the analogue-to-digital conversion of audiovisual material.
	 * This class represents the transition from a material thing to an immaterial
	 * representation of it. The characteristic subsequent processing steps on digital
	 * objects are regarded as instances of D3 Formal Derivation.</p>
	 */
	public static final Resource D2_Digitization_Process = M_MODEL.createResource("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/D2_Digitization_Process");

	/**
	 * <p>This class comprises events that describe the creation of associations (Annotation
	 * Objects) between objects or areas of objects of the Repository, with other
	 * objects or regions or persons, places, events. It is the event that creates
	 * the Annotation Object.</p>
	 */
	public static final Resource D30_Annotation_Event = M_MODEL.createResource("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/D30_Annotation_Event");

	/**
	 * <p>This class describes a part (of any shape or size) of interest in basically
	 * any media object stored in the Object Repository, i.e., a text, an image,
	 * a video or a 3D model. It points to content consisting of just a portion or
	 * area of a file. In some contexts, however, the area can also point to content
	 * represented by an integral (i.e., proper) file. It is equal to the METS AREA
	 * element</p>
	 */
	public static final Resource D35_Area = M_MODEL.createResource("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/D35_Area");

	/**
	 * <p>This class comprises events that result in the creation of a D1 Digital Object
	 * from another one following a deterministic algorithm, such that the resulting
	 * instance of digital object shares representative properties with the original
	 * object. In other words, this class describes the transition from an immaterial
	 * object referred to by property L21 used as derivation source (was derivation
	 * source for) to another immaterial object referred to by property L22 created
	 * derivative (was derivative created by) preserving the representation of some
	 * things but in a different form. Characteristic examples are colour corrections,
	 * contrast changes and resizing of images.</p>
	 */
	public static final Resource D3_Formal_Derivation = M_MODEL.createResource("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/D3_Formal_Derivation");

	/**
	 * <p>This class comprises events that happen on physical digital devices following
	 * a human activity that intentionally caused its immediate or delayed initiation
	 * and results in the creation of a new instance of D1 Digital Object on behalf
	 * of the human actor. The input of a D7 Digital Machine Event may be parameter
	 * settings and/or data to be processed. Some D7 Digital Machine Events may form
	 * part of a wider E65 Creation event. In this case, all machine output of the
	 * partial events is regarded as creation of the overall activity.</p>
	 */
	public static final Resource D7_Digital_Machine_Event = M_MODEL.createResource("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/D7_Digital_Machine_Event");

	/**
	 * <p>This class comprises identifiable material items such as computers, scanners,
	 * cameras, etc. that have the capability to process or produce instances of
	 * D1 Digital Object.</p>
	 */
	public static final Resource D8_Digital_Device = M_MODEL.createResource("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/D8_Digital_Device");

	/**
	 * <p>This class comprises instances of D1 Digital Object that are the direct result
	 * of a digital measurement or a formal derivative of it, containing quantitative
	 * properties of some physical things or other constellations of matter.</p>
	 */
	public static final Resource D9_Data_Object = M_MODEL.createResource("http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/D9_Data_Object");

}

