/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.parthenos.publisher;

import eu.dnetlib.parthenos.jrr.JRRPublisherHelper;
import eu.dnetlib.parthenos.publisher.ParthenosPublisherException;
import eu.dnetlib.parthenos.publisher.ParthenosPublisherHelper;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ParthenosPublisherController {
    private static final Log log = LogFactory.getLog(ParthenosPublisherController.class);
    @Autowired
    private ParthenosPublisherHelper parthenosPublisherHelper;
    @Autowired
    private JRRPublisherHelper jrrPublisherHelper;

    @RequestMapping(value={"publishJRR"}, method={RequestMethod.POST})
    public int publishJRR(@RequestParam String typeNamespace, @RequestParam String typeName, @RequestParam String datasourceApi, @RequestParam String datasourceName) throws URISyntaxException, TemplateException, IOException, InterruptedException, ParthenosPublisherException {
        return this.jrrPublisherHelper.publish(typeNamespace, typeName, datasourceApi, datasourceName);
    }

    @RequestMapping(value={"/publish"}, method={RequestMethod.POST})
    public void publish(@RequestParam String record, @RequestParam(required=false) String parthenosTarget) throws ParthenosPublisherException {
        this.getParthenosPublisherHelper().publish(record, this.getTarget(parthenosTarget));
    }

    @RequestMapping(value={"/unpublish"}, method={RequestMethod.GET})
    public void unpublish(@RequestParam String datasourceApi, @RequestParam(required=false) String parthenosTarget) throws ParthenosPublisherException {
        this.getParthenosPublisherHelper().unpublish(datasourceApi, this.getTarget(parthenosTarget));
    }

    @RequestMapping(value={"/dropRegistry"}, method={RequestMethod.GET})
    public void unpublish(@RequestParam int bulkSize) throws ParthenosPublisherException {
        this.getParthenosPublisherHelper().dropRegistry(bulkSize);
    }

    private ParthenosPublisherHelper.ParthenosTargets getTarget(String value) {
        return ParthenosPublisherHelper.ParthenosTargets.valueOf((String)value);
    }

    public ParthenosPublisherHelper getParthenosPublisherHelper() {
        return this.parthenosPublisherHelper;
    }

    public void setParthenosPublisherHelper(ParthenosPublisherHelper parthenosPublisherHelper) {
        this.parthenosPublisherHelper = parthenosPublisherHelper;
    }
}

