package eu.dnetlib.parthenos.jrr;

import java.util.List;

import eu.dnetlib.parthenos.virtuoso.VirtuosoReadAPI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Created by Alessia Bardi on 2019-06-26.
 *
 * @author Alessia Bardi
 */
@Component
public class JRRPublisherHelper {

	private static final Log log = LogFactory.getLog(JRRPublisherHelper.class);

	protected final static int LIMIT = 100;
	protected static final String ANY_TIME_QUERY_MS = "1800000"; //1800000 == 3 mins

	@Autowired
	private VirtuosoReadAPI virtuosoReadAPI;
	@Autowired
	private JRRPublisher jrrPublisher;


	public int publish(final String typeNamespace, final String typeName, final String apiId, final String datasourceName) {
		int offset = 0;
		boolean again;
		int countSuccess = 0;
		int countFailed = 0;
		do {
			//get list of subjects of the entityType in the apiURI graph
			List<String> subjects = virtuosoReadAPI.getSubjectsForApiWithType(apiId, typeNamespace, typeName, LIMIT, offset);
			//get the RDF
			for(String subject : subjects) {
				try {
					String fullTypeName = typeNamespace + typeName;
					String record = virtuosoReadAPI.getRDF(subject, fullTypeName, apiId, ANY_TIME_QUERY_MS);
					//request publishing on JRR (need to have the OAI header with the proper subject as objIdentifier
					jrrPublisher.register(record, subject, datasourceName);
					countSuccess++;
				}catch(Throwable t){
					log.warn(String.format("Cannot publish %s with URL %s", typeName, subject));
					log.warn(t.getMessage());
					countFailed++;
				}
			}
			again = subjects.size() == LIMIT;
			offset += LIMIT;
		} while(again);
		log.info(String.format("%s : published %d, failed %d", typeName, countSuccess, countFailed));
		return countSuccess;
	}

	public JRRPublisherHelper(){

	}

	public VirtuosoReadAPI getVirtuosoReadAPI() {
		return virtuosoReadAPI;
	}

	public void setVirtuosoReadAPI(final VirtuosoReadAPI virtuosoReadAPI) {
		this.virtuosoReadAPI = virtuosoReadAPI;
	}

	public JRRPublisher getJrrPublisher() {
		return jrrPublisher;
	}

	public void setJrrPublisher(final JRRPublisher jrrPublisher) {
		this.jrrPublisher = jrrPublisher;
	}
}
