/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.parthenos.jrr;

import eu.dnetlib.parthenos.jrr.JRRPublisher;
import eu.dnetlib.parthenos.virtuoso.VirtuosoReadAPI;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JRRPublisherHelper {
    private static final Log log = LogFactory.getLog(JRRPublisherHelper.class);
    protected static final int LIMIT = 100;
    protected static final String ANY_TIME_QUERY_MS = "1800000";
    @Autowired
    private VirtuosoReadAPI virtuosoReadAPI;
    @Autowired
    private JRRPublisher jrrPublisher;

    public int publish(String typeNamespace, String typeName, String apiId, String datasourceName) {
        boolean again;
        int offset = 0;
        int countSuccess = 0;
        int countFailed = 0;
        do {
            List subjects = this.virtuosoReadAPI.getSubjectsForApiWithType(apiId, typeNamespace, typeName, 100, offset);
            for (String subject : subjects) {
                try {
                    String record = this.virtuosoReadAPI.getRDF(subject, typeName, apiId, ANY_TIME_QUERY_MS);
                    this.jrrPublisher.register(record, subject, datasourceName);
                    ++countSuccess;
                }
                catch (Throwable t) {
                    log.warn((Object)String.format("Cannot publish %s with URL %s", typeName, subject));
                    log.warn((Object)t.getMessage());
                    ++countFailed;
                }
            }
            again = subjects.size() == 100;
            offset += 100;
        } while (again);
        log.info((Object)String.format("%s : published %d, failed %d", typeName, countSuccess, countFailed));
        return countSuccess;
    }

    public VirtuosoReadAPI getVirtuosoReadAPI() {
        return this.virtuosoReadAPI;
    }

    public void setVirtuosoReadAPI(VirtuosoReadAPI virtuosoReadAPI) {
        this.virtuosoReadAPI = virtuosoReadAPI;
    }

    public JRRPublisher getJrrPublisher() {
        return this.jrrPublisher;
    }

    public void setJrrPublisher(JRRPublisher jrrPublisher) {
        this.jrrPublisher = jrrPublisher;
    }
}

