/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.parthenos.catalogue;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.google.common.collect.Lists;
import eu.dnetlib.parthenos.catalogue.CatalogueAPIResponse;
import eu.dnetlib.parthenos.jrr.ParthenosRegistryResource;
import eu.dnetlib.parthenos.publisher.ParthenosPublisherException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URIBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Component
public class CatalogueAPIClient {
    private static final Log log = LogFactory.getLog(CatalogueAPIClient.class);
    @Value(value="${gcube.catalogue.baseurl}")
    private String baseURL;
    private final String itemPath = "items/";
    @Value(value="${gcube.registry.application.token}")
    private String applicationToken;
    @Value(value="${gcube.uri.resolver}")
    private String uriResolver;
    private String resolverBodyTemplate = "{ \"entity_name\": \"%s\" }";
    private String purgeBodyTemplate = "{\"id\":\"%s\"}";
    private HttpHeaders headersForResolver;
    private HttpHeaders headersForCatalogue;
    @Autowired
    private RestTemplate restTemplate;

    @PostConstruct
    public void init() {
        this.headersForResolver = new HttpHeaders();
        this.headersForResolver.setContentType(MediaType.APPLICATION_JSON);
        this.headersForCatalogue = new HttpHeaders();
        this.headersForCatalogue.setContentType(MediaType.APPLICATION_JSON);
        this.headersForCatalogue.setAccept((List)Lists.newArrayList((Object[])new MediaType[]{MediaType.APPLICATION_JSON}));
        this.headersForCatalogue.set("gcube-token", this.getApplicationToken());
    }

    public String getNameForCatalogue(String resName) throws URISyntaxException {
        log.debug((Object)("Calling Parthenos resolver for " + resName));
        String body = String.format(this.resolverBodyTemplate, resName);
        HttpEntity entity = new HttpEntity((Object)body, (MultiValueMap)this.headersForResolver);
        URI uri = new URIBuilder(this.getUriResolver()).build();
        log.debug((Object)("Resolver at " + this.getUriResolver() + " post body: " + body));
        try {
            ResponseEntity res = this.restTemplate.exchange(uri, HttpMethod.POST, entity, String.class);
            if (res.getStatusCode().is2xxSuccessful()) {
                String resolved = (String)res.getBody();
                log.debug((Object)String.format("Parthenos resolver resolved %s with %s", resName, resolved));
                return resolved;
            }
            log.debug((Object)String.format("Parthenos resolver returned %s with cause %s for %s", res.getStatusCodeValue(), res.getStatusCode().getReasonPhrase(), resName));
            return null;
        }
        catch (HttpClientErrorException e) {
            log.debug((Object)String.format("Parthenos resolver returned %s with cause %s for %s", e.getRawStatusCode(), e.getStatusCode().getReasonPhrase(), resName));
            return null;
        }
    }

    public boolean isRegistered(String resCatName) throws ParthenosPublisherException {
        log.debug((Object)String.format("Catalogue --> Checking if item %s exists", resCatName));
        HttpEntity entity = new HttpEntity((MultiValueMap)this.headersForCatalogue);
        try {
            URI uri = new URIBuilder(this.getBaseURL() + "items/" + resCatName).build();
            log.info((Object)uri);
            log.info((Object)this.headersForCatalogue.toString());
            ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.GET, entity, String.class);
            return response.getStatusCode().is2xxSuccessful();
        }
        catch (HttpClientErrorException e) {
            if (e.getRawStatusCode() == 404) {
                return false;
            }
            throw new ParthenosPublisherException((Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new ParthenosPublisherException((Throwable)e);
        }
    }

    @Deprecated
    public ParthenosRegistryResource getRegistered(String resCatName) throws ParthenosPublisherException {
        log.debug((Object)String.format("Catalogue --> Checking if item %s exists", resCatName));
        HttpEntity entity = new HttpEntity((MultiValueMap)this.headersForCatalogue);
        try {
            URI uri = new URIBuilder(this.getBaseURL() + "items/").build();
            ResponseEntity response = this.restTemplate.exchange(uri + resCatName, HttpMethod.GET, entity, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                CatalogueAPIResponse body = new CatalogueAPIResponse();
                body.setResponseBody((String)response.getBody());
                ParthenosRegistryResource r = body.getParthenosRegistryResource();
                log.debug((Object)String.format("Resource %s is in the catalogue with uuid %s", resCatName, r.getUuid()));
                return r;
            }
            log.debug((Object)String.format("Resource %s is not in the catalogue yet", resCatName));
            return null;
        }
        catch (Throwable t) {
            throw new ParthenosPublisherException(t);
        }
    }

    public boolean doRegister(String json, String resCatName) throws URISyntaxException, IOException {
        log.debug((Object)String.format("Catalogue --> Registering item %s : %s", resCatName, json));
        return this.doCatalogueCall(json, resCatName, HttpMethod.POST);
    }

    public boolean doUpdate(String json, String resCatName) throws IOException, URISyntaxException {
        log.debug((Object)String.format("Catalogue --> Updating item %s : %s", resCatName, json));
        return this.doCatalogueCall(json, resCatName, HttpMethod.PUT);
    }

    protected boolean doCatalogueCall(String json, String resCatName, HttpMethod method) throws URISyntaxException, IOException {
        HttpEntity entity = new HttpEntity((Object)json, (MultiValueMap)this.headersForCatalogue);
        URI uri = new URIBuilder(this.getBaseURL() + "items/").build();
        try {
            ResponseEntity res = this.restTemplate.exchange(uri, method, entity, String.class);
            if (res.getStatusCode().is2xxSuccessful()) {
                return true;
            }
            log.error((Object)String.format("Method %s on resource %s failed with code %s, reason: %s", method.name(), resCatName, res.getStatusCodeValue(), res.getBody()));
            return false;
        }
        catch (HttpClientErrorException e) {
            log.error((Object)String.format("Method %s on resource %s failed with code %s, reason: %s", method.name(), resCatName, e.getRawStatusCode(), e.getStatusCode().getReasonPhrase()));
            return false;
        }
    }

    protected boolean purgeItem(String resCatName) throws URISyntaxException, ParthenosPublisherException {
        log.debug((Object)String.format("Catalogue --> Purge Item %s", resCatName));
        HttpEntity entity = new HttpEntity((MultiValueMap)this.headersForCatalogue);
        URI uri = new URIBuilder(this.getBaseURL() + "items/" + resCatName).addParameter("purge", "true").build();
        try {
            ResponseEntity res = this.restTemplate.exchange(uri, HttpMethod.DELETE, entity, String.class);
            if (res.getStatusCode().is2xxSuccessful()) {
                return true;
            }
            log.error((Object)String.format("Cannot purge item %s. HTTP error code %s, reason: %s", resCatName, res.getStatusCodeValue(), res.getStatusCode().getReasonPhrase()));
            return false;
        }
        catch (HttpClientErrorException e) {
            log.error((Object)String.format("Cannot purge item %s. HTTP error code %s, reason: %s", resCatName, e.getRawStatusCode(), e.getStatusCode().getReasonPhrase()));
            return false;
        }
        catch (Throwable t) {
            throw new ParthenosPublisherException(t);
        }
    }

    protected int purgeAll(int bulkSize) throws ParthenosPublisherException {
        log.debug((Object)"Catalogue --> Purge All Item");
        int count = 0;
        try {
            List items = this.list(bulkSize);
            while (items.size() > 0) {
                for (String itemName : items) {
                    this.purgeItem(itemName);
                    ++count;
                    Thread.sleep(50L);
                }
                items = this.list(200);
                Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
            }
        }
        catch (Throwable t) {
            throw new ParthenosPublisherException(t);
        }
        log.debug((Object)String.format("Catalogue --> Purged all %d Items", count));
        return count;
    }

    protected List<String> list(int limit) throws ParthenosPublisherException {
        log.debug((Object)String.format("Getting list of items", new Object[0]));
        ObjectMapper mapper = new ObjectMapper();
        CollectionType listType = mapper.getTypeFactory().constructCollectionType(ArrayList.class, String.class);
        HttpEntity entity = new HttpEntity((MultiValueMap)this.headersForCatalogue);
        try {
            URI uri = new URIBuilder(this.getBaseURL() + "items/").addParameter("limit", String.valueOf(limit)).addParameter("offset", "0").build();
            ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.GET, entity, String.class);
            if (response.getStatusCode().is2xxSuccessful()) {
                String res = (String)response.getBody();
                return (List)mapper.readValue(res, (JavaType)listType);
            }
            throw new ParthenosPublisherException("Cannot get list of items to purge");
        }
        catch (Throwable t) {
            throw new ParthenosPublisherException(t);
        }
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public String getApplicationToken() {
        return this.applicationToken;
    }

    public void setApplicationToken(String applicationToken) {
        this.applicationToken = applicationToken;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public String getUriResolver() {
        return this.uriResolver;
    }

    public void setUriResolver(String uri_resolver) {
        this.uriResolver = this.uriResolver;
    }

    public String getPurgeBodyTemplate() {
        return this.purgeBodyTemplate;
    }

    public void setPurgeBodyTemplate(String purgeBodyTemplate) {
        this.purgeBodyTemplate = purgeBodyTemplate;
    }
}

