/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.parthenos.publisher;

import eu.dnetlib.parthenos.jrr.JRRPublisher;
import eu.dnetlib.parthenos.publisher.ParthenosPublisherException;
import eu.dnetlib.parthenos.publisher.ParthenosPublisherHelper;
import eu.dnetlib.parthenos.virtuoso.VirtuosoClient;
import eu.dnetlib.parthenos.virtuoso.VirtuosoClientFactory;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParthenosPublisherHelper {
    private static final Log log = LogFactory.getLog(ParthenosPublisherHelper.class);
    @Autowired
    private VirtuosoClientFactory virtuosoClientFactory;
    @Autowired
    private JRRPublisher jrrPublisher;

    public void publish(String record, ParthenosTargets target) throws ParthenosPublisherException {
        switch (1.$SwitchMap$eu$dnetlib$parthenos$publisher$ParthenosPublisherHelper$ParthenosTargets[target.ordinal()]) {
            case 1: {
                this.publishVirtuoso(record);
                break;
            }
            case 2: {
                try {
                    this.publishJRR(record);
                    break;
                }
                catch (IOException | InterruptedException | URISyntaxException e) {
                    throw new ParthenosPublisherException((Throwable)e);
                }
            }
            default: {
                throw new ParthenosPublisherException("Target " + target + " not supported yet");
            }
        }
    }

    public long unpublish(String datasourceInterface, ParthenosTargets target) throws ParthenosPublisherException {
        long res = 0L;
        switch (1.$SwitchMap$eu$dnetlib$parthenos$publisher$ParthenosPublisherHelper$ParthenosTargets[target.ordinal()]) {
            case 1: {
                res = this.unpublishVirtuoso(datasourceInterface);
                break;
            }
            default: {
                throw new ParthenosPublisherException("Target " + target + " not supported yet");
            }
        }
        return res;
    }

    private void publishVirtuoso(String record) throws ParthenosPublisherException {
        log.debug((Object)"Publishing on virtuoso");
        VirtuosoClient virtuosoClient = this.virtuosoClientFactory.getVirtuosoClient();
        virtuosoClient.feed(record);
    }

    private void publishJRR(String record) throws ParthenosPublisherException, IOException, URISyntaxException, InterruptedException {
        log.debug((Object)"Publishing on JRR (registry and catalogue)");
        this.jrrPublisher.register(record);
    }

    private int unpublishJRR(String datasourceInterface) {
        log.debug((Object)("Unpublishing from registry " + datasourceInterface));
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private long unpublishVirtuoso(String datasourceInterface) {
        log.info((Object)("Unpublishing from virtuoso " + datasourceInterface));
        VirtuosoClient virtuosoClient = this.virtuosoClientFactory.getVirtuosoClient();
        long deletedTriples = virtuosoClient.drop(datasourceInterface);
        log.info((Object)("# triples deleted for " + datasourceInterface + ": " + deletedTriples));
        return deletedTriples;
    }

    public int dropRegistry(int bulkSize) throws ParthenosPublisherException {
        log.debug((Object)"Dropping JRR");
        return this.jrrPublisher.purgeFromCatalogue(bulkSize);
    }
}

