/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.parthenos.catalogue;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CKANUtils {
    private static final Log log = LogFactory.getLog(CKANUtils.class);
    public static String Ariadne_group = "ariadne-consortium";
    public static String Cendari_group = "cendari-consortium";
    public static String Iccu_group = "central-institute-for-the-union-catalogue-of-italian-libraries-and-bibliographic-information-iccu";
    public static String Clarin_group = "clarin-eu";
    public static String DariahEU_group = "dariah-eu";
    public static String DariahGR_group = "dariah-gr-consortium";
    public static String DariahIT_group = "dariah-it";
    public static String DariahDE_group = "dariah-de-consortium";
    public static String EHRI_group = "ehri-consortium";
    public static String Flarenet_group = "flarenet";
    public static String Humanum_group = "huma-num-consortium";
    public static String Metashare_group = "meta-net-network-of-excellence";
    public static String Parthenos_group = "parthenos-project-consortium";
    public static String Ariadne_org = "ariadne";
    public static String Cendari_org = "cendari";
    public static String CulturaItalia_org = "cultura-italia";
    public static String Clarin_org = "clarin";
    public static String DariahDE_org = "dariah-de";
    public static String DariahGR_org = "dariah-gr";
    public static String DariahIT_org = "dariahit";
    public static String EHRI_org = "european-holocaust-research-infrastructure";
    public static String lre_org = "lre-map";
    public static String isidore_org = "huma-num--isidore";
    public static String nakala_org = "huma-num--nakala";
    public static String Metashare_org = "metashare";
    public static String Parthenos_org = "parthenos_registry";
    public static String Parthenos_wp3_org = "parthenos-wp3";
    public static String Parthenos_wp4_org = "parthenos-wp4";
    public static String Parthenos_wp7_org = "parthenos-wp7";
    public static String Parthenos_wp8_org = "parthenos-wp8";
    public static String Project_type = "Project";
    public static String Service_type = "Service";
    public static String Actor_type = "Actor";
    public static String Dataset_type = "Dataset";
    public static String Software_type = "Software";
    public static String Collection_type = "Physical Collection";
    public static String DesignOrProcedure_type = "Standard";

    public static String getCkanGroup(String riConsortiumLabel) {
        switch (riConsortiumLabel) {
            case "Ariadne Consortium": {
                return Ariadne_group;
            }
            case "Cendari Consortium": {
                return Cendari_group;
            }
            case "Central Institute for the Union Catalogue of Italian Libraries and Bibliographic Information (ICCU)": {
                return Iccu_group;
            }
            case "Clarin-EU": {
                return Clarin_group;
            }
            case "Dariah EU": {
                return DariahEU_group;
            }
            case "Dariah DE": {
                return DariahDE_group;
            }
            case "Dariah-GR Consortium": {
                return DariahGR_group;
            }
            case "EHRI Consortium": {
                return EHRI_group;
            }
            case "FLaReNet": {
                return Flarenet_group;
            }
            case "Huma-num Consortium": {
                return Humanum_group;
            }
            case "META-NET  Network of Excellence": {
                return Metashare_group;
            }
            case "DARIAH-IT": {
                return DariahIT_group;
            }
            case "Parthenos Project Consortium": {
                return Parthenos_group;
            }
        }
        log.warn((Object)("No Ckan group matches RI consortium label " + riConsortiumLabel));
        return null;
    }

    public static String getCKanOrg(String datasourceName) {
        switch (datasourceName) {
            case "ARIADNE": {
                return Ariadne_org;
            }
            case "European Holocaust Research Infrastructure": {
                return EHRI_org;
            }
            case "Cultura Italia": {
                return CulturaItalia_org;
            }
            case "PARTHENOS": {
                return Parthenos_org;
            }
            case "PARTHENOS WP3": {
                return Parthenos_wp3_org;
            }
            case "PARTHENOS WP4": {
                return Parthenos_wp4_org;
            }
            case "PARTHENOS WP7": {
                return Parthenos_wp7_org;
            }
            case "PARTHENOS WP8": {
                return Parthenos_wp8_org;
            }
            case "METASHARE": {
                return Metashare_org;
            }
            case "LRE MAP": {
                return lre_org;
            }
            case "Huma-Num - Isidore": {
                return isidore_org;
            }
            case "Huma-Num - Nakala": {
                return nakala_org;
            }
            case "DARIAH-DE": {
                return DariahDE_org;
            }
            case "DARIAH-IT ": {
                return DariahIT_org;
            }
            case "DARIAH-GR": {
                return DariahGR_org;
            }
            case "CLARIN": {
                return Clarin_org;
            }
            case "CENDARI": {
                return Cendari_org;
            }
        }
        log.warn((Object)("No Ckan org matches data source name " + datasourceName));
        return null;
    }
}

