/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.parthenos.jrr;

import eu.dnetlib.parthenos.CRM;
import eu.dnetlib.parthenos.CRMdig;
import eu.dnetlib.parthenos.CRMpe;
import eu.dnetlib.parthenos.catalogue.CatalogueRegistrator;
import eu.dnetlib.parthenos.publisher.ParthenosPublisherException;
import eu.dnetlib.parthenos.rdf.RecordParserHelper;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.InfModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDF;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JRRPublisher {
    private static final Log log = LogFactory.getLog(JRRPublisher.class);
    private OntModel baseModel;
    @Autowired
    private CatalogueRegistrator catalogueRegistrator;
    @Autowired
    private RecordParserHelper recordParserHelper;

    @PostConstruct
    public void init() {
        this.baseModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.RDFS_MEM_TRANS_INF);
        this.baseModel.read("http://parthenos.d4science.org/CRMext/CRMpe.rdfs");
        this.baseModel.read("http://www.cidoc-crm.org/sites/default/files2/cidoc_crm_v6.2-draft-2015August.rdfs");
        this.baseModel.read("http://www.ics.forth.gr/isl/CRMext/CRMdig_v3.2.2.rdfs");
    }

    @Deprecated
    public void register(String record) throws ParthenosPublisherException, IOException, URISyntaxException, InterruptedException {
        String id = this.recordParserHelper.getObjIdentifier(record);
        String datasourceName = this.recordParserHelper.getDatasourceName(record);
        String rdfRecord = this.recordParserHelper.getRDF(record);
        this.register(rdfRecord, id, datasourceName);
    }

    public int purgeFromCatalogue(int bulkSize) throws ParthenosPublisherException {
        return this.catalogueRegistrator.purgeAll(bulkSize);
    }

    public void register(String rdfRecord, String objIdentifier, String datasourceName) throws ParthenosPublisherException, IOException, URISyntaxException, InterruptedException {
        log.debug((Object)("REGISTERING ON JRR: " + objIdentifier));
        InfModel model = this.loadBaseModel();
        model.read(IOUtils.toInputStream((String)rdfRecord), "http://parthenos.d4science.org/CRMext/CRMpe.rdfs/", "RDF/XML");
        this.register((Model)model, objIdentifier, datasourceName);
    }

    protected void register(Model model, String resourceURI, String datasourceName) throws ParthenosPublisherException, IOException, URISyntaxException, InterruptedException {
        Resource rdfResource = model.getResource(resourceURI);
        if (rdfResource == null) {
            log.error((Object)("UNEXPECTED NULL rdfResource with resourceURI " + resourceURI + ". I am skipping it, but you should check!"));
        } else if (rdfResource.hasProperty(RDF.type, (RDFNode)CRM.E39_Actor)) {
            this.registerRDFResource(rdfResource, CRM.E39_Actor, datasourceName);
        } else if (rdfResource.hasProperty(RDF.type, (RDFNode)CRMpe.PE35_Project)) {
            this.registerRDFResource(rdfResource, CRMpe.PE35_Project, datasourceName);
        } else if (rdfResource.hasProperty(RDF.type, (RDFNode)CRM.E29_Design_or_Procedure)) {
            this.registerRDFResource(rdfResource, CRM.E29_Design_or_Procedure, datasourceName);
        } else if (rdfResource.hasProperty(RDF.type, (RDFNode)CRMdig.D14_Software)) {
            this.registerRDFResource(rdfResource, CRMdig.D14_Software, datasourceName);
        } else if (rdfResource.hasProperty(RDF.type, (RDFNode)CRMpe.PE18_Dataset)) {
            this.registerRDFResource(rdfResource, CRMpe.PE18_Dataset, datasourceName);
        } else if (rdfResource.hasProperty(RDF.type, (RDFNode)CRM.E78_Collection)) {
            this.registerRDFResource(rdfResource, CRM.E78_Collection, datasourceName);
        } else if (rdfResource.hasProperty(RDF.type, (RDFNode)CRMpe.PE1_Service)) {
            this.registerRDFResource(rdfResource, CRMpe.PE1_Service, datasourceName);
        } else {
            log.debug((Object)("Skipping " + resourceURI + " because of its type"));
        }
    }

    protected boolean registerRDFResource(Resource rdfResource, Resource type, String datasourceName) throws ParthenosPublisherException, IOException, URISyntaxException, InterruptedException {
        String resURI = rdfResource.getURI();
        if (!resURI.startsWith("http")) {
            log.info((Object)("Resource " + resURI + " skipped: URI does not start with http"));
            return false;
        }
        String uuid = this.registerOnCatalogue(rdfResource, type, datasourceName);
        if (StringUtils.isNotBlank((CharSequence)uuid)) {
            return true;
        }
        log.warn((Object)("Got blank uuid when registering " + resURI + ": skipping registration on the registry"));
        return false;
    }

    protected String registerOnCatalogue(Resource rdfResource, Resource type, String datasourceName) throws ParthenosPublisherException, IOException, URISyntaxException, InterruptedException {
        return this.catalogueRegistrator.register(rdfResource, type, datasourceName);
    }

    protected InfModel loadBaseModel() {
        return ModelFactory.createRDFSModel((Model)this.baseModel);
    }
}

