/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.parthenos.virtuoso;

import eu.dnetlib.parthenos.publisher.ParthenosPublisherException;
import eu.dnetlib.parthenos.rdf.RecordParserHelper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import virtuoso.jena.driver.VirtModel;

public class VirtuosoClient {
    private static final Log log = LogFactory.getLog(VirtuosoClient.class);
    public static final String PROVENANCE_NS = "http://www.d-net.research-infrastructures.eu/provenance/";
    public static final String PROVENANCE_GRAPH = "http://www.d-net.research-infrastructures.eu/provenance/graph";
    public static Property IS_API_OF = ResourceFactory.createProperty((String)"http://www.d-net.research-infrastructures.eu/provenance/", (String)"isApiOf");
    public static Property COLL_FROM = ResourceFactory.createProperty((String)"http://www.d-net.research-infrastructures.eu/provenance/", (String)"collectedFrom");
    public static Property COLL_IN_DATE = ResourceFactory.createProperty((String)"http://www.d-net.research-infrastructures.eu/provenance/", (String)"collectedInDate");
    public static Property TRANS_IN_DATE = ResourceFactory.createProperty((String)"http://www.d-net.research-infrastructures.eu/provenance/", (String)"transformedInDate");
    private RecordParserHelper recordParserHelper;
    private String connectionString;
    private String username;
    private String password;
    private String defaultBaseURI;

    protected VirtuosoClient(String connectionString, String username, String password, RecordParserHelper recordParserHelper, String defaultBaseURI) {
        this.connectionString = connectionString;
        this.username = username;
        this.password = password;
        this.recordParserHelper = recordParserHelper;
        this.defaultBaseURI = defaultBaseURI;
    }

    public long feed(String record) throws ParthenosPublisherException {
        VirtModel md = null;
        try {
            if (StringUtils.isBlank((CharSequence)record)) {
                log.warn((Object)"Got empty record");
                return 0L;
            }
            String objIdentifier = this.recordParserHelper.getObjIdentifier(record);
            if (StringUtils.isBlank((CharSequence)objIdentifier)) {
                log.warn((Object)"Got record with no objIdentifier -- skipping");
                return 0L;
            }
            String rdfBlock = this.recordParserHelper.getRDF(record);
            if (StringUtils.isBlank((CharSequence)rdfBlock)) {
                log.warn((Object)("Missing rdf:RDF in record with objIdentifier " + objIdentifier + " all triples in that named graph will be deleted"));
            }
            String collectionDate = this.recordParserHelper.getCollectionDate(record);
            String transformationDate = this.recordParserHelper.getTransformationDate(record);
            String datasource = this.recordParserHelper.getDatasourceName(record);
            String dsInterface = this.recordParserHelper.getDatasourceApi(record);
            String namedGraph = this.getRecordDefaultURI(objIdentifier, dsInterface);
            log.debug((Object)("Trying to open the database model " + namedGraph + ", connection string " + this.getConnectionString()));
            md = VirtModel.openDatabaseModel((String)namedGraph, (String)this.getConnectionString(), (String)this.getUsername(), (String)this.getPassword());
            log.debug((Object)("Opened virtuoso model for graph " + namedGraph));
            md.removeAll();
            log.debug((Object)("Removed all triples from graph " + namedGraph));
            md.read(IOUtils.toInputStream((String)rdfBlock, (String)"UTF-8"), this.getDefaultBaseURI());
            long size = md.size();
            log.debug((Object)("Graph " + namedGraph + " now has " + size + " triples"));
            long ntriples = this.feedProvenance(namedGraph, collectionDate, transformationDate, datasource, dsInterface);
            log.debug((Object)("provenance graph for " + namedGraph + " updated with " + ntriples + " triples"));
            md.close();
            return size;
        }
        catch (Throwable e) {
            if (md != null && !md.isClosed()) {
                md.close();
            }
            log.error((Object)e);
            throw new ParthenosPublisherException(e);
        }
    }

    long feedProvenance(String namedGraphURI, String collectionDate, String transformationDate, String datasource, String api) {
        VirtModel md = VirtModel.openDatabaseModel((String)PROVENANCE_GRAPH, (String)this.getConnectionString(), (String)this.getUsername(), (String)this.getPassword());
        Resource rApi = ResourceFactory.createResource((String)(this.defaultBaseURI + api));
        Resource r = ResourceFactory.createResource((String)namedGraphURI);
        Statement stmApi = ResourceFactory.createStatement((Resource)rApi, (Property)IS_API_OF, (RDFNode)ResourceFactory.createPlainLiteral((String)datasource));
        Statement stmCollFrom = ResourceFactory.createStatement((Resource)r, (Property)COLL_FROM, (RDFNode)rApi);
        Statement stmCollDate = ResourceFactory.createStatement((Resource)r, (Property)COLL_IN_DATE, (RDFNode)ResourceFactory.createTypedLiteral((String)collectionDate, (RDFDatatype)XSDDatatype.XSDdateTime));
        Statement stmTransDate = ResourceFactory.createStatement((Resource)r, (Property)TRANS_IN_DATE, (RDFNode)ResourceFactory.createTypedLiteral((String)transformationDate, (RDFDatatype)XSDDatatype.XSDdateTime));
        md.removeAll(r, null, null);
        md.add(stmApi).add(stmCollFrom).add(stmCollDate).add(stmTransDate);
        md.close();
        return 3L;
    }

    public long feed(Iterable<String> records) throws ParthenosPublisherException {
        long count = 0L;
        for (String r : records) {
            count += this.feed(r);
        }
        return count;
    }

    public long drop(String api) {
        VirtModel prov = VirtModel.openDatabaseModel((String)PROVENANCE_GRAPH, (String)this.getConnectionString(), (String)this.getUsername(), (String)this.getPassword());
        Resource rApi = ResourceFactory.createResource((String)(this.defaultBaseURI + api));
        long deletedTriples = 0L;
        ResIterator resIterator = prov.listSubjectsWithProperty(COLL_FROM, (RDFNode)rApi);
        while (resIterator.hasNext()) {
            Resource namedGraphURI = resIterator.nextResource();
            deletedTriples += this.dropNamedGraph(namedGraphURI.getURI());
            prov.removeAll(namedGraphURI, null, null);
        }
        prov.removeAll(null, null, (RDFNode)rApi);
        prov.removeAll(rApi, null, null);
        prov.close();
        return deletedTriples;
    }

    private long dropNamedGraph(String namedGraphURI) {
        VirtModel namedGraph = VirtModel.openDatabaseModel((String)namedGraphURI, (String)this.getConnectionString(), (String)this.getUsername(), (String)this.getPassword());
        long deletedTriples = namedGraph.size();
        namedGraph.removeAll();
        namedGraph.close();
        return deletedTriples;
    }

    private String getRecordDefaultURI(String objIdentifier, String datasourceApi) {
        return this.defaultBaseURI + datasourceApi + "/" + objIdentifier;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDefaultBaseURI() {
        return this.defaultBaseURI;
    }

    public RecordParserHelper getRecordParserHelper() {
        return this.recordParserHelper;
    }

    public void setRecordParserHelper(RecordParserHelper recordParserHelper) {
        this.recordParserHelper = recordParserHelper;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDefaultBaseURI(String defaultBaseURI) {
        this.defaultBaseURI = defaultBaseURI;
    }
}

