<?xml version="1.0" encoding="UTF-8"?>
<RESOURCE_PROFILE>
    <HEADER>
        <RESOURCE_IDENTIFIER value=""/>
        <RESOURCE_TYPE value="WorkflowDSResourceType"/>
        <RESOURCE_KIND value="WorkflowDSResources"/>
        <RESOURCE_URI value=""/>
        <DATE_OF_CREATION value=""/>
    </HEADER>
    <BODY>
        <WORKFLOW_NAME>$name$</WORKFLOW_NAME>
        <WORKFLOW_DESCRIPTION>$desc$</WORKFLOW_DESCRIPTION>
        <WORKFLOW_INFO />
        <WORKFLOW_FAMILY>publishing</WORKFLOW_FAMILY>
        <WORKFLOW_PRIORITY>$priority$</WORKFLOW_PRIORITY>
        <DATASOURCE id="$dsId$" interface="$interface$" />

        <CONFIGURATION status="WAIT_SYS_SETTINGS" start="MANUAL">
            <PARAMETERS>
                <PARAM name="cleanMdstoreId"        description="Store for cleaned records"         required="true"     managedBy="system"  category="MDSTORE_ID"     />
				<PARAM name="indexId"               description="Identifier of the Index"           required="true" managedBy="system"  category="INDEX_ID"/>
            	<PARAM name="indexInterpretation"   description="Index Interpretation"              required="true" managedBy="system"  type="string">public</PARAM>
            	<PARAM name="feedingType"           description="Index feeding type"                required="true" managedBy="user"    type="string"   function="validValues(['REFRESH','INCREMENTAL'])">REFRESH</PARAM>
            	<PARAM name="OAIFormat"             description="OAI Format"                        required="true" managedBy="user"  type="string">CIDOC</PARAM>
                <PARAM name="OAILayout"             description="OAI Layout"                        required="true" managedBy="system"  type="string">OAI</PARAM>
                <PARAM name="OAIInterpretation"     description="OAI Interpretation"                required="true" managedBy="system"  type="string">transformed</PARAM>
                <PARAM name="OAIDBName"             description="OAI Database Name"                 required="true" managedBy="system"  type="string">oaistore_parthenos</PARAM>
                <PARAM name="OAIConfiguredOnly"     description="Count only configured OAI sets"    required="true" managedBy="user"    type="boolean">false</PARAM>
                <PARAM name="publisherEndpoint"     description="Parthenos Publisher Endpoint"      required="true" managedBy="user"    type="string"/>
            </PARAMETERS>
            <WORKFLOW>
                <NODE name="index" type="LaunchWorkflowTemplate" isStart="true" >
                    <DESCRIPTION>Index records</DESCRIPTION>
                    <PARAMETERS>
                        <PARAM name="wfTemplateId" value="23e81407-da05-46a6-a11e-928f92432922_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                        <PARAM name="wfTemplateParams">
                            <MAP>
                                <ENTRY key="dsId"               value="$dsId$" />
                                <ENTRY key="interface"          value="$interface$" />
                                <ENTRY key="cleanMdstoreId"     ref="cleanMdstoreId" />
                                <ENTRY key="indexId"            ref="indexId" />
                                <ENTRY key="feedingType"        ref="feedingType" />
                                <ENTRY key="interpretation"     ref="indexInterpretation" />
                            </MAP>
                        </PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="success"/>
                    </ARCS>
                </NODE>
                <NODE name="virtuoso" type="LaunchWorkflowTemplate" isStart="true" >
                    <DESCRIPTION>Store RDF files in Virtuoso</DESCRIPTION>
                    <PARAMETERS>
                        <PARAM name="wfTemplateId" value="b7a6c826-6d5e-46c7-a553-4c0fc1d9ab72_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                        <PARAM name="wfTemplateParams">
                            <MAP>
                                <ENTRY key="publisherEndpoint"  ref="publisherEndpoint" />
                                <ENTRY key="interface"          value="$interface$" />
                                <ENTRY key="cleanMdstoreId"     ref="cleanMdstoreId" />
                            </MAP>
                        </PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="success"/>
                    </ARCS>
                </NODE>
                <NODE name="oaiFeed" type="LaunchWorkflowTemplate" isStart="true" >
                    <DESCRIPTION>Feed oai records</DESCRIPTION>
                    <PARAMETERS>
                        <PARAM name="wfTemplateId" value="df913a07-0a79-4b67-90c5-890733bca137_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                        <PARAM name="wfTemplateParams">
                            <MAP>
                                <ENTRY key="cleanMdstoreId"     ref="cleanMdstoreId" />
                                <ENTRY key="OAIFormat"          ref="OAIFormat"/>
                                <ENTRY key="OAILayout"          ref="OAILayout"/>
                                <ENTRY key="OAIInterpretation"  ref="OAIInterpretation"/>
                                <ENTRY key="OAIDBName"          ref="OAIDBName"/>
                            </MAP>
                        </PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="oaiPostFeed"/>
                    </ARCS>
                </NODE>
                <NODE name="oaiPostFeed" type="LaunchWorkflowTemplate">
                    <DESCRIPTION>Oai Post Feed Action</DESCRIPTION>
                    <PARAMETERS>
                        <PARAM name="wfTemplateId" value="f236f97a-199f-4f9a-80c8-0e356077e1d6_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                        <PARAM name="wfTemplateParams">
                            <MAP>
                               <ENTRY key="OAIFormat"          ref="OAIFormat"/>
                               <ENTRY key="OAILayout"          ref="OAILayout"/>
                               <ENTRY key="OAIInterpretation"  ref="OAIInterpretation"/>
                               <ENTRY key="OAIDBName"          ref="OAIDBName"/>
                               <ENTRY key="OAIConfiguredOnly"  ref="OAIConfiguredOnly"/>
                               <ENTRY key="dsName"         value="$dsName$" />
                            </MAP>
                        </PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="success"/>
                    </ARCS>
                </NODE>
            </WORKFLOW>
            <DESTROY_WORKFLOW_TEMPLATE id="23ef4bb3-2383-45b4-9661-ab03472fcd52_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==">
                <PARAMETERS/>
            </DESTROY_WORKFLOW_TEMPLATE>
        </CONFIGURATION>

        <NOTIFICATIONS/>
        
        <SCHEDULING enabled="false">
            <CRON>9 9 9 ? * *</CRON>
            <MININTERVAL>10080</MININTERVAL>
        </SCHEDULING>
        <STATUS/>
    </BODY>
</RESOURCE_PROFILE>
