/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.parthenos.workflows.nodes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.manager.MSROException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.beans.factory.annotation.Autowired;

public class PublishVirtuosoJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(PublishVirtuosoJobNode.class);
    private String inputEprParam;
    @Autowired
    private ResultSetClient resultSetClient;
    private String publisherEndpoint;

    protected String execute(Env env) throws Exception {
        ResultSet rsIn = (ResultSet)env.getAttribute(this.getInputEprParam(), ResultSet.class);
        if (rsIn == null) {
            throw new MSROException("InputEprParam (" + this.getInputEprParam() + ") not found in ENV");
        }
        int countAll = 0;
        int countOk = 0;
        HashMap errors = Maps.newHashMap();
        log.info((Object)("Publisher endpoint: " + this.getPublisherEndpoint()));
        block3: for (String record : this.getResultSetClient().iter(rsIn, String.class)) {
            HttpPost post = new HttpPost(this.getPublisherEndpoint());
            ArrayList params = Lists.newArrayList();
            params.add(new BasicNameValuePair("record", record));
            params.add(new BasicNameValuePair("parthenosTarget", "VIRTUOSO"));
            UrlEncodedFormEntity ent = new UrlEncodedFormEntity((List)params, "UTF-8");
            post.setEntity((HttpEntity)ent);
            CloseableHttpClient client = HttpClients.createDefault();
            HttpResponse responsePOST = client.execute((HttpUriRequest)post);
            ++countAll;
            int statusCode = responsePOST.getStatusLine().getStatusCode();
            switch (statusCode) {
                case 200: {
                    ++countOk;
                    continue block3;
                }
            }
            log.error((Object)(responsePOST.getStatusLine().getStatusCode() + ": " + responsePOST.getStatusLine().getReasonPhrase()));
            errors.merge(statusCode, 1, Integer::sum);
        }
        env.setAttribute("mainlog:countOk", (Object)countOk);
        env.setAttribute("mainlog:countAll", (Object)countAll);
        env.setAttribute("mainlog:errorsMap", (Object)new Gson().toJson((Object)errors));
        if (!errors.isEmpty()) {
            throw new MSROException("Problems in publishing");
        }
        return Arc.DEFAULT_ARC;
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getPublisherEndpoint() {
        return this.publisherEndpoint;
    }

    public void setPublisherEndpoint(String publisherEndpoint) {
        this.publisherEndpoint = publisherEndpoint;
    }

    public ResultSetClient getResultSetClient() {
        return this.resultSetClient;
    }

    public void setResultSetClient(ResultSetClient resultSetClient) {
        this.resultSetClient = resultSetClient;
    }
}

