<?xml version="1.0" encoding="UTF-8"?>
<RESOURCE_PROFILE>
    <HEADER>
        <RESOURCE_IDENTIFIER value=""/>
        <RESOURCE_TYPE value="WorkflowDSResourceType"/>
        <RESOURCE_KIND value="WorkflowDSResources"/>
        <RESOURCE_URI value=""/>
        <DATE_OF_CREATION value=""/>
    </HEADER>
    <BODY>
        <WORKFLOW_NAME>$name$</WORKFLOW_NAME>
        <WORKFLOW_DESCRIPTION>$desc$</WORKFLOW_DESCRIPTION>
        <WORKFLOW_INFO />
        <WORKFLOW_FAMILY>publishing</WORKFLOW_FAMILY>
        <WORKFLOW_PRIORITY>$priority$</WORKFLOW_PRIORITY>
        <DATASOURCE id="$dsId$" interface="$interface$" />

        <CONFIGURATION status="WAIT_SYS_SETTINGS" start="MANUAL">
            <PARAMETERS>
                <PARAM name="indexId"               description="Identifier of the Index"           required="true" managedBy="system"  category="INDEX_ID"/>
            	<PARAM name="OAIFormat"             description="OAI Format"                        required="true" managedBy="user"    type="string">CIDOC</PARAM>
                <PARAM name="OAILayout"             description="OAI Layout"                        required="true" managedBy="system"  type="string">OAI</PARAM>
                <PARAM name="OAIInterpretation"     description="OAI Interpretation"                required="true" managedBy="system"  type="string">transformed</PARAM>
                <PARAM name="OAIDBName"             description="OAI Database Name"                 required="true" managedBy="system"  type="string">oaistore_parthenos</PARAM>
                <PARAM name="OAIConfiguredOnly"     description="Count only configured OAI sets"    required="true" managedBy="user"    type="boolean">false</PARAM>
                <PARAM name="publisherEndpoint"     description="Parthenos Publisher Endpoint"      required="true" managedBy="user"    type="string">http://beta-parthenos.d4science.org:8080/parthenos/unpublish</PARAM>
				<PARAM name="interface"             description="Datasource Interface"              required="true" managedBy="system"  type="string"/>
            </PARAMETERS>
            <WORKFLOW>
                	<NODE name="deleteIndex" type="DeleteIndex" isStart="true">
                		<DESCRIPTION>Delete the index</DESCRIPTION>
                		<PARAMETERS>
                			<PARAM name="indexId" ref="indexId"/>
                		</PARAMETERS>
                		<ARCS>
                			<ARC to="success"/>
                		</ARCS>
                	</NODE>
                	<NODE name="dropOAI" type="OAIDropStore" isStart="true">
                		<DESCRIPTION>Delete from oai</DESCRIPTION>
                		<PARAMETERS>
                			<PARAM name="oaiDbName" ref="OAIDBName"/>
                			<PARAM name="oaiFormat" ref="OAIFormat"/>
                			<PARAM name="oaiLayout" ref="OAILayout"/>
                			<PARAM name="oaiInterpretation" ref="OAIInterpretation"/>
                			<PARAM name="setSpec" ref="dsName" />
                		</PARAMETERS>
                		<ARCS>
                			<ARC to="updateSetsCount"/>
                		</ARCS>
                	</NODE>
                	<NODE name="updateSetsCount" type="OAISetsCountUpdate">
                		<DESCRIPTION>Update the OAI sets count</DESCRIPTION>
                		<PARAMETERS>
                            <PARAM name="oaiDbName" ref="OAIDBName"/>
                            <PARAM name="oaiFormat" ref="OAIFormat"/>
                            <PARAM name="oaiLayout" ref="OAILayout"/>
                            <PARAM name="oaiInterpretation" ref="OAIInterpretation"/>
                            <PARAM name="configuredOnly" value="true"/>
                		</PARAMETERS>
                		<ARCS>
                			<ARC to="success"/>
                		</ARCS>
                	</NODE>
                	<NODE name="unpublishVirtuoso" type="UnpublishVirtuoso">
                    	<DESCRIPTION>Drop from Virtuoso</DESCRIPTION>
                        <PARAMETERS>
                            <PARAM name="publisherEndpoint" ref="publisherEndpoint"/>
                            <PARAM name="datasourceInterface" value="$interface$" />
                        </PARAMETERS>
                        <ARCS>
                            <ARC to="success"/>
                        </ARCS>
                    </NODE>
           </WORKFLOW>
           <DESTROY_WORKFLOW_TEMPLATE id="23ef4bb3-2383-45b4-9661-ab03472fcd52_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==">
               <PARAMETERS/>
           </DESTROY_WORKFLOW_TEMPLATE></CONFIGURATION>
        <NOTIFICATIONS/>
        
        <SCHEDULING enabled="false">
            <CRON>9 9 9 ? * *</CRON>
            <MININTERVAL>10080</MININTERVAL>
        </SCHEDULING>
        <STATUS/>
    </BODY>
</RESOURCE_PROFILE>
