/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.parthenos.workflows.nodes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.manager.MSROException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class PublishAbstractJobNode
extends AsyncJobNode {
    private static final Log log = LogFactory.getLog(PublishAbstractJobNode.class);
    private String inputEprParam;
    @Autowired
    private ResultSetClient resultSetClient;
    private String publisherEndpoint;
    private int nThreads = 5;
    private int nLatch = 15;
    private ExecutorService executorService = Executors.newFixedThreadPool(this.nThreads);
    private List<Future<Integer>> resList = Lists.newArrayList();

    protected String execute(Env env) throws Exception {
        ResultSet rsIn = (ResultSet)env.getAttribute(this.getInputEprParam(), ResultSet.class);
        if (rsIn == null) {
            throw new MSROException("InputEprParam (" + this.getInputEprParam() + ") not found in ENV");
        }
        int countAll = 0;
        int countOk = 0;
        HashMap errors = Maps.newHashMap();
        log.info((Object)("Publisher endpoint: " + this.getPublisherEndpoint()));
        CountDownLatch latch = new CountDownLatch(this.nLatch);
        for (String string : this.getResultSetClient().iter(rsIn, String.class)) {
            if (++countAll >= this.nLatch && countAll % this.nLatch == 0) {
                log.debug((Object)("Waiting for tasks to complete before resubmitting to executor (countAll = " + countAll + ") . . . "));
                long startWait = System.currentTimeMillis();
                latch.await();
                log.debug((Object)(". . . Ready to submit again after " + (System.currentTimeMillis() - startWait) + " ms"));
            }
            Future<Integer> res = this.executorService.submit(() -> {
                try {
                    HttpPost post = new HttpPost(this.getPublisherEndpoint());
                    ArrayList params = Lists.newArrayList();
                    params.add(new BasicNameValuePair("record", record));
                    params.add(new BasicNameValuePair("parthenosTarget", this.getTarget()));
                    UrlEncodedFormEntity ent = new UrlEncodedFormEntity((List)params, "UTF-8");
                    post.setEntity((HttpEntity)ent);
                    CloseableHttpClient client = HttpClients.createDefault();
                    HttpResponse responsePOST = client.execute((HttpUriRequest)post);
                    int statusCode = responsePOST.getStatusLine().getStatusCode();
                    switch (statusCode) {
                        case 200: {
                            Integer n = statusCode;
                            return n;
                        }
                    }
                    log.error((Object)(responsePOST.getStatusLine().getStatusCode() + ": " + responsePOST.getStatusLine().getReasonPhrase()));
                    log.error((Object)("Source record causing error: " + record));
                    errors.merge(statusCode, 1, Integer::sum);
                    Integer n = statusCode;
                    return n;
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage());
                    errors.merge(-1, 1, Integer::sum);
                }
                finally {
                    latch.countDown();
                }
                return -1;
            });
            this.resList.add(res);
        }
        this.executorService.shutdown();
        log.info((Object)"Waiting for responses");
        for (Future future : this.resList) {
            if ((Integer)future.get() != 200) continue;
            ++countOk;
        }
        log.info((Object)String.format("Got all responses. Ok %s/%s", countOk, countAll));
        env.setAttribute("mainlog:countOk", (Object)countOk);
        env.setAttribute("mainlog:countAll", (Object)countAll);
        env.setAttribute("mainlog:errorsMap", (Object)new Gson().toJson((Object)errors));
        log.info((Object)"publishing completed");
        if (!errors.isEmpty()) {
            log.warn((Object)("Problems in publishing on " + this.getTarget() + ": " + countOk + "/" + countAll + " see error maps for details"));
        }
        if (countAll == 0) {
            log.warn((Object)"0 resources to publish");
        }
        return Arc.DEFAULT_ARC;
    }

    public abstract String getTarget();

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getPublisherEndpoint() {
        return this.publisherEndpoint;
    }

    public void setPublisherEndpoint(String publisherEndpoint) {
        this.publisherEndpoint = publisherEndpoint;
    }

    public ResultSetClient getResultSetClient() {
        return this.resultSetClient;
    }

    public void setResultSetClient(ResultSetClient resultSetClient) {
        this.resultSetClient = resultSetClient;
    }
}

