package eu.dnetlib.parthenos.workflows.nodes;

import java.util.Map;

import com.google.gson.Gson;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Created by Alessia Bardi on 05/04/17.
 *
 * @author Alessia Bardi
 */
public class ReportReaderJobNode extends AsyncJobNode {

	private static final Log log = LogFactory.getLog(ReportReaderJobNode.class);
	private String reportEnvParam = "validationReport";
	private String outputParam = reportEnvParam;

	@Override
	protected String execute(final Env env) throws Exception {
		Map<String, String> report = env.getAttribute(reportEnvParam, Map.class);
		Gson gson = new Gson();
		String theReport = gson.toJson(report);
		env.setAttribute( WorkflowsConstants.MAIN_LOG_PREFIX+outputParam, theReport);
		log.debug("Found the report: "+theReport);
		return Arc.DEFAULT_ARC;
	}

	public String getReportEnvParam() {
		return reportEnvParam;
	}

	public void setReportEnvParam(final String reportEnvParam) {
		this.reportEnvParam = reportEnvParam;
	}

	public String getOutputParam() {
		return outputParam;
	}

	public void setOutputParam(final String outputParam) {
		this.outputParam = outputParam;
	}
}
