<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0"
                xmlns:crm="http://www.cidoc-crm.org/cidoc-crm/"
                xmlns:crmpe="http://parthenos.d4science.org/CRMext/CRMpe.rdfs/"
                xmlns:crmdig="http://www.ics.forth.gr/isl/CRMext/CRMdig.rdfs/"
                xmlns:dr="http://www.driver-repository.eu/namespace/dr"
                xmlns:dri="http://www.driver-repository.eu/namespace/dri"
                xmlns:dc="http://purl.org/dc/elements/1.1/"
                xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
                xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#" xmlns:foaf="http://xmlns.com/foaf/0.1/">

	<xsl:output method="html" encoding="UTF-8" indent="yes" omit-xml-declaration="yes"/>

	<xsl:template match="/">
		<div class="row">
			<div class="col-xs-2">
				<img src="../resources/img/record.png" width="80" height="80"/>
			</div>
			<div class="col-xs-10">
				<xsl:if test="//*[local-name() = 'title']">
					<h1 id="overview">
						<!-- this is visualized big next to the picture. Since we cannot identify 1 main title, for Parthenos it wil be empty -->
						<!--<xsl:value-of select="/crm:P102_has_title"/>-->
					</h1>
				</xsl:if>
			</div>
		</div>

		<div class="row">
			<div class="col-xs-12">
				<h6><span class="glyphicon glyphicon-align-left"/> GENERAL INFORMATION </h6>
				<table class="table">
					<tbody>
						<tr>
							<td class="col-xs-3">
								<strong>Original identifier</strong>
							</td>
							<td><xsl:value-of select="//dri:recordIdentifier"/></td>
						</tr>
						<tr>
							<td class="col-xs-3">
								<strong>Provenance</strong>
							</td>
							<td>
								<i>Data source: </i>
								<xsl:value-of select="//dri:datasourcename"/>
								<br/>
								<i>D-Net API: </i>
								<xsl:value-of select="//dri:datasourceapi"/>
							</td>
						</tr>
						<tr>
							<td class="col-xs-3">
								<strong>Collected</strong>
							</td>
							<td>
								<xsl:value-of select="//dri:dateOfCollection"/>
							</td>
						</tr>
						<tr>
							<td class="col-xs-3">
								<strong>Transformed</strong>
							</td>
							<td>
								<xsl:value-of select="//dri:dateOfTransformation"/>
							</td>
						</tr>
						<tr>
							<td class="col-xs-3">
								<strong>Resource types</strong>
							</td>
							<td>
								<xsl:for-each-group select="//rdf:Description"
								                    group-by="./rdf:type/@rdf:resource">
									<i><xsl:value-of
											select="tokenize(current-grouping-key(), '/')[last()]"
									/></i> (<xsl:value-of select="count(current-group())"/>) --
								</xsl:for-each-group>
							</td>
						</tr>
					</tbody>
				</table>
				<h6><span class="glyphicon glyphicon-align-left"/> MINIMAL METADATA </h6>
				<table class="table">
						<tbody>
							<xsl:for-each-group select="//rdf:Description"
							                    group-by="./rdf:type/@rdf:resource">
								<xsl:for-each select="current-group()">
									<xsl:apply-templates select="." mode="minimalMetadata"/>
								</xsl:for-each>
							</xsl:for-each-group>
						</tbody>
					</table>
			</div>
		</div>

		<xsl:for-each select="//*[local-name() = 'record']">
			<h6><span class="glyphicon glyphicon-wrench"/> INDEXED RECORD </h6>
			<xsl:call-template name="xmlItem">
				<xsl:with-param name="indent" select="string('')"/>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>

	<xsl:template mode="minimalMetadata" match="text()" />

	<xsl:template name="generalDescriptors">
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">Label</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./rdfs:label/text()"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P1_is_identified_by</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P1_is_identified_by/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P2_has_type</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of
						select="./crm:P2_has_type/@rdf:resource"
				/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P3_has_note</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P3_has_note/text()"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<xsl:template name="coverageDescriptors">
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P4_has_time-span</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P4_has_time-span/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P7_took_place_at</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P7_took_place_at/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P8_took_place_on_or_within</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P8_took_place_on_or_within/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<xsl:template name="activityContext">
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P14_carried_out_by</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P14_carried_out_by/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P11_had_participant</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P11_had_participant/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:if test="./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE2_Hosting_Service'">
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP4_hosts_object</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crmpe:PP4_hosts_object/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
		</xsl:if>
		<xsl:if test="./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE5_Digital_Hosting_Service'">
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP6_hosts_digital_object</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crmpe:PP6_hosts_digital_object/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP4_hosts_object</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crmpe:PP4_hosts_object/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
		</xsl:if>
		<xsl:if test="./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE6_Software_Hosting_Service'">
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP7_hosts_software_object</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crmpe:PP7_hosts_software_object/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP6_hosts_digital_object</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crmpe:PP6_hosts_digital_object/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP4_hosts_object</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crmpe:PP4_hosts_object/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
		</xsl:if>
		<xsl:if test="./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE7_Data_Hosting_Service' or ./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE15_Data_E-Service'">
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP8_hosts_dataset</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crmpe:PP8_hosts_dataset/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP6_hosts_digital_object</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crmpe:PP6_hosts_digital_object/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP4_hosts_object</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crmpe:PP4_hosts_object/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
		</xsl:if>
		<xsl:if test="./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE3_Curating_Service'">
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP32_curates</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crmpe:PP32_curates/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
		</xsl:if>
		<xsl:if test="./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE10_Digital_Curating_Service'">
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP11_curates_volatile_digital_object</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crmpe:PP11_curates_volatile_digital_object/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP32_curates</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crmpe:PP32_curates/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
		</xsl:if>
		<xsl:if test="./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE11_Software_Curating_Service'">
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP12_curates_volatile_software</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crmpe:PP12_curates_volatile_software/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP11_curates_volatile_digital_object</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crmpe:PP11_curates_volatile_digital_object/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP32_curates</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crmpe:PP32_curates/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
		</xsl:if>
		<xsl:if test="./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE12_Data_Curating_Service'">
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP13_curates_volatile_dataset</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crmpe:PP13_curates_volatile_dataset/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP11_curates_volatile_digital_object</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crmpe:PP11_curates_volatile_digital_object/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP32_curates</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crmpe:PP32_curates/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
		</xsl:if>
		<xsl:if test="./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE13_Software_Computing_E-Service'">
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP14_runs_on_request</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crm:PP14_runs_on_request/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP7_hosts_software_object</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crm:PP7_hosts_software_object/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP6_hosts_digital_object</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crm:PP6_hosts_digital_object/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP4_hosts_object</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crm:PP4_hosts_object/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
		</xsl:if>
		<xsl:if test="./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE14_Software_Delivery_E-Service'">
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP15_delivers_on_request</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crm:PP15_delivers_on_request/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP7_hosts_software_object</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crm:PP7_hosts_software_object/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP6_hosts_digital_object</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crm:PP6_hosts_digital_object/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP4_hosts_object</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crm:PP4_hosts_object/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
		</xsl:if>
		<xsl:if test="./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE16_Curated_Software_E-Service'">
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP12_curates_volatile_software</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crmpe:PP12_curates_volatile_software/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP11_curates_volatile_digital_object</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crmpe:PP11_curates_volatile_digital_object/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP32_curates</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crmpe:PP32_curates/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP14_runs_on_request</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crmpe:PP14_runs_on_request/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP15_delivers_on_request</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crmpe:PP15_delivers_on_request/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP7_hosts_software_object</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crmpe:PP7_hosts_software_object/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP6_hosts_digital_object</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crmpe:PP6_hosts_digital_object/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP4_hosts_object</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crmpe:PP4_hosts_object/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
		</xsl:if>

		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P16_used_specific_object</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P16_used_specific_object/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P125_used_object_of_type</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P125_used_object_of_type/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P12_occurred_in_the_presence_of</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P12_occurred_in_the_presence_of/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:if test="./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE3_Curating_Service'
						or ./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE10_Digital_Curating_Service'
						or ./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE11_Software_Curating_Service'
						or ./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE12_Data_Curating_Service'">
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP31_uses_curation_plan</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crmpe:PP31_uses_curation_plan/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
		</xsl:if>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P33_used_specific_technique</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P33_used_specific_technique/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P32_used_general_technique</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P32_used_general_technique/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P20_had_specific_purpose</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P20_had_specific_purpose/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P21_had_general_purpose</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P21_had_general_purpose/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<xsl:template  match="rdf:Description[./rdf:type/@rdf:resource = 'http://www.cidoc-crm.org/cidoc-crm/E73_Information_Object']" mode="minimalMetadata">
		<tr>
			<td>
				<strong>E73_Information_Object</strong> : <strong><xsl:value-of select="./@rdf:about"/></strong><br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">Label</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./rdfs:label/text()"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P1_is_identified_by</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P1_is_identified_by/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P149_is_identified_by</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P149_is_identified_by/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P102_has_title</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P102_has_title/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P2_has_type</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P2_has_type/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P3_has_note</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P3_has_note/text()"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P129_is_about</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P129_is_about/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P67_refers_to</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P67_refers_to/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P94i_was_created_by</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P94i_was_created_by/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P106i_forms_part_of</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P106i_forms_part_of/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P106_is_composed_of</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P106_is_composed_of/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P165_incorporates</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P165_incorporates/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P43_has_dimension</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P43_has_dimension/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P105_right_held_by</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P105_right_held_by/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P104_is_subject_to</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P104_is_subject_to/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P67i_is_referred_to_by</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P67i_is_referred_to_by/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P70i_is_documented_in</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P70i_is_documented_in/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
			</td>
		</tr>
	</xsl:template>

	<xsl:template  match="rdf:Description[./rdf:type/@rdf:resource = 'http://www.cidoc-crm.org/cidoc-crm/E33_Linguistic_Object']" mode="minimalMetadata">
	<tr>
	<td>
	<strong>E33_Linguistic_Object</strong> : <strong><xsl:value-of select="./@rdf:about"/></strong><br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">Label</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./rdfs:label/text()"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P1_is_identified_by</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P1_is_identified_by/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P149_is_identified_by</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P149_is_identified_by/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P94i_was_created_by</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P94i_was_created_by/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P105_right_held_by</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P105_right_held_by/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P3_has_note</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P3_has_note/text()"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P72_has_language</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P72_has_language/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P73_has_translation</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P73_has_translation/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P129_is_about</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P129_is_about/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P43_has_dimension</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P43_has_dimension/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P106_is_composed_of</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P106_is_composed_of/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P165_incorporates</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P165_incorporates/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P106i_forms_part_of</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P106i_forms_part_of/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P104_is_subject_to</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P104_is_subject_to/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P67_refers_to</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P67_refers_to/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">PP67i_is_referred_to_by</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P67i_is_referred_to_by/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P70i_is_documented_in</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P106i_forms_part_of/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
	</td>
	</tr>
	</xsl:template>

	<xsl:template match="rdf:Description[./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE26_RI_Project']
	| rdf:Description[./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE35_Project']
	| rdf:Description[./rdf:type/@rdf:resource = 'http://www.cidoc-crm.org/cidoc-crm/E7_Activity']" mode="minimalMetadata">
		<tr>
			<td>
				<strong><xsl:value-of select="./@rdf:about"/></strong><br/>
				RDF types:
				<xsl:for-each select="./rdf:type/@rdf:resource">
					<strong><xsl:value-of select="tokenize(., '/')[last()]"/></strong><br/>
				</xsl:for-each>

				<xsl:call-template name="generalDescriptors"/>
				<br/>
				<xsl:call-template name="coverageDescriptors"/>
				<br/>
				<xsl:if test="./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE26_RI_Project' or ./rdf:type/@rdf:resource='http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE35_Project'">
					<xsl:call-template name="printProperty">
						<xsl:with-param name="propertyName">PP43_supported_project_activity</xsl:with-param>
						<xsl:with-param name="propertyValue">
							<xsl:value-of select="./crmpe:PP43_supported_project_activity/@rdf:resource"/>
						</xsl:with-param>
					</xsl:call-template>
					<xsl:if test="./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE26_RI_Project'">
						<br/>
						<xsl:call-template name="printProperty">
							<xsl:with-param name="propertyName">PP25_has_maintaining_RI</xsl:with-param>
							<xsl:with-param name="propertyValue">
								<xsl:value-of select="./crmpe:PP25_has_maintaining_RI/@rdf:resource"/>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:if>
					<br/>
					<xsl:call-template name="printProperty">
						<xsl:with-param name="propertyName">PP44_has_maintaining_team</xsl:with-param>
						<xsl:with-param name="propertyValue">
							<xsl:value-of select="./crmpe:PP44_has_maintaining_team/@rdf:resource"/>
						</xsl:with-param>
					</xsl:call-template>
					<br/>
				</xsl:if>
				<xsl:call-template name="activityContext"/>
			</td>
		</tr>
	</xsl:template>

	<xsl:template  match="rdf:Description[./rdf:type/@rdf:resource = 'http://www.cidoc-crm.org/cidoc-crm/E39_Actor']" mode="minimalMetadata">
		<tr>
			<td>
				<strong>E39_Actor</strong> : <strong><xsl:value-of select="./@rdf:about"/></strong><br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">Label</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./rdfs:label/text()"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P1_is_identified_by</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P1_is_identified_by/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P149_is_identified_by</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P149_is_identified_by/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P48_has_preferred_identifier</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P48_has_preferred_identifier/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P2_has_type</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P2_has_type/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P3_has_note</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P3_has_note/text()"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P98i_was_born</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P98i_was_born/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P100i_died_in</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P100i_died_in/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P74_has_current_or_former_residence</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P74_has_current_or_former_residence/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P107i_is_current_or_former_member_of</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P107i_is_current_or_former_member_of/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P76_has_contact_point</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P76_has_contact_point/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="rdf:Description[./rdf:type/@rdf:resource = 'http://www.cidoc-crm.org/cidoc-crm/E53_Place']" mode="minimalMetadata">
	<tr>
	<td>
	<strong>E53_Place</strong> : <strong><xsl:value-of select="./@rdf:about"/></strong><br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">Label</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./rdfs:label/text()"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P2_has_type</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P2_has_type/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P1_is_identified_by</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P1_is_identified_by/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P87_is_identified_by</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P87_is_identified_by/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P89_falls_within</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P89_falls_within/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:call-template name="printProperty">
			<xsl:with-param name="propertyName">P67i_is_referred_to_by</xsl:with-param>
			<xsl:with-param name="propertyValue">
				<xsl:value-of select="./crm:P67i_is_referred_to_by/@rdf:resource"/>
			</xsl:with-param>
		</xsl:call-template>
		</td>
	</tr>
	</xsl:template>

	<xsl:template match="rdf:Description[./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE2_Hosting_Service'] |
	                     rdf:Description[./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE3_Curating_Service'] |
						 rdf:Description[./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE5_Digital_Hosting_Service'] |
						 rdf:Description[./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE6_Software_Hosting_Service'] |
						 rdf:Description[./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE7_Data_Hosting_Service'] |
                         rdf:Description[./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE10_Digital_Curating_Service'] |
						 rdf:Description[./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE11_Software_Curating_Service'] |
                         rdf:Description[./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE12_Data_Curating_Service']" mode="minimalMetadata" priority="5">
	<tr>
		<td>
			<strong><xsl:value-of select="./@rdf:about"/></strong><br/>
			RDF types:
			<xsl:for-each select="./rdf:type/@rdf:resource">
				<strong><xsl:value-of select="tokenize(., '/')[last()]"/></strong><br/>
			</xsl:for-each>

			<xsl:call-template name="generalDescriptors"/>
			<br/>
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP1i_is_currently_offered_by</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crmpe:PP1i_is_currently_offered_by/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP42_has_declarative_time</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crmpe:PP42_has_declarative_time/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>
			<xsl:call-template name="coverageDescriptors"/>
			<br/>
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP2_provided_by</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crmpe:PP2_provided_by/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
			<br/>

			<xsl:call-template name="activityContext"/>
			<br/>
			<xsl:call-template name="printProperty">
				<xsl:with-param name="propertyName">PP45_has_competency</xsl:with-param>
				<xsl:with-param name="propertyValue">
					<xsl:value-of select="./crmpe:PP45_has_competency/@rdf:resource"/>
				</xsl:with-param>
			</xsl:call-template>
		</td>
	</tr>
</xsl:template>

	<xsl:template match="rdf:Description[./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE8_E-Service'] |
	                     rdf:Description[./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE13_Software_Computing_E-Service'] |
						 rdf:Description[./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE14_Software_Delivery_E-Service'] |
						 rdf:Description[./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE15_Data_E-Service'] |
						 rdf:Description[./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE16_Curated_Software_E-Service']" mode="minimalMetadata" priority="5">
		<tr>
			<td>
				<strong><xsl:value-of select="./@rdf:about"/></strong><br/>
				RDF types:
				<xsl:for-each select="./rdf:type/@rdf:resource">
					<strong><xsl:value-of select="tokenize(., '/')[last()]"/></strong><br/>
				</xsl:for-each>

				<xsl:call-template name="generalDescriptors"/>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">PP28_has_designated_access_point</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crmpe:PP28_has_designated_access_point/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">PP29_uses_access_protocol</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crmpe:PP29_uses_access_protocol/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P47_has_protocol_type</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crmpe:PP29_uses_access_protocol/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">PP48_uses_protocol_parameter</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crmpe:PP29_uses_access_protocol/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">PP1i_is_currently_offered_by</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crmpe:PP1i_is_currently_offered_by/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">PP42_has_declarative_time</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crmpe:PP42_has_declarative_time/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="coverageDescriptors"/>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">PP2_provided_by</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crmpe:PP2_provided_by/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>

				<xsl:call-template name="activityContext"/>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">PP45_has_competency</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crmpe:PP45_has_competency/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<xsl:call-template name="coverageDescriptors"/>
			</td>
		</tr>
	</xsl:template>

	<xsl:template mode="minimalMetadata"
	              match="rdf:Description[./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE22_Persistent_Dataset']
	                   | rdf:Description[./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE24_Volatile_Dataset']" >

		<tr>
			<td>
				<strong><xsl:value-of select="./@rdf:about"/></strong><br/>
				RDF types:
				<xsl:for-each select="./rdf:type/@rdf:resource">
					<strong><xsl:value-of select="tokenize(., '/')[last()]"/></strong><br/>
				</xsl:for-each>


				<xsl:call-template name="generalDescriptors"/>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P102_has_title</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P102_has_title/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P129_is_about</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P129_is_about/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P67_refers_to</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P67_refers_to/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">PP8i_is_dataset_hosted_by</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crmpe:PP8i_is_dataset_hosted_by/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName"
					>PP6i_is_digital_object_hosted_by</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crmpe:PP6i_is_digital_object_hosted_by/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">PP4i_is_object_hosted_by</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crmpe:PP4i_is_object_hosted_by/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">L11i_was_output_of</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crmdig:L11i_was_output_of/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">L10i_was_input_of</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crmdig:L10i_was_input_of/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P94i_was_created_by</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P94i_was_created_by/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">PP20_has_persistent_dataset_part</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crmpe:PP20_has_persistent_dataset_part/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">PP20i_is_persistent_dataset_part_of</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crmpe:PP20i_is_persistent_dataset_part_of/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">PP16_has_persistent_digital_object_part</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crmpe:PP16_has_persistent_digital_object_part/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">PP16i_is_persistent_digital_object_part_of</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crmpe:PP16i_is_persistent_digital_object_part_of/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">PP24i_is_dataset_snapshot_of</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crmpe:PP24i_is_dataset_snapshot_of/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P17i_is_snapshot_of</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crmpe:P17i_is_snapshot_of/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">PP18i_is_digital_object_part_of</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crmpe:PP18i_is_digital_object_part_of/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P106i_forms_part_of</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P106i_forms_part_of/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P106_is_composed_of</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P106_is_composed_of/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P165_incorporates</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P165_incorporates/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P43_has_dimension</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P43_has_dimension/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P105_right_held_by</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P105_right_held_by/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P104_is_subject_to</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P104_is_subject_to/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P67i_is_referred_to_by</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P67i_is_referred_to_by/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">P70i_is_documented_in</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crm:P70i_is_documented_in/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
			</td>
		</tr>

	</xsl:template>

	<xsl:template match="rdf:Description[./rdf:type/@rdf:resource = 'http://parthenos.d4science.org/CRMext/CRMpe.rdfs/PE1_Service']"
	              mode="minimalMetadata">
		<tr>
			<td>
				<strong>PE1_Service</strong> : <strong><xsl:value-of select="./@rdf:about"/></strong><br/>

				<xsl:call-template name="generalDescriptors"/>
				<br/>
				<xsl:call-template name="coverageDescriptors"/>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">PP2_provided_by</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crmpe:PP2_provided_by/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="printProperty">
					<xsl:with-param name="propertyName">PP42_has_declarative_time</xsl:with-param>
					<xsl:with-param name="propertyValue">
						<xsl:value-of select="./crmpe:PP42_has_declarative_time/@rdf:resource"/>
					</xsl:with-param>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="activityContext"/>
			</td>
		</tr>
	</xsl:template>

	<xsl:template name="printProperty">
		<xsl:param name="propertyName"/>
		<xsl:param name="propertyValue"/>
		<xsl:value-of select="concat($propertyName, ' : ', $propertyValue)"/>
	</xsl:template>

	<xsl:template name="xmlAttr">
		<span style="color:orange">
			<xsl:value-of select="concat(' ', local-name())"/>
		</span>
		<xsl:value-of select="concat('=&quot;', ., '&quot;')"/>
	</xsl:template>


	<xsl:template name="xmlItem">
		<xsl:param name="indent"/>
		<xsl:variable name="tag" select="name()"/>
		<xsl:variable name="newindent"><xsl:value-of select="$indent"/>&#160;&#160;&#160;&#160; </xsl:variable>

		<xsl:if test="string-length($tag)">
			<br/>
			<xsl:value-of select="$indent"/>
			<span style="color:blue">
				<xsl:value-of select="concat('&lt;', $tag)"/>
			</span>
			<xsl:for-each select="@*">
				<xsl:call-template name="xmlAttr"/>
			</xsl:for-each>
			<xsl:choose>
				<xsl:when test="count(child::*) = 0 and count(child::text()) = 1">
					<span style="color:blue">&gt;</span>
					<xsl:value-of select="normalize-space(.)"/>
					<span style="color:blue">
						<xsl:value-of select="concat('&lt;/', $tag, '&gt;')"/>
					</span>
				</xsl:when>
				<xsl:when test="count(child::* | child::text()) &gt; 0">
					<span style="color:blue">&gt;</span>
					<xsl:for-each select="child::* | child::text()">
						<xsl:choose>
							<xsl:when
									test="self::text() and string-length(normalize-space(.)) &gt; 0">
								<xsl:value-of select="normalize-space(.)"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="xmlItem">
									<xsl:with-param name="indent" select="$newindent"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
					<br/>
					<xsl:value-of select="$indent"/>
					<span style="color:blue">
						<xsl:value-of select="concat('&lt;/', $tag, '&gt;')"/>
					</span>
				</xsl:when>
				<xsl:otherwise>
					<span style="color:blue">&#160;/&gt;</span>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<!--
        Suppress warning messages "The source document is in no namespace, but the template rules
        all expect elements in a namespace" (see https://github.com/daisy/pipeline-mod-braille/issues/38)
    -->
	<xsl:template match="/phony">
		<xsl:next-match/>
	</xsl:template>


</xsl:stylesheet>
