package eu.dnetlib.parthenos.workflows.nodes;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URIBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class PublishJRRJobNode  extends AsyncJobNode {

	private static final Log log = LogFactory.getLog(PublishJRRJobNode.class);

	private String publisherEndpoint;
	private String typeNamespace;
	private String typeName;
	private String datasourceName;
	private String datasourceInterface;

	private RestTemplate restTemplate;


	@Override
	protected String execute(final Env env) throws Exception {

		UriComponentsBuilder builder = UriComponentsBuilder.fromUriString(getPublisherEndpoint()+"/publishJRR")
				.queryParam("typeNamespace", typeNamespace)
				.queryParam("typeName", typeName)
				.queryParam("datasourceApi", datasourceInterface)
				.queryParam("datasourceName", datasourceName);
		URI uri = builder.build().toUri();
		System.out.println("Request goes to  " + uri.toString());
		RestTemplate restTemplate = new RestTemplate();
		ResponseEntity<Integer> res = restTemplate.exchange(uri, HttpMethod.POST, null, Integer.class);
		if(res.getStatusCode().is2xxSuccessful()){
			int resolved = res.getBody();
			log.info(String.format("%d entries of type %s published on JRR for API %s", resolved, typeName, datasourceInterface));
			env.setAttribute(WorkflowsConstants.MAIN_LOG_PREFIX+typeName+"_published", resolved);
			return Arc.DEFAULT_ARC;
		}
		else{
			log.warn(String.format("Entries of type %s could not be published on JRR for API %s", typeName, datasourceInterface));
			env.setAttribute(WorkflowsConstants.MAIN_LOG_PREFIX+"error", res.getStatusCode().getReasonPhrase());
			return Arc.DEFAULT_ARC;
		}
	}

	public String getPublisherEndpoint() {
		return publisherEndpoint;
	}

	public void setPublisherEndpoint(final String publisherEndpoint) {
		this.publisherEndpoint = publisherEndpoint;
	}

	public String getTypeNamespace() {
		return typeNamespace;
	}

	public void setTypeNamespace(final String typeNamespace) {
		this.typeNamespace = typeNamespace;
	}

	public String getTypeName() {
		return typeName;
	}

	public void setTypeName(final String typeName) {
		this.typeName = typeName;
	}

	public RestTemplate getRestTemplate() {
		return restTemplate;
	}

	public void setRestTemplate(final RestTemplate restTemplate) {
		this.restTemplate = restTemplate;
	}

	public String getDatasourceName() {
		return datasourceName;
	}

	public void setDatasourceName(final String datasourceName) {
		this.datasourceName = datasourceName;
	}

	public String getDatasourceInterface() {
		return datasourceInterface;
	}

	public void setDatasourceInterface(final String datasourceInterface) {
		this.datasourceInterface = datasourceInterface;
	}
}
