/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.parthenos.workflows.nodes;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class PublishJRRJobNode
extends AsyncJobNode {
    private static final Log log = LogFactory.getLog(PublishJRRJobNode.class);
    private String publisherEndpoint;
    private String typeNamespace;
    private String typeName;
    private String datasourceName;
    private String datasourceInterface;
    private RestTemplate restTemplate;

    protected String execute(Env env) throws Exception {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)(this.getPublisherEndpoint() + "/publishJRR")).queryParam("typeNamespace", new Object[]{this.typeNamespace}).queryParam("typeName", new Object[]{this.typeName}).queryParam("datasourceApi", new Object[]{this.datasourceInterface}).queryParam("datasourceName", new Object[]{this.datasourceName});
        URI uri = builder.build().toUri();
        System.out.println("Request goes to  " + uri.toString());
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity res = restTemplate.exchange(uri, HttpMethod.POST, null, Integer.class);
        if (res.getStatusCode().is2xxSuccessful()) {
            int resolved = (Integer)res.getBody();
            log.info((Object)String.format("%d entries of type %s published on JRR for API %s", resolved, this.typeName, this.datasourceInterface));
            env.setAttribute("mainlog:" + this.typeName + "_published", (Object)resolved);
            return Arc.DEFAULT_ARC;
        }
        log.warn((Object)String.format("Entries of type %s could not be published on JRR for API %s", this.typeName, this.datasourceInterface));
        env.setAttribute("mainlog:error", (Object)res.getStatusCode().getReasonPhrase());
        return Arc.DEFAULT_ARC;
    }

    public String getPublisherEndpoint() {
        return this.publisherEndpoint;
    }

    public void setPublisherEndpoint(String publisherEndpoint) {
        this.publisherEndpoint = publisherEndpoint;
    }

    public String getTypeNamespace() {
        return this.typeNamespace;
    }

    public void setTypeNamespace(String typeNamespace) {
        this.typeNamespace = typeNamespace;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public String getDatasourceName() {
        return this.datasourceName;
    }

    public void setDatasourceName(String datasourceName) {
        this.datasourceName = datasourceName;
    }

    public String getDatasourceInterface() {
        return this.datasourceInterface;
    }

    public void setDatasourceInterface(String datasourceInterface) {
        this.datasourceInterface = datasourceInterface;
    }
}

